/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.interfaces.NameNode;

public class NameNodeDelegate
extends AbstractForwardingNode
implements NameNode {
    private final NodeDelegate mDelegate;
    private int mPrefixKey;
    private int mLocalNameKey;
    private int mUriKey;
    private long mPathNodeKey;

    public NameNodeDelegate(NodeDelegate delegate, int uriKey, int prefixKey, int localNameKey, @Nonnegative long pathNodeKey) {
        assert (delegate != null) : "delegate must not be null!";
        this.mDelegate = delegate;
        this.mPrefixKey = prefixKey;
        this.mLocalNameKey = localNameKey;
        this.mUriKey = uriKey;
        assert (pathNodeKey >= 0L) : "pathNodeKey may not be < 0!";
        this.mPathNodeKey = pathNodeKey;
    }

    public NameNodeDelegate(NameNodeDelegate nameDel) {
        this.mDelegate = nameDel.mDelegate;
        this.mPrefixKey = nameDel.mPrefixKey;
        this.mLocalNameKey = nameDel.mLocalNameKey;
        this.mUriKey = nameDel.mUriKey;
        this.mPathNodeKey = nameDel.mPathNodeKey;
    }

    @Override
    public Kind getKind() {
        return Kind.UNKNOWN;
    }

    @Override
    public int getLocalNameKey() {
        return this.mLocalNameKey;
    }

    @Override
    public int getURIKey() {
        return this.mUriKey;
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.mLocalNameKey = localNameKey;
    }

    @Override
    public void setURIKey(int uriKey) {
        this.mUriKey = uriKey;
    }

    @Override
    public void setPathNodeKey(@Nonnegative long pathNodeKey) {
        assert (pathNodeKey >= 0L) : "pathNodeKey may not be < 0!";
        this.mPathNodeKey = pathNodeKey;
    }

    @Override
    public long getPathNodeKey() {
        return this.mPathNodeKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mUriKey, this.mPrefixKey, this.mLocalNameKey});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NameNodeDelegate)) {
            return false;
        }
        NameNodeDelegate other = (NameNodeDelegate)obj;
        return Objects.equal((Object)this.mUriKey, (Object)other.mUriKey) && Objects.equal((Object)this.mPrefixKey, (Object)other.mPrefixKey) && Objects.equal((Object)this.mLocalNameKey, (Object)other.mLocalNameKey);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.mDelegate).add("uriKey", this.mUriKey).add("prefixKey", this.mPrefixKey).add("localNameKey", this.mLocalNameKey).add("pathNodeKey", this.mPathNodeKey).toString();
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mDelegate;
    }

    @Override
    public long getRevision() {
        return this.mDelegate.getRevision();
    }

    @Override
    public int getPrefixKey() {
        return this.mPrefixKey;
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.mPrefixKey = prefixKey;
    }

    @Override
    public QNm getName() {
        return null;
    }
}

