/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.file;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.sirix.exception.SirixIOException;
import org.sirix.io.AbstractForwardingReader;
import org.sirix.io.Reader;
import org.sirix.io.Writer;
import org.sirix.io.bytepipe.ByteHandler;
import org.sirix.io.file.FileReader;
import org.sirix.page.PagePersister;
import org.sirix.page.PageReference;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.SerializationType;
import org.sirix.page.UberPage;
import org.sirix.page.interfaces.Page;

public final class FileWriter
extends AbstractForwardingReader
implements Writer {
    private final RandomAccessFile mDataFile;
    private final FileReader mReader;
    private final SerializationType mType;
    private final RandomAccessFile mRevisionsOffsetFile;
    private final PagePersister mPagePersister;

    public FileWriter(RandomAccessFile dataFile, RandomAccessFile revisionsOffsetFile, ByteHandler handler, SerializationType serializationType, PagePersister pagePersister) {
        this.mDataFile = (RandomAccessFile)Preconditions.checkNotNull((Object)dataFile);
        this.mType = (SerializationType)((Object)Preconditions.checkNotNull((Object)((Object)serializationType)));
        this.mRevisionsOffsetFile = this.mType == SerializationType.DATA ? (RandomAccessFile)Preconditions.checkNotNull((Object)revisionsOffsetFile) : null;
        this.mPagePersister = (PagePersister)Preconditions.checkNotNull((Object)pagePersister);
        this.mReader = new FileReader(dataFile, revisionsOffsetFile, handler, serializationType, pagePersister);
    }

    @Override
    public Writer truncateTo(int revision) {
        UberPage uberPage = (UberPage)this.mReader.readUberPageReference().getPage();
        while (uberPage.getRevisionNumber() != revision) {
            if ((uberPage = (UberPage)this.mReader.read(new PageReference().setKey(uberPage.getPreviousUberPageKey()), null)).getRevisionNumber() != revision) continue;
            try {
                this.mDataFile.setLength(uberPage.getPreviousUberPageKey());
                break;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this;
    }

    @Override
    public FileWriter write(PageReference pageReference) throws SirixIOException {
        try {
            byte[] serializedPage;
            Page page = pageReference.getPage();
            assert (page != null);
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 DataOutputStream dataOutput = new DataOutputStream(this.mReader.mByteHandler.serialize(output));){
                this.mPagePersister.serializePage(dataOutput, page, this.mType);
                dataOutput.flush();
                serializedPage = output.toByteArray();
            }
            byte[] writtenPage = new byte[serializedPage.length + 4];
            ByteBuffer buffer = ByteBuffer.allocate(writtenPage.length);
            buffer.putInt(serializedPage.length);
            buffer.put(serializedPage);
            buffer.position(0);
            buffer.get(writtenPage, 0, writtenPage.length);
            long fileSize = this.mDataFile.length();
            long offset = fileSize == 0L ? 12L : fileSize;
            this.mDataFile.seek(offset);
            this.mDataFile.write(writtenPage);
            switch (this.mType) {
                case DATA: {
                    pageReference.setKey(offset);
                    break;
                }
                case TRANSACTION_INTENT_LOG: {
                    pageReference.setPersistentLogKey(offset);
                    break;
                }
            }
            pageReference.setLength(writtenPage.length);
            pageReference.setHash(this.mReader.mHashFunction.hashBytes(writtenPage).asBytes());
            if (this.mType == SerializationType.DATA && page instanceof RevisionRootPage) {
                this.mRevisionsOffsetFile.seek(this.mRevisionsOffsetFile.length());
                this.mRevisionsOffsetFile.writeLong(offset);
            }
            return this;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() throws SirixIOException {
        try {
            if (this.mDataFile != null) {
                this.mDataFile.close();
            }
            if (this.mRevisionsOffsetFile != null) {
                this.mRevisionsOffsetFile.close();
            }
            if (this.mReader != null) {
                this.mReader.close();
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Writer writeUberPageReference(PageReference pageReference) throws SirixIOException {
        try {
            this.write(pageReference);
            this.mDataFile.seek(0L);
            this.mDataFile.writeLong(pageReference.getKey());
            return this;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    protected Reader delegate() {
        return this.mReader;
    }

    @Override
    public Writer truncate() {
        try {
            this.mDataFile.setLength(0L);
            this.mRevisionsOffsetFile.setLength(0L);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        return this;
    }
}

