/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.bytepipe;

import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.streamingaead.StreamingAeadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.sirix.access.ResourceConfiguration;
import org.sirix.io.bytepipe.ByteHandler;

public final class Encryptor
implements ByteHandler {
    private static final byte[] mAssociatedData;
    private StreamingAead mStreamingAead;
    private KeysetHandle mKeySetHandle;
    private final Path mResourcePath;

    public Encryptor(Path resourcePath) {
        this.mResourcePath = Objects.requireNonNull(resourcePath);
    }

    public Path getResourcePath() {
        return this.mResourcePath;
    }

    @Override
    public OutputStream serialize(OutputStream toSerialize) {
        try {
            StreamingAead aead = this.getStreamingAead();
            return aead.newEncryptingStream(toSerialize, mAssociatedData);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private StreamingAead getStreamingAead() throws GeneralSecurityException {
        if (this.mStreamingAead == null) {
            this.mStreamingAead = StreamingAeadFactory.getPrimitive((KeysetHandle)this.getKeysetHandle());
        }
        return this.mStreamingAead;
    }

    private KeysetHandle getKeysetHandle() {
        if (this.mKeySetHandle == null) {
            this.mKeySetHandle = Encryptor.getKeysetHandle(this.mResourcePath.resolve(ResourceConfiguration.ResourcePaths.ENCRYPTION_KEY.getPath()).resolve("encryptionKey.json"));
        }
        return this.mKeySetHandle;
    }

    @Override
    public InputStream deserialize(InputStream toDeserialize) {
        try {
            StreamingAead aead = this.getStreamingAead();
            return aead.newDecryptingStream(toDeserialize, mAssociatedData);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ByteHandler create(Path resourcePath) {
        return Encryptor.createInstance(resourcePath);
    }

    private static ByteHandler createInstance(Path resourcePath) {
        return new Encryptor(resourcePath);
    }

    public int hashCode() {
        return this.mResourcePath.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Encryptor)) {
            return false;
        }
        Encryptor otherEncryptor = (Encryptor)other;
        return this.mResourcePath.equals(otherEncryptor.mResourcePath);
    }

    @Override
    public ByteHandler getInstance() {
        return Encryptor.createInstance(this.mResourcePath);
    }

    private static KeysetHandle getKeysetHandle(Path keyPath) {
        try {
            if (Files.exists(keyPath, new LinkOption[0])) {
                return CleartextKeysetHandle.read((KeysetReader)JsonKeysetReader.withPath((Path)keyPath));
            }
            throw new AssertionError((Object)"No file for encryption key found.");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        try {
            TinkConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        mAssociatedData = new byte[0];
    }
}

