/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path.summary;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;

public class PathNode
extends AbstractStructForwardingNode
implements NameNode {
    private final NodeDelegate mNodeDel;
    private final StructNodeDelegate mStructNodeDel;
    private final NameNodeDelegate mNameNodeDel;
    private final Kind mKind;
    private int mReferences;
    private int mLevel;

    public PathNode(NodeDelegate nodeDel, @Nonnull StructNodeDelegate structNodeDel, @Nonnull NameNodeDelegate nameNodeDel, @Nonnull Kind kind, @Nonnegative int references, @Nonnegative int level) {
        this.mNodeDel = (NodeDelegate)Preconditions.checkNotNull((Object)nodeDel);
        this.mStructNodeDel = (StructNodeDelegate)Preconditions.checkNotNull((Object)structNodeDel);
        this.mNameNodeDel = (NameNodeDelegate)Preconditions.checkNotNull((Object)nameNodeDel);
        this.mKind = (Kind)Preconditions.checkNotNull((Object)kind);
        Preconditions.checkArgument((references > 0 ? 1 : 0) != 0, (Object)"references must be > 0!");
        this.mReferences = references;
        this.mLevel = level;
    }

    public Path<QNm> getPath(PathSummaryReader reader) {
        PathNode node = this;
        long nodeKey = reader.getNodeKey();
        reader.moveTo(node.getNodeKey());
        PathNode[] path = new PathNode[this.mLevel];
        for (int i = this.mLevel - 1; i >= 0; --i) {
            path[i] = node;
            node = reader.moveToParent().trx().getPathNode();
        }
        Path p = new Path();
        for (PathNode n : path) {
            reader.moveTo(n.getNodeKey());
            if (n.getPathKind() == Kind.ELEMENT) {
                p.child((Object)reader.getName());
                continue;
            }
            p.attribute((Object)reader.getName());
        }
        reader.moveTo(nodeKey);
        return p;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public int getReferences() {
        return this.mReferences;
    }

    public void setReferenceCount(@Nonnegative int references) {
        Preconditions.checkArgument((references > 0 ? 1 : 0) != 0, (Object)"pReferences must be > 0!");
        this.mReferences = references;
    }

    public void incrementReferenceCount() {
        ++this.mReferences;
    }

    public void decrementReferenceCount() {
        if (this.mReferences <= 1) {
            throw new IllegalStateException();
        }
        --this.mReferences;
    }

    public Kind getPathKind() {
        return this.mKind;
    }

    @Override
    public Kind getKind() {
        return Kind.PATH;
    }

    @Override
    public int getPrefixKey() {
        return this.mNameNodeDel.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.mNameNodeDel.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.mNameNodeDel.getURIKey();
    }

    @Override
    public void setLocalNameKey(int nameKey) {
        this.mNameNodeDel.setLocalNameKey(nameKey);
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.mNameNodeDel.setPrefixKey(prefixKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.mNameNodeDel.setURIKey(uriKey);
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mNodeDel;
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.mNameNodeDel;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeDel, this.mNameNodeDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PathNode) {
            PathNode other = (PathNode)obj;
            return Objects.equal((Object)this.mNodeDel, (Object)other.mNodeDel) && Objects.equal((Object)this.mNameNodeDel, (Object)other.mNameNodeDel);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.mNodeDel).add("struct delegate", (Object)this.mStructNodeDel).add("name delegate", (Object)this.mNameNodeDel).add("references", this.mReferences).add("kind", (Object)this.mKind).add("level", this.mLevel).toString();
    }

    @Override
    public void setPathNodeKey(long pNodeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPathNodeKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QNm getName() {
        throw new UnsupportedOperationException();
    }
}

