/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path;

import java.util.Optional;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.exception.SirixIOException;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.immutable.ImmutableNode;

public final class PathIndexListener {
    private final AVLTreeWriter<Long, NodeReferences> mAVLTreeWriter;
    private final PathSummaryReader mPathSummaryReader;
    private final Set<Path<QNm>> mPaths;

    public PathIndexListener(Set<Path<QNm>> paths, PathSummaryReader pathSummaryReader, AVLTreeWriter<Long, NodeReferences> avlTreeWriter) {
        this.mAVLTreeWriter = avlTreeWriter;
        this.mPathSummaryReader = pathSummaryReader;
        this.mPaths = paths;
    }

    public void listen(XmlIndexController.ChangeType type, ImmutableNode node, long pathNodeKey) {
        this.mPathSummaryReader.moveTo(pathNodeKey);
        try {
            switch (type) {
                case INSERT: {
                    if (!this.mPathSummaryReader.getPCRsForPaths(this.mPaths, false).contains(pathNodeKey)) break;
                    Optional<NodeReferences> textReferences = this.mAVLTreeWriter.get(pathNodeKey, SearchMode.EQUAL);
                    if (textReferences.isPresent()) {
                        this.setNodeReferences(node, textReferences.get(), pathNodeKey);
                        break;
                    }
                    this.setNodeReferences(node, new NodeReferences(), pathNodeKey);
                    break;
                }
                case DELETE: {
                    if (!this.mPathSummaryReader.getPCRsForPaths(this.mPaths, false).contains(pathNodeKey)) break;
                    this.mAVLTreeWriter.remove(pathNodeKey, node.getNodeKey());
                    break;
                }
            }
        }
        catch (PathException e) {
            throw new SirixIOException(e);
        }
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, long pathNodeKey) throws SirixIOException {
        this.mAVLTreeWriter.index(pathNodeKey, references.addNodeKey(node.getNodeKey()), AVLTreeReader.MoveCursor.NO_MOVE);
    }
}

