/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.index.ChangeListener;
import org.sirix.index.Filter;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexFilterAxis;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.PathFilter;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;

public interface PathIndex<B, L extends ChangeListener> {
    public B createBuilder(PageTrx<Long, Record, UnorderedKeyValuePage> var1, PathSummaryReader var2, IndexDef var3);

    public L createListener(PageTrx<Long, Record, UnorderedKeyValuePage> var1, PathSummaryReader var2, IndexDef var3);

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, PathFilter filter) {
        AVLTreeReader reader = AVLTreeReader.getInstance(pageRtx, indexDef.getType(), indexDef.getID());
        if (filter.getPCRs().size() == 1) {
            Optional optionalNodeReferences = reader.get(filter.getPCRs().iterator().next(), SearchMode.EQUAL);
            return Iterators.forArray((Object[])new NodeReferences[]{optionalNodeReferences.orElse(new NodeReferences())});
        }
        AVLTreeReader aVLTreeReader = reader;
        Objects.requireNonNull(aVLTreeReader);
        AVLTreeReader.AVLNodeIterator iter = aVLTreeReader.new AVLTreeReader.AVLNodeIterator(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        ImmutableSet setFilter = filter == null ? ImmutableSet.of() : ImmutableSet.of((Object)filter);
        return new IndexFilterAxis(iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)setFilter)));
    }
}

