/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.name;

import java.util.Optional;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.exception.SirixIOException;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class NameIndexBuilder {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(NameIndexBuilder.class));
    public Set<QNm> mIncludes;
    public Set<QNm> mExcludes;
    public AVLTreeWriter<QNm, NodeReferences> mAVLTreeWriter;

    public NameIndexBuilder(Set<QNm> includes, Set<QNm> excludes, AVLTreeWriter<QNm, NodeReferences> avlTreeWriter) {
        this.mIncludes = includes;
        this.mExcludes = excludes;
        this.mAVLTreeWriter = avlTreeWriter;
    }

    public VisitResultType build(QNm name, ImmutableNode node) {
        boolean excluded;
        boolean included = this.mIncludes.isEmpty() || this.mIncludes.contains(name);
        boolean bl = excluded = !this.mExcludes.isEmpty() && this.mExcludes.contains(name);
        if (!included || excluded) {
            return VisitResultType.CONTINUE;
        }
        Optional<NodeReferences> textReferences = this.mAVLTreeWriter.get(name, SearchMode.EQUAL);
        try {
            textReferences.ifPresentOrElse(nodeReferences -> this.setNodeReferences(node, (NodeReferences)nodeReferences, name), () -> this.setNodeReferences(node, new NodeReferences(), name));
        }
        catch (SirixIOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, QNm name) {
        this.mAVLTreeWriter.index(name, references.addNodeKey(node.getNodeKey()), AVLTreeReader.MoveCursor.NO_MOVE);
    }
}

