/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas.xdm;

import org.sirix.access.trx.node.xml.AbstractXdmNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.index.cas.CASIndexBuilder;
import org.sirix.node.immutable.xdm.ImmutableAttributeNode;
import org.sirix.node.immutable.xdm.ImmutableText;

final class XdmCASIndexBuilder
extends AbstractXdmNodeVisitor {
    private final CASIndexBuilder mIndexBuilderDelegate;
    private final XmlNodeReadOnlyTrx mRtx;

    XdmCASIndexBuilder(CASIndexBuilder indexBuilderDelegate, XmlNodeReadOnlyTrx rtx) {
        this.mIndexBuilderDelegate = indexBuilderDelegate;
        this.mRtx = rtx;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        this.mRtx.moveTo(node.getParentKey());
        long PCR = this.mRtx.isDocumentRoot() ? 0L : this.mRtx.getNameNode().getPathNodeKey();
        return this.mIndexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableAttributeNode node) {
        long PCR = this.mRtx.isDocumentRoot() ? 0L : this.mRtx.getNameNode().getPathNodeKey();
        return this.mIndexBuilderDelegate.process(node, PCR);
    }
}

