/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas;

import java.util.Optional;
import java.util.Set;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.brackit.xquery.xdm.Type;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.exception.SirixIOException;
import org.sirix.exception.SirixRuntimeException;
import org.sirix.index.AtomicUtil;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.immutable.ImmutableNode;

public final class CASIndexListener {
    private final AVLTreeWriter<CASValue, NodeReferences> mAVLTreeWriter;
    private final PathSummaryReader mPathSummaryReader;
    private final Set<Path<QNm>> mPaths;
    private final Type mType;

    public CASIndexListener(PathSummaryReader pathSummaryReader, AVLTreeWriter<CASValue, NodeReferences> avlTreeWriter, Set<Path<QNm>> paths, Type type) {
        this.mPathSummaryReader = pathSummaryReader;
        this.mAVLTreeWriter = avlTreeWriter;
        this.mPaths = paths;
        this.mType = type;
    }

    public void listen(XmlIndexController.ChangeType type, ImmutableNode node, long pathNodeKey, Str value) {
        this.mPathSummaryReader.moveTo(pathNodeKey);
        try {
            switch (type) {
                case INSERT: {
                    if (!this.mPathSummaryReader.getPCRsForPaths(this.mPaths, false).contains(pathNodeKey)) break;
                    this.insert(node, pathNodeKey, value);
                    break;
                }
                case DELETE: {
                    if (!this.mPathSummaryReader.getPCRsForPaths(this.mPaths, false).contains(pathNodeKey)) break;
                    this.mAVLTreeWriter.remove(new CASValue((Atomic)value, this.mType, pathNodeKey), node.getNodeKey());
                    break;
                }
            }
        }
        catch (PathException e) {
            throw new SirixIOException(e);
        }
    }

    private void insert(ImmutableNode node, long pathNodeKey, Str value) throws SirixIOException {
        boolean isOfType = false;
        try {
            AtomicUtil.toType((Atomic)value, this.mType);
            isOfType = true;
        }
        catch (SirixRuntimeException sirixRuntimeException) {
            // empty catch block
        }
        if (isOfType) {
            CASValue indexValue = new CASValue((Atomic)value, this.mType, pathNodeKey);
            Optional<NodeReferences> textReferences = this.mAVLTreeWriter.get(indexValue, SearchMode.EQUAL);
            if (textReferences.isPresent()) {
                this.setNodeReferences(node, textReferences.get(), indexValue);
            } else {
                this.setNodeReferences(node, new NodeReferences(), indexValue);
            }
        }
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, CASValue indexValue) {
        this.mAVLTreeWriter.index(indexValue, references.addNodeKey(node.getNodeKey()), AVLTreeReader.MoveCursor.NO_MOVE);
    }
}

