/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas;

import java.util.Objects;
import java.util.Set;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.sirix.index.Filter;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.PCRCollector;
import org.sirix.index.path.PathFilter;

public final class CASFilter
implements Filter {
    private final Set<Path<QNm>> mPaths;
    private final PathFilter mPathFilter;
    private final Atomic mKey;
    private final SearchMode mMode;

    public CASFilter(Set<Path<QNm>> paths, Atomic key, SearchMode mode, PCRCollector pcrCollector) {
        this.mPaths = Objects.requireNonNull(paths);
        this.mPathFilter = new PathFilter(this.mPaths, pcrCollector);
        this.mKey = Objects.requireNonNull(key);
        this.mMode = Objects.requireNonNull(mode);
    }

    public Set<Long> getPCRs() {
        return this.mPathFilter.getPCRs();
    }

    public PCRCollector getPCRCollector() {
        return this.mPathFilter.getPCRCollector();
    }

    public SearchMode getMode() {
        return this.mMode;
    }

    public Atomic getKey() {
        return this.mKey;
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(AVLNode<K, NodeReferences> node) {
        K key = node.getKey();
        if (key instanceof CASValue) {
            CASValue casValue = (CASValue)key;
            if (this.mPathFilter.filter(node) && this.mMode.compare(this.mKey, casValue.getAtomicValue()) == 0) {
                return true;
            }
        }
        return false;
    }
}

