/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.bplustree;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.node.interfaces.Record;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.SerializationType;
import org.sirix.page.interfaces.KeyValuePage;

public class BPlusLeafNodePage<K extends Comparable<? super K> & Record, V extends Record>
implements KeyValuePage<K, V> {
    private final long mRecordPageKey;
    private final Map<K, V> mRecords;
    private final PageReadOnlyTrx mPageReadTrx;
    private Optional<PageReference> mLeftPage;
    private Optional<PageReference> mRightPage;
    private PageKind mPageKind;

    public BPlusLeafNodePage(@Nonnegative long recordPageKey, PageKind pageKind, long previousPageRefKey, PageReadOnlyTrx pageReadTrx) {
        assert (recordPageKey >= 0L) : "recordPageKey must not be negative!";
        assert (pageKind != null);
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.mRecordPageKey = recordPageKey;
        this.mRecords = new TreeMap();
        this.mPageReadTrx = pageReadTrx;
        this.mLeftPage = Optional.empty();
        this.mRightPage = Optional.empty();
        this.mPageKind = pageKind;
    }

    protected BPlusLeafNodePage(ByteArrayDataInput in, PageReadOnlyTrx pageReadTrx) {
        this.mRecordPageKey = in.readLong();
        int size = in.readInt();
        this.mRecords = new TreeMap();
        pageReadTrx.getResourceManager().getResourceConfig();
        for (int offset = 0; offset < size; ++offset) {
        }
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.mPageReadTrx = pageReadTrx;
        this.mPageKind = PageKind.getKind(in.readByte());
    }

    public void setLeftPage(Optional<PageReference> leftPage) {
        this.mLeftPage = leftPage;
    }

    public void setRightPage(Optional<PageReference> rightPage) {
        this.mLeftPage = rightPage;
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        out.writeLong(this.mRecordPageKey);
        this.serializePointer(this.mLeftPage, out);
        this.serializePointer(this.mRightPage, out);
        this.mPageReadTrx.getResourceManager().getResourceConfig();
        for (Map.Entry<K, V> entry : this.mRecords.entrySet()) {
        }
    }

    private void serializePointer(Optional<PageReference> page, DataOutput out) throws IOException {
        if (page.isPresent()) {
            out.writeBoolean(page.get().getKey() != -15L);
        } else {
            out.writeBoolean(false);
        }
    }

    public <KE extends Comparable<? super KE>, VA extends Record, S extends KeyValuePage<KE, VA>> void commit(PageTrx<KE, VA, S> pageWriteTrx) {
    }

    @Override
    public PageReference getReference(@Nonnegative int offset) {
        return null;
    }

    @Override
    public void setReference(int offset, PageReference pageReference) {
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mRecords.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.mRecords.values();
    }

    @Override
    public long getPageKey() {
        return this.mRecordPageKey;
    }

    @Override
    public V getValue(K key) {
        return (V)((Record)this.mRecords.get(key));
    }

    @Override
    public void setEntry(K key, @Nullable V value) {
        this.mRecords.put(key, value);
    }

    @Override
    public <C extends KeyValuePage<K, V>> C newInstance(@Nonnegative long recordPageKey, PageKind pageKind, long previousPageRefKey, PageReadOnlyTrx pageReadTrx) {
        return (C)new BPlusLeafNodePage<K, V>(recordPageKey, pageKind, previousPageRefKey, pageReadTrx);
    }

    @Override
    public PageReadOnlyTrx getPageReadTrx() {
        return this.mPageReadTrx;
    }

    @Override
    public PageKind getPageKind() {
        return this.mPageKind;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Set<Map.Entry<K, PageReference>> referenceEntrySet() {
        return null;
    }

    @Override
    public void setPageReference(K key, PageReference reference) {
    }

    @Override
    public PageReference getPageReference(K key) {
        return null;
    }

    @Override
    public long getPreviousReferenceKey() {
        return -1L;
    }

    @Override
    public List<PageReference> getReferences() {
        return null;
    }

    public static enum Kind {
        LEAF,
        INNERNODE;

    }
}

