/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.avltree;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Optional;
import javax.annotation.Nonnegative;
import org.sirix.access.trx.node.Move;
import org.sirix.api.NodeCursor;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.exception.SirixIOException;
import org.sirix.index.IndexType;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.interfaces.References;
import org.sirix.node.Kind;
import org.sirix.node.NullNode;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.xdm.XdmDocumentRootNode;
import org.sirix.page.PageKind;
import org.sirix.settings.Fixed;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class AVLTreeReader<K extends Comparable<? super K>, V extends References>
implements NodeCursor {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(AVLTreeReader.class));
    private boolean mClosed;
    private Node mCurrentNode;
    final PageReadOnlyTrx mPageReadTrx;
    final PageKind mPageKind;
    final int mIndex;

    private AVLTreeReader(PageReadOnlyTrx pageReadTrx, IndexType type, int index) {
        this.mPageReadTrx = (PageReadOnlyTrx)Preconditions.checkNotNull((Object)pageReadTrx);
        switch (type) {
            case PATH: {
                this.mPageKind = PageKind.PATHPAGE;
                break;
            }
            case CAS: {
                this.mPageKind = PageKind.CASPAGE;
                break;
            }
            case NAME: {
                this.mPageKind = PageKind.NAMEPAGE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.mClosed = false;
        this.mIndex = index;
        try {
            Optional<? extends Record> node = this.mPageReadTrx.getRecord(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.mPageKind, index);
            if (!node.isPresent()) {
                throw new IllegalStateException("Node couldn't be fetched from persistent storage!");
            }
            this.mCurrentNode = (Node)node.get();
        }
        catch (SirixIOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    public static <K extends Comparable<? super K>, V extends References> AVLTreeReader<K, V> getInstance(PageReadOnlyTrx pageReadTrx, IndexType type, @Nonnegative int index) {
        return new AVLTreeReader<K, V>(pageReadTrx, type, index);
    }

    public void dump(PrintStream out) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((XdmDocumentRootNode)this.getNode()).hasFirstChild()) {
            return;
        }
        this.moveToFirstChild();
        this.internalDump(out);
    }

    private void internalDump(PrintStream out) {
        out.println(this.getAVLNode());
        long nodeKey = this.getAVLNode().getNodeKey();
        if (this.getAVLNode().hasLeftChild()) {
            this.moveToFirstChild();
            this.internalDump(out);
        }
        this.moveTo(nodeKey);
        if (this.getAVLNode().hasRightChild()) {
            this.moveToLastChild();
            this.internalDump(out);
        }
    }

    AVLNode<K, V> getAVLNode() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() != Kind.XDM_DOCUMENT) {
            AVLNode node = (AVLNode)this.mCurrentNode;
            return node;
        }
        return null;
    }

    public Optional<V> get(long startNodeKey, K key, SearchMode mode) {
        this.assertNotClosed();
        boolean movedToStartNode = this.moveTo(startNodeKey).hasMoved();
        if (!movedToStartNode) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        AVLNode<K, V> node = this.getAVLNode();
        while (true) {
            boolean moved;
            int c;
            if ((c = mode.compare(key, node.getKey())) == 0) {
                return Optional.ofNullable((References)node.getValue());
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild().hasMoved() : this.moveToLastChild().hasMoved();
            if (!moved) break;
            node = this.getAVLNode();
        }
        return Optional.empty();
    }

    public Optional<V> get(K key, SearchMode mode) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((XdmDocumentRootNode)this.getNode()).hasFirstChild()) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        AVLNode<K, V> node = this.getAVLNode();
        while (true) {
            boolean moved;
            int c;
            if ((c = mode.compare(key, node.getKey())) == 0) {
                return Optional.ofNullable((References)node.getValue());
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild().hasMoved() : this.moveToLastChild().hasMoved();
            if (!moved) break;
            node = this.getAVLNode();
        }
        return Optional.empty();
    }

    public Optional<AVLNode<K, V>> getAVLNode(long startNodeKey, K key, SearchMode mode) {
        this.assertNotClosed();
        boolean movedToStartNode = this.moveTo(startNodeKey).hasMoved();
        if (!movedToStartNode) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        AVLNode<K, V> node = this.getAVLNode();
        while (true) {
            boolean moved;
            int c;
            if ((c = mode.compare(key, node.getKey())) == 0) {
                return Optional.ofNullable(node);
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild().hasMoved() : this.moveToLastChild().hasMoved();
            if (!moved) break;
            node = this.getAVLNode();
        }
        return Optional.empty();
    }

    public Optional<AVLNode<K, V>> getAVLNode(K key, SearchMode mode) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((XdmDocumentRootNode)this.getNode()).hasFirstChild()) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        AVLNode<K, V> node = this.getAVLNode();
        while (true) {
            boolean moved;
            int c;
            if ((c = mode.compare(key, node.getKey())) == 0) {
                return Optional.ofNullable(node);
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild().hasMoved() : this.moveToLastChild().hasMoved();
            if (!moved) break;
            node = this.getAVLNode();
        }
        return Optional.empty();
    }

    public Optional<AVLNode<K, V>> getAVLNode(K key, SearchMode mode, Comparator<? super K> comp) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((XdmDocumentRootNode)this.getNode()).hasFirstChild()) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        AVLNode<K, V> node = this.getAVLNode();
        while (true) {
            boolean moved;
            int c;
            if ((c = mode.compare(key, node.getKey(), comp)) == 0) {
                return Optional.ofNullable(node);
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild().hasMoved() : this.moveToLastChild().hasMoved();
            if (!moved) break;
            node = this.getAVLNode();
        }
        return Optional.empty();
    }

    public long size() {
        return ((XdmDocumentRootNode)this.moveToDocumentRoot().trx().getNode()).getDescendantCount();
    }

    @Override
    public void close() {
        this.mClosed = true;
    }

    final void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Path summary is already closed.");
        }
    }

    public void setCurrentNode(AVLNode<K, V> node) {
        this.mCurrentNode = (Node)Preconditions.checkNotNull(node);
    }

    private StructNode getStructuralNode() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof StructNode) {
            return (StructNode)this.mCurrentNode;
        }
        return new NullNode(this.mCurrentNode);
    }

    @Override
    public boolean hasNode(long key) {
        this.assertNotClosed();
        long currKey = this.mCurrentNode.getNodeKey();
        boolean moved = this.moveTo(key).hasMoved();
        Move<AVLTreeReader<K, V>> movedCursor = this.moveTo(currKey);
        assert (movedCursor.hasMoved()) : "Must be moveable back!";
        return moved;
    }

    @Override
    public boolean hasParent() {
        this.assertNotClosed();
        return this.mCurrentNode.hasParent();
    }

    @Override
    public boolean hasFirstChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof AVLNode) {
            return this.getAVLNode().hasRightChild();
        }
        return false;
    }

    @Override
    public boolean hasLeftSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLeftSibling();
    }

    @Override
    public boolean hasRightSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasRightSibling();
    }

    public Move<AVLTreeReader<K, V>> moveTo(long nodeKey) {
        Optional<Object> newNode;
        this.assertNotClosed();
        if (nodeKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return Move.notMoved();
        }
        Node oldNode = this.mCurrentNode;
        try {
            Optional<? extends Record> node = this.mPageReadTrx.getRecord(nodeKey, this.mPageKind, this.mIndex);
            newNode = node;
        }
        catch (SirixIOException e) {
            newNode = Optional.empty();
        }
        if (newNode.isPresent()) {
            this.mCurrentNode = (Node)newNode.get();
            return Move.moved(this);
        }
        this.mCurrentNode = oldNode;
        return Move.notMoved();
    }

    public Move<AVLTreeReader<K, V>> moveToDocumentRoot() {
        this.assertNotClosed();
        return this.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
    }

    public Move<AVLTreeReader<K, V>> moveToParent() {
        this.assertNotClosed();
        return this.moveTo(this.mCurrentNode.getParentKey());
    }

    public Move<AVLTreeReader<K, V>> moveToFirstChild() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof AVLNode) {
            AVLNode<K, V> node = this.getAVLNode();
            if (!node.hasLeftChild()) {
                return Move.notMoved();
            }
            return this.moveTo(node.getLeftChildKey());
        }
        return this.moveTo(((XdmDocumentRootNode)this.mCurrentNode).getFirstChildKey());
    }

    public Move<AVLTreeReader<K, V>> moveToLastChild() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof AVLNode) {
            AVLNode<K, V> node = this.getAVLNode();
            if (!node.hasRightChild()) {
                return Move.notMoved();
            }
            return this.moveTo(node.getRightChildKey());
        }
        return Move.notMoved();
    }

    @Override
    public Move<? extends NodeCursor> moveToPrevious() {
        this.assertNotClosed();
        return this.moveToParent();
    }

    @Override
    public Move<? extends NodeCursor> moveToNext() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof AVLNode) {
            AVLNode node = (AVLNode)this.mCurrentNode;
            if (node.hasLeftChild()) {
                this.moveToFirstChild();
            } else if (node.hasRightChild()) {
                this.moveToLastChild();
            } else {
                while (this.moveToParent().trx().getNode() instanceof AVLNode && !this.hasLastChild()) {
                }
                if (this.getNode() instanceof AVLNode) {
                    return Move.moved(this.moveToLastChild().trx());
                }
                return Move.notMoved();
            }
        }
        return Move.moved(this.moveToFirstChild().trx());
    }

    public Move<AVLTreeReader<K, V>> moveToLeftSibling() {
        this.assertNotClosed();
        return Move.notMoved();
    }

    public Move<AVLTreeReader<K, V>> moveToRightSibling() {
        this.assertNotClosed();
        return Move.notMoved();
    }

    @Override
    public long getNodeKey() {
        this.assertNotClosed();
        return this.mCurrentNode.getNodeKey();
    }

    @Override
    public Kind getRightSiblingKind() {
        this.assertNotClosed();
        return Kind.UNKNOWN;
    }

    @Override
    public Kind getLeftSiblingKind() {
        this.assertNotClosed();
        return Kind.UNKNOWN;
    }

    @Override
    public Kind getFirstChildKind() {
        this.assertNotClosed();
        Kind firstChildKind = this.moveToFirstChild().trx().getKind();
        this.moveToParent();
        return firstChildKind;
    }

    @Override
    public Kind getLastChildKind() {
        this.assertNotClosed();
        Kind lastChildKind = this.moveToLastChild().trx().getKind();
        this.moveToParent();
        return lastChildKind;
    }

    @Override
    public Kind getParentKind() {
        this.assertNotClosed();
        if (this.hasParent()) {
            if (this.mCurrentNode.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                return Kind.XDM_DOCUMENT;
            }
            long nodeKey = this.mCurrentNode.getNodeKey();
            Kind parentKind = this.moveToParent().trx().getKind();
            this.moveTo(nodeKey);
            return parentKind;
        }
        return Kind.UNKNOWN;
    }

    @Override
    public Kind getKind() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind();
    }

    @Override
    public ImmutableNode getNode() {
        this.assertNotClosed();
        return this.mCurrentNode;
    }

    @Override
    public Move<? extends NodeCursor> moveToNextFollowing() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLeftSiblingKey() {
        this.assertNotClosed();
        return -15L;
    }

    @Override
    public long getRightSiblingKey() {
        this.assertNotClosed();
        return -15L;
    }

    @Override
    public long getFirstChildKey() {
        long firstChildKey;
        this.assertNotClosed();
        if (this.moveToFirstChild().hasMoved()) {
            firstChildKey = this.getNodeKey();
            this.moveToParent();
        } else {
            firstChildKey = Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        return firstChildKey;
    }

    @Override
    public long getLastChildKey() {
        long lastChildKey;
        this.assertNotClosed();
        if (this.moveToLastChild().hasMoved()) {
            lastChildKey = this.getNodeKey();
            this.moveToParent();
        } else {
            lastChildKey = Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        return lastChildKey;
    }

    @Override
    public long getParentKey() {
        return this.getNode().getParentKey();
    }

    public final class AVLNodeIterator
    extends AbstractIterator<AVLNode<K, V>> {
        private boolean mFirst = true;
        private final Deque<Long> mKeys = new ArrayDeque<Long>();
        private final long mKey;

        public AVLNodeIterator(long nodeKey) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
            this.mKey = nodeKey;
        }

        protected AVLNode<K, V> computeNext() {
            if (!this.mFirst) {
                if (!this.mKeys.isEmpty()) {
                    AVLNode node = AVLTreeReader.this.moveTo(this.mKeys.pop()).trx().getAVLNode();
                    this.stackOperation(node);
                    return node;
                }
                return (AVLNode)this.endOfData();
            }
            this.mFirst = false;
            boolean moved = AVLTreeReader.this.moveTo(this.mKey).hasMoved();
            if (this.mKey == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                moved = AVLTreeReader.this.moveToFirstChild().hasMoved();
            }
            if (moved) {
                AVLNode node = AVLTreeReader.this.getAVLNode();
                this.stackOperation(node);
                return node;
            }
            return (AVLNode)this.endOfData();
        }

        private void stackOperation(AVLNode<K, V> node) {
            if (node.hasRightChild()) {
                AVLNode right = AVLTreeReader.this.moveToLastChild().trx().getAVLNode();
                this.mKeys.push(right.getNodeKey());
            }
            AVLTreeReader.this.moveTo(node.getNodeKey());
            if (node.hasLeftChild()) {
                AVLNode left = AVLTreeReader.this.moveToFirstChild().trx().getAVLNode();
                this.mKeys.push(left.getNodeKey());
            }
        }
    }

    public static enum MoveCursor {
        TO_DOCUMENT_ROOT,
        NO_MOVE;

    }
}

