/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnegative;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.node.parser.FragmentHelper;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.node.Node;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexType;
import org.sirix.index.Materializable;

public final class Indexes
implements Materializable {
    public static final QNm INDEXES_TAG = new QNm("indexes");
    private final Set<IndexDef> mIndexes = new HashSet<IndexDef>();

    public synchronized Set<IndexDef> getIndexDefs() {
        return new HashSet<IndexDef>(this.mIndexes);
    }

    public synchronized IndexDef getIndexDef(@Nonnegative int indexNo, IndexType type) {
        Preconditions.checkArgument((indexNo >= 0 ? 1 : 0) != 0, (Object)"indexNo must be >= 0!");
        for (IndexDef sid : this.mIndexes) {
            if (sid.getID() != indexNo || sid.getType() != type) continue;
            return sid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init(Node<?> root) throws DocumentException {
        QNm name = root.getName();
        if (!INDEXES_TAG.equals((Object)name)) {
            throw new DocumentException("Expected tag '%s' but found '%s'", new Object[]{INDEXES_TAG, name});
        }
        try (Stream children = root.getChildren();){
            Node child;
            while ((child = (Node)children.next()) != null) {
                QNm childName = child.getName();
                if (!childName.equals((Object)IndexDef.INDEX_TAG)) {
                    throw new DocumentException("Expected tag '%s' but found '%s'", new Object[]{IndexDef.INDEX_TAG, childName});
                }
                IndexDef indexDefinition = new IndexDef();
                indexDefinition.init(child);
                this.mIndexes.add(indexDefinition);
            }
        }
    }

    @Override
    public synchronized Node<?> materialize() throws DocumentException {
        FragmentHelper helper = new FragmentHelper();
        helper.openElement(INDEXES_TAG);
        for (IndexDef idxDef : this.mIndexes) {
            helper.insert(idxDef.materialize());
        }
        helper.closeElement();
        return helper.getRoot();
    }

    public synchronized void add(IndexDef indexDefinition) {
        this.mIndexes.add(indexDefinition);
    }

    public synchronized void removeIndex(@Nonnegative int indexID) {
        Preconditions.checkArgument((indexID >= 0 ? 1 : 0) != 0, (Object)"indexID must be >= 0!");
        for (IndexDef indexDef : this.mIndexes) {
            if (indexDef.getID() != indexID) continue;
            this.mIndexes.remove(indexDef);
            return;
        }
    }

    public Optional<IndexDef> findPathIndex(Path<QNm> path) throws DocumentException {
        Preconditions.checkNotNull(path);
        try {
            for (IndexDef index : this.mIndexes) {
                if (!index.isPathIndex()) continue;
                if (index.getPaths().isEmpty()) {
                    return Optional.of(index);
                }
                for (Path<QNm> indexedPath : index.getPaths()) {
                    if (!indexedPath.matches(path)) continue;
                    return Optional.of(index);
                }
            }
            return Optional.empty();
        }
        catch (PathException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public Optional<IndexDef> findCASIndex(Path<QNm> path, Type type) throws DocumentException {
        Preconditions.checkNotNull(path);
        try {
            for (IndexDef index : this.mIndexes) {
                if (!index.isCasIndex() || !index.getContentType().equals((Object)type)) continue;
                if (index.getPaths().isEmpty()) {
                    return Optional.of(index);
                }
                for (Path<QNm> indexedPath : index.getPaths()) {
                    if (!indexedPath.matches(path)) continue;
                    return Optional.of(index);
                }
            }
            return Optional.empty();
        }
        catch (PathException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public Optional<IndexDef> findNameIndex(QNm ... names) throws DocumentException {
        Preconditions.checkNotNull((Object)names);
        block0: for (IndexDef index : this.mIndexes) {
            if (!index.isNameIndex()) continue;
            Set<QNm> incl = index.getIncluded();
            Set<QNm> excl = index.getExcluded();
            if (names.length == 0 && incl.isEmpty() && excl.isEmpty()) {
                return Optional.of(index);
            }
            for (QNm name : names) {
                if (!incl.isEmpty() && !incl.contains(name) || !excl.isEmpty() && excl.contains(name)) continue block0;
            }
            return Optional.of(index);
        }
        return Optional.empty();
    }

    public int getNrOfIndexDefsWithType(IndexType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        int nr = 0;
        for (IndexDef index : this.mIndexes) {
            if (index.getType() != type) continue;
            ++nr;
        }
        return nr;
    }
}

