/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index;

import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Dec;
import org.brackit.xquery.atomic.Flt;
import org.brackit.xquery.atomic.Int;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Int64;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.expr.Cast;
import org.brackit.xquery.xdm.Type;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixRuntimeException;
import org.sirix.utils.Calc;

public final class AtomicUtil {
    public static byte[] toBytes(Atomic atomic, Type type) throws SirixException {
        if (atomic == null) {
            return null;
        }
        return AtomicUtil.toBytes(AtomicUtil.toType(atomic, type));
    }

    public static byte[] toBytes(Atomic atomic) {
        if (atomic == null) {
            return null;
        }
        Type type = atomic.type();
        if (!type.isBuiltin()) {
            throw new SirixRuntimeException("%s is not a built-in type", type);
        }
        if (type.instanceOf(Type.STR)) {
            return Calc.fromString(atomic.stringValue());
        }
        if (type.isNumeric()) {
            if (type.instanceOf(Type.DBL)) {
                return Calc.fromDouble(((Numeric)atomic).doubleValue());
            }
            if (type.instanceOf(Type.FLO)) {
                return Calc.fromFloat(((Numeric)atomic).floatValue());
            }
            if (type.instanceOf(Type.INT)) {
                return Calc.fromInt(((Numeric)atomic).intValue());
            }
            if (type.instanceOf(Type.LON)) {
                return Calc.fromLong(((Numeric)atomic).longValue());
            }
            if (type.instanceOf(Type.INR)) {
                return Calc.fromBigDecimal(((Numeric)atomic).decimalValue());
            }
            if (type.instanceOf(Type.DEC)) {
                return Calc.fromBigDecimal(((Numeric)atomic).decimalValue());
            }
        }
        throw new SirixRuntimeException("Unsupported type: %s", type);
    }

    public static Atomic fromBytes(byte[] b, Type type) {
        if (!type.isBuiltin()) {
            throw new SirixRuntimeException("%s is not a built-in type", type);
        }
        if (type.instanceOf(Type.STR)) {
            return new Str(Calc.toString(b));
        }
        if (type.isNumeric()) {
            if (type.instanceOf(Type.DBL)) {
                return new Dbl(Calc.toDouble(b));
            }
            if (type.instanceOf(Type.FLO)) {
                return new Flt(Calc.toFloat(b));
            }
            if (type.instanceOf(Type.INT)) {
                return new Int32(Calc.toInt(b));
            }
            if (type.instanceOf(Type.LON)) {
                return new Int64(Calc.toLong(b));
            }
            if (type.instanceOf(Type.INR)) {
                return new Int(Calc.toBigDecimal(b));
            }
            if (type.instanceOf(Type.DEC)) {
                return new Dec(Calc.toBigDecimal(b));
            }
        }
        throw new SirixRuntimeException("Unsupported type: %s", type);
    }

    public static Atomic toType(Atomic atomic, Type type) {
        try {
            return Cast.cast(null, (Atomic)atomic, (Type)type);
        }
        catch (QueryException e) {
            throw new SirixRuntimeException(e);
        }
    }
}

