/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.export;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.sirix.diff.DiffFactory;
import org.sirix.diff.DiffTuple;

public final class EditScript
implements Iterator<DiffTuple>,
Iterable<DiffTuple> {
    private final List<DiffTuple> mChanges = new ArrayList<DiffTuple>();
    private final IdentityHashMap<Long, DiffTuple> mChangeByNode = new IdentityHashMap();
    private transient int mIndex = 0;

    public int size() {
        return this.mChanges.size();
    }

    public boolean isEmpty() {
        return this.mChanges.isEmpty();
    }

    public boolean containsNode(long key) {
        if (key < 0L) {
            throw new IllegalArgumentException("paramKey may not be < 0!");
        }
        return this.mChangeByNode.containsKey(key);
    }

    public void clear() {
        this.mChanges.clear();
        this.mChangeByNode.clear();
    }

    public DiffTuple get(long paramKey) {
        return this.mChangeByNode.get(paramKey);
    }

    public DiffTuple add(DiffTuple change) {
        long nodeKey;
        assert (change != null);
        long l = nodeKey = change.getDiff() == DiffFactory.DiffType.DELETED ? change.getOldNodeKey() : change.getNewNodeKey();
        if (this.mChangeByNode.containsKey(nodeKey)) {
            return change;
        }
        this.mChanges.add(change);
        return this.mChangeByNode.put(nodeKey, change);
    }

    @Override
    public Iterator<DiffTuple> iterator() {
        return this.mChanges.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.mIndex < this.mChanges.size() - 1;
    }

    @Override
    public DiffTuple next() {
        if (this.mIndex < this.mChanges.size()) {
            return this.mChanges.get(this.mIndex++);
        }
        throw new NoSuchElementException("No more elements in the change list!");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported!");
    }
}

