/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.sirix.diff.algorithm.fmse.utils.SubCost01;
import org.sirix.diff.algorithm.fmse.utils.SubstitutionCost;

public final class Levenshtein {
    private static final int MIN = 4;
    private static final int MAX = 50;
    private static final float ESTIMATEDTIMINGCONST = 1.8E-4f;
    private static final SubstitutionCost COSTFUNC = new SubCost01();

    public static String getShortDescriptionString() {
        return "Levenshtein";
    }

    public static String getLongDescriptionString() {
        return "Implements the basic Levenshtein algorithm providing a similarity measure between two strings";
    }

    public static float getSimilarityTimingEstimated(String first, @Nonnull String second) {
        float str1Length = first.length();
        float str2Length = second.length();
        return str1Length * str2Length * 1.8E-4f;
    }

    public static float getSimilarity(String first, @Nonnull String second) {
        int secondLength;
        Preconditions.checkNotNull((Object)first);
        Preconditions.checkNotNull((Object)second);
        if (first == second || first.equals(second)) {
            return 1.0f;
        }
        int firstLength = first.length();
        if (firstLength > 50 | (secondLength = second.length()) > 50 | firstLength < 4 | secondLength < 4) {
            if (first.equals(second)) {
                return 1.0f;
            }
            return 0.0f;
        }
        float levenshteinDistance = Levenshtein.getUnNormalisedSimilarity(first, second);
        float maxLen = firstLength > secondLength ? (float)firstLength : (float)secondLength;
        float norm = 1.0f - levenshteinDistance / maxLen;
        assert (norm >= 0.0f && norm <= 1.0f);
        return norm;
    }

    private static float getUnNormalisedSimilarity(String s, String t) {
        int j;
        int i;
        assert (s != null);
        assert (t != null);
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                float cost = COSTFUNC.getCost(s, i - 1, t, j - 1);
                d[i][j] = Levenshtein.min3(d[i - 1][j] + 1.0f, d[i][j - 1] + 1.0f, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static float min3(float x, float y, float z) {
        return Math.min(x, Math.min(y, z));
    }
}

