/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import java.util.Map;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.diff.algorithm.fmse.FMSENodeComparisonUtils;
import org.sirix.diff.algorithm.fmse.Matching;
import org.sirix.diff.algorithm.fmse.NodeComparator;

final class InnerNodeComparator
implements NodeComparator<Long> {
    private static final double FMESTHRESHOLD = 0.5;
    private final Matching mMatching;
    private final XmlNodeReadOnlyTrx mOldRtx;
    private final XmlNodeReadOnlyTrx mNewRtx;
    private final QNm mIdName;
    private final FMSENodeComparisonUtils mNodeComparisonUtils;
    private Map<Long, Long> mDescendantsOldRev;
    private Map<Long, Long> mDescendantsNewRev;

    public InnerNodeComparator(QNm idName, Matching matching, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx, FMSENodeComparisonUtils nodeComparisonUtils, Map<Long, Long> descendantsOldRev, Map<Long, Long> descendantsNewRev) {
        assert (matching != null);
        assert (oldRtx != null);
        assert (newRtx != null);
        assert (nodeComparisonUtils != null);
        assert (descendantsOldRev != null);
        assert (descendantsNewRev != null);
        this.mIdName = idName;
        this.mMatching = matching;
        this.mOldRtx = oldRtx;
        this.mNewRtx = newRtx;
        this.mNodeComparisonUtils = nodeComparisonUtils;
        this.mDescendantsOldRev = descendantsOldRev;
        this.mDescendantsNewRev = descendantsNewRev;
    }

    @Override
    public boolean isEqual(Long firstNode, Long secondNode) {
        assert (firstNode != null);
        assert (secondNode != null);
        this.mOldRtx.moveTo(firstNode);
        this.mNewRtx.moveTo(secondNode);
        assert (this.mOldRtx.getKind() == this.mNewRtx.getKind());
        boolean retVal = false;
        if (this.mIdName != null && this.mOldRtx.isElement() && this.mNewRtx.isElement() && this.mOldRtx.moveToAttributeByName(this.mIdName).hasMoved() && this.mNewRtx.moveToAttributeByName(this.mIdName).hasMoved()) {
            retVal = this.mNewRtx.getValue().equals(this.mOldRtx.getValue());
        } else if ((this.mOldRtx.hasFirstChild() || this.mOldRtx.hasAttributes() || this.mOldRtx.hasNamespaces()) && (this.mNewRtx.hasFirstChild() || this.mNewRtx.hasAttributes() || this.mNewRtx.hasNamespaces())) {
            long common = this.mMatching.containedDescendants(firstNode, secondNode);
            long maxFamilySize = Math.max(this.mDescendantsOldRev.get(firstNode), this.mDescendantsNewRev.get(secondNode));
            retVal = common == 0L && maxFamilySize == 1L ? this.mOldRtx.getName().equals((Object)this.mNewRtx.getName()) : (double)common / (double)maxFamilySize >= 0.5;
        } else {
            QNm oldName = this.mOldRtx.getName();
            QNm newName = this.mNewRtx.getName();
            if (oldName.getNamespaceURI().equals(newName.getNamespaceURI()) && (double)this.mNodeComparisonUtils.calculateRatio(oldName.getLocalName(), newName.getLocalName()) > 0.7) {
                retVal = this.mNodeComparisonUtils.checkAncestors(this.mOldRtx.getNodeKey(), this.mNewRtx.getNodeKey());
            }
        }
        return retVal;
    }
}

