/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sirix.access.trx.node.xml.AbstractXdmNodeVisitor;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.node.Kind;
import org.sirix.node.immutable.xdm.ImmutableComment;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.immutable.xdm.ImmutablePI;
import org.sirix.node.immutable.xdm.ImmutableText;
import org.sirix.node.interfaces.immutable.ImmutableNode;

public final class FMSEVisitor
extends AbstractXdmNodeVisitor {
    private final XmlNodeReadOnlyTrx mRtx;
    private final Map<Long, Boolean> mInOrder;
    private final Map<Long, Long> mDescendants;

    public FMSEVisitor(XmlNodeReadOnlyTrx readTransaction, Map<Long, Boolean> inOrder, Map<Long, Long> descendants) {
        this.mRtx = (XmlNodeReadOnlyTrx)Preconditions.checkNotNull((Object)readTransaction);
        this.mInOrder = (Map)Preconditions.checkNotNull(inOrder);
        this.mDescendants = (Map)Preconditions.checkNotNull(descendants);
    }

    @Override
    public VisitResultType visit(ImmutableElement node) {
        int i;
        long nodeKey = node.getNodeKey();
        this.mRtx.moveTo(nodeKey);
        int attCount = this.mRtx.getAttributeCount();
        for (i = 0; i < attCount; ++i) {
            this.mRtx.moveToAttribute(i);
            this.fillStructuralDataStructures();
            this.mRtx.moveTo(nodeKey);
        }
        int nspCount = this.mRtx.getNamespaceCount();
        for (i = 0; i < nspCount; ++i) {
            this.mRtx.moveToNamespace(i);
            this.fillStructuralDataStructures();
            this.mRtx.moveTo(nodeKey);
        }
        this.countDescendants();
        return VisitResultType.CONTINUE;
    }

    private void fillStructuralDataStructures() {
        this.mInOrder.put(this.mRtx.getNodeKey(), true);
        this.mDescendants.put(this.mRtx.getNodeKey(), 1L);
    }

    private void countDescendants() {
        long descendants = 0L;
        long nodeKey = this.mRtx.getNodeKey();
        descendants += (long)this.mRtx.getNamespaceCount();
        descendants += (long)this.mRtx.getAttributeCount();
        if (this.mRtx.hasFirstChild()) {
            this.mRtx.moveToFirstChild();
            do {
                descendants += this.mDescendants.get(this.mRtx.getNodeKey()).longValue();
                if (this.mRtx.getKind() != Kind.ELEMENT) continue;
                ++descendants;
            } while (this.mRtx.hasRightSibling() && this.mRtx.moveToRightSibling().hasMoved());
        }
        this.mRtx.moveTo(nodeKey);
        this.mInOrder.put(this.mRtx.getNodeKey(), false);
        this.mDescendants.put(this.mRtx.getNodeKey(), descendants);
    }

    @Override
    public VisitResultType visit(ImmutableText node) {
        return this.visiLeafNode(node);
    }

    @Override
    public VisitResultType visit(ImmutableComment node) {
        return this.visiLeafNode(node);
    }

    @Override
    public VisitResultType visit(ImmutablePI node) {
        return this.visiLeafNode(node);
    }

    private VisitResultType visiLeafNode(ImmutableNode pNode) {
        long nodeKey = pNode.getNodeKey();
        this.mRtx.moveTo(nodeKey);
        this.mInOrder.put(this.mRtx.getNodeKey(), false);
        this.mDescendants.put(this.mRtx.getNodeKey(), 1L);
        return VisitResultType.CONTINUE;
    }
}

