/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import org.brackit.xquery.atomic.QNm;
import org.sirix.access.Utils;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.diff.algorithm.fmse.Levenshtein;
import org.sirix.diff.algorithm.fmse.Util;

class FMSENodeComparisonUtils {
    private static final int MAX_LENGTH = 50;
    private final long mOldStartKey;
    private final long mNewStartKey;
    private final XmlNodeReadOnlyTrx mOldRtx;
    private final XmlNodeReadOnlyTrx mNewRtx;

    FMSENodeComparisonUtils(long oldStartKey, long newStartKey, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx) {
        this.mOldStartKey = oldStartKey;
        this.mNewStartKey = newStartKey;
        this.mOldRtx = oldRtx;
        this.mNewRtx = newRtx;
    }

    boolean nodeValuesEqual(long x, long y, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx) {
        assert (x >= 0L);
        assert (y >= 0L);
        assert (oldRtx != null);
        assert (newRtx != null);
        String a = this.getNodeValue(x, oldRtx);
        String b = this.getNodeValue(y, newRtx);
        return a == null ? b == null : a.equals(b);
    }

    float calculateRatio(String oldValue, String newValue) {
        assert (oldValue != null);
        assert (newValue != null);
        float ratio = oldValue.length() > 50 || newValue.length() > 50 ? Util.quickRatio(oldValue, newValue) : Levenshtein.getSimilarity(oldValue, newValue);
        return ratio;
    }

    boolean checkAncestors(long oldKey, long newKey) {
        assert (oldKey >= 0L);
        assert (newKey >= 0L);
        this.mOldRtx.moveTo(oldKey);
        this.mNewRtx.moveTo(newKey);
        boolean retVal = true;
        if (this.mOldRtx.hasParent() && this.mNewRtx.hasParent()) {
            do {
                this.mOldRtx.moveToParent();
                this.mNewRtx.moveToParent();
                if (!this.mOldRtx.hasAttributes() || !this.mNewRtx.hasAttributes() || this.checkAttributes()) continue;
                return false;
            } while (this.mOldRtx.getNodeKey() != this.mOldStartKey && this.mNewRtx.getNodeKey() != this.mNewStartKey && this.mOldRtx.hasParent() && this.mNewRtx.hasParent() && this.calculateRatio(this.getNodeValue(this.mOldRtx.getNodeKey(), this.mOldRtx), this.getNodeValue(this.mNewRtx.getNodeKey(), this.mNewRtx)) >= 0.7f);
            retVal = !(this.mOldRtx.hasParent() && this.mOldRtx.getNodeKey() != this.mOldStartKey || this.mNewRtx.hasParent() && this.mNewRtx.getNodeKey() != this.mNewStartKey);
        } else {
            retVal = false;
        }
        this.mOldRtx.moveTo(oldKey);
        this.mNewRtx.moveTo(newKey);
        return retVal;
    }

    boolean checkAttributes() {
        long newNodeKey = this.mNewRtx.getNodeKey();
        long oldNodeKey = this.mOldRtx.getNodeKey();
        int attCount = this.mOldRtx.getAttributeCount();
        for (int i = 0; i < attCount; ++i) {
            QNm name = this.mOldRtx.moveToAttribute(i).trx().getName();
            if (this.mNewRtx.moveToAttributeByName(name).hasMoved() && (this.calculateRatio(this.getNodeValue(this.mOldRtx.getNodeKey(), this.mOldRtx), this.getNodeValue(this.mNewRtx.getNodeKey(), this.mNewRtx)) < 0.7f || this.calculateRatio(this.mOldRtx.getValue(), this.mNewRtx.getValue()) < 0.7f)) {
                this.mNewRtx.moveTo(newNodeKey);
                this.mOldRtx.moveTo(oldNodeKey);
                return false;
            }
            this.mNewRtx.moveTo(newNodeKey);
            this.mOldRtx.moveTo(oldNodeKey);
        }
        this.mNewRtx.moveTo(newNodeKey);
        this.mOldRtx.moveTo(oldNodeKey);
        return true;
    }

    boolean checkIfAncestorIdsMatch(long oldKey, long newKey, QNm id) {
        assert (oldKey >= 0L);
        assert (newKey >= 0L);
        this.mOldRtx.moveTo(oldKey);
        this.mNewRtx.moveTo(newKey);
        boolean retVal = false;
        if (this.mOldRtx.hasParent() && this.mNewRtx.hasParent()) {
            do {
                this.mOldRtx.moveToParent();
                this.mNewRtx.moveToParent();
                if (this.mOldRtx.isElement() && this.mNewRtx.isElement() && this.mOldRtx.moveToAttributeByName(id).hasMoved() && this.mNewRtx.moveToAttributeByName(id).hasMoved()) {
                    if (!this.mNewRtx.getValue().equals(this.mOldRtx.getValue())) continue;
                    retVal = true;
                    continue;
                }
                retVal = false;
                break;
            } while (this.mOldRtx.getNodeKey() != this.mOldStartKey && this.mNewRtx.getNodeKey() != this.mNewStartKey && this.mOldRtx.hasParent() && this.mNewRtx.hasParent());
        }
        this.mOldRtx.moveTo(oldKey);
        this.mNewRtx.moveTo(newKey);
        return retVal;
    }

    String getNodeValue(long nodeKey, XmlNodeReadOnlyTrx rtx) {
        assert (nodeKey >= 0L);
        assert (rtx != null);
        rtx.moveTo(nodeKey);
        StringBuilder retVal = new StringBuilder();
        switch (rtx.getKind()) {
            case ELEMENT: 
            case NAMESPACE: 
            case ATTRIBUTE: {
                retVal.append(Utils.buildName(rtx.getName()));
                break;
            }
            case TEXT: 
            case COMMENT: {
                retVal.append(rtx.getValue());
                break;
            }
            case PROCESSING_INSTRUCTION: {
                retVal.append(rtx.getName().getLocalName()).append(" ").append(rtx.getValue());
                break;
            }
        }
        return retVal.toString();
    }
}

