/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.axis.ChildAxis;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.LevelOrderAxis;
import org.sirix.axis.PostOrderAxis;
import org.sirix.axis.visitor.DeleteFMSEVisitor;
import org.sirix.axis.visitor.VisitorDescendantAxis;
import org.sirix.diff.algorithm.ImportDiff;
import org.sirix.diff.algorithm.fmse.FMSENodeComparisonUtils;
import org.sirix.diff.algorithm.fmse.FMSEVisitor;
import org.sirix.diff.algorithm.fmse.LabelFMSEVisitor;
import org.sirix.diff.algorithm.fmse.LeafNodeComparator;
import org.sirix.diff.algorithm.fmse.Matching;
import org.sirix.diff.algorithm.fmse.NodeComparator;
import org.sirix.diff.algorithm.fmse.NodeComparisonFactory;
import org.sirix.diff.algorithm.fmse.Util;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixUsageException;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.Kind;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.Pair;
import org.slf4j.LoggerFactory;

public final class FMSE
implements ImportDiff,
AutoCloseable {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(FMSE.class));
    private static final String NAME = "Fast Matching / Edit Script";
    private Map<Long, Boolean> mAlreadyInserted;
    private Matching mFastMatching;
    private transient Matching mTotalMatching;
    private Map<Long, Boolean> mInOrderOldRev;
    private Map<Long, Boolean> mInOrderNewRev;
    private Map<Long, Long> mDescendantsOldRev;
    private Map<Long, Long> mDescendantsNewRev;
    private XmlNodeVisitor mOldRevVisitor;
    private XmlNodeVisitor mNewRevVisitor;
    private LabelFMSEVisitor mLabelOldRevVisitor;
    private LabelFMSEVisitor mLabelNewRevVisitor;
    private XmlNodeTrx mWtx;
    private XmlNodeReadOnlyTrx mRtx;
    private long mOldStartKey;
    private long mNewStartKey;
    private final QNm mIdName;
    private PathSummaryReader mOldPathSummary;
    private PathSummaryReader mNewPathSummary;
    private final NodeComparisonFactory mNodeComparisonFactory;

    private FMSE(QNm idName, NodeComparisonFactory nodeComparisonFactory) {
        this.mIdName = idName;
        this.mNodeComparisonFactory = (NodeComparisonFactory)Preconditions.checkNotNull((Object)nodeComparisonFactory);
    }

    public static final FMSE createWithIdentifier(QNm idName, NodeComparisonFactory nodeComparisonFactory) {
        return new FMSE(idName, nodeComparisonFactory);
    }

    public static final FMSE createInstance(NodeComparisonFactory nodeComparisonFactory) {
        return new FMSE(null, nodeComparisonFactory);
    }

    @Override
    public void diff(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        this.mWtx = (XmlNodeTrx)Preconditions.checkNotNull((Object)wtx);
        this.mRtx = (XmlNodeReadOnlyTrx)Preconditions.checkNotNull((Object)rtx);
        this.mOldStartKey = this.mWtx.getNodeKey();
        this.mNewStartKey = this.mRtx.getNodeKey();
        this.mDescendantsOldRev = new HashMap<Long, Long>();
        this.mDescendantsNewRev = new HashMap<Long, Long>();
        this.mInOrderOldRev = new HashMap<Long, Boolean>();
        this.mInOrderNewRev = new HashMap<Long, Boolean>();
        this.mAlreadyInserted = new HashMap<Long, Boolean>();
        this.mOldPathSummary = this.mWtx.getPathSummary();
        this.mNewPathSummary = this.mRtx.getResourceManager().openPathSummary(this.mRtx.getRevisionNumber());
        this.mOldRevVisitor = new FMSEVisitor(this.mWtx, this.mInOrderOldRev, this.mDescendantsOldRev);
        this.mNewRevVisitor = new FMSEVisitor(this.mRtx, this.mInOrderNewRev, this.mDescendantsNewRev);
        this.mLabelOldRevVisitor = new LabelFMSEVisitor(this.mWtx);
        this.mLabelNewRevVisitor = new LabelFMSEVisitor(this.mRtx);
        FMSE.init(this.mWtx, this.mOldRevVisitor);
        FMSE.init(this.mRtx, this.mNewRevVisitor);
        this.mFastMatching = this.fastMatch(this.mWtx, this.mRtx);
        this.mTotalMatching = new Matching(this.mFastMatching);
        this.firstFMESStep(this.mWtx, this.mRtx);
        try {
            this.secondFMESStep(this.mWtx, this.mRtx);
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private void firstFMESStep(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(this.mOldStartKey);
        rtx.moveTo(this.mNewStartKey);
        LevelOrderAxis axis = new LevelOrderAxis.Builder(rtx).includeSelf().includeNonStructuralNodes().build();
        while (axis.hasNext()) {
            axis.next();
            long nodeKey = axis.asXdmNodeReadTrx().getNodeKey();
            this.doFirstFSMEStep(wtx, rtx);
            axis.asXdmNodeReadTrx().moveTo(nodeKey);
        }
    }

    private void doFirstFSMEStep(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (wtx != null);
        assert (rtx != null);
        FMSENodeComparisonUtils nodeComparisonUtils = new FMSENodeComparisonUtils(this.mOldStartKey, this.mNewStartKey, this.mWtx, this.mRtx);
        long key = rtx.getNodeKey();
        long x = rtx.getNodeKey();
        rtx.moveToParent();
        long y = rtx.getNodeKey();
        Long z = this.mTotalMatching.reversePartner(y);
        Long w = this.mTotalMatching.reversePartner(x);
        wtx.moveTo(this.mOldStartKey);
        if (w == null) {
            assert (z != null);
            this.mInOrderNewRev.put(x, true);
            int k = this.findPos(x, wtx, rtx);
            assert (k > -1);
            w = this.emitInsert(x, z, k, wtx, rtx);
        } else if (x != wtx.getNodeKey()) {
            if (wtx.moveTo(w).hasMoved() && rtx.moveTo(x).hasMoved() && wtx.getKind() == rtx.getKind() && (!nodeComparisonUtils.nodeValuesEqual(w, x, wtx, rtx) || rtx.isAttribute() && !rtx.getValue().equals(wtx.getValue()))) {
                FMSE.emitUpdate(w, x, wtx, rtx);
            }
            wtx.moveTo(w);
            wtx.moveToParent();
            long v = wtx.getNodeKey();
            if (!this.mTotalMatching.contains(v, y) && wtx.moveTo(w).hasMoved() && rtx.moveTo(x).hasMoved()) {
                assert (z != null);
                this.mInOrderNewRev.put(x, true);
                rtx.moveTo(x);
                if (rtx.isNamespace() || rtx.isAttribute()) {
                    wtx.moveTo(w);
                    try {
                        this.mTotalMatching.remove(w);
                        wtx.remove();
                    }
                    catch (SirixException e) {
                        LOGWRAPPER.error(e.getMessage(), e);
                    }
                    w = this.emitInsert(x, z, -1, wtx, rtx);
                } else {
                    int k = this.findPos(x, wtx, rtx);
                    assert (k > -1);
                    this.emitMove(w, z, k, wtx, rtx);
                }
            }
        }
        this.alignChildren(w, x, wtx, rtx);
        rtx.moveTo(key);
    }

    private void secondFMESStep(XmlNodeTrx wtx, NodeReadOnlyTrx rtx) throws SirixException {
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(this.mOldStartKey);
        for (long l : VisitorDescendantAxis.newBuilder(wtx).includeSelf().visitor(new DeleteFMSEVisitor(wtx, this.mTotalMatching, this.mOldStartKey)).build()) {
        }
    }

    private void alignChildren(long w, long x, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (w >= 0L);
        assert (x >= 0L);
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(w);
        rtx.moveTo(x);
        FMSE.markOutOfOrder(wtx, this.mInOrderOldRev);
        FMSE.markOutOfOrder(rtx, this.mInOrderNewRev);
        List<Long> first = this.commonChildren(w, x, wtx, rtx, ReverseMap.FALSE);
        List<Long> second = this.commonChildren(x, w, rtx, wtx, ReverseMap.TRUE);
        List<Pair<Long, Long>> s = Util.longestCommonSubsequence(first, second, (pX, pY) -> this.mTotalMatching.contains((long)pX, (long)pY));
        HashMap<Long, Long> seen = new HashMap<Long, Long>();
        for (Pair<Long, Long> p : s) {
            this.mInOrderOldRev.put(p.getFirst(), true);
            this.mInOrderNewRev.put(p.getSecond(), true);
            seen.put(p.getFirst(), p.getSecond());
        }
        Iterator<Object> iterator = first.iterator();
        while (iterator.hasNext()) {
            long a = (Long)iterator.next();
            wtx.moveTo(a);
            Long b = this.mTotalMatching.partner(a);
            if (seen.get(a) != null || !wtx.moveTo(a).hasMoved() || b == null || !rtx.moveTo(b).hasMoved()) continue;
            this.mInOrderOldRev.put(a, true);
            this.mInOrderNewRev.put(b, true);
            int k = this.findPos(b, wtx, rtx);
            LOGWRAPPER.debug("Move in align children: " + k, new Object[0]);
            this.emitMove(a, w, k, wtx, rtx);
        }
    }

    private static void markOutOfOrder(XmlNodeReadOnlyTrx rtx, Map<Long, Boolean> inOrder) {
        ChildAxis axis = new ChildAxis(rtx);
        while (axis.hasNext()) {
            axis.next();
            inOrder.put(axis.asXdmNodeReadTrx().getNodeKey(), false);
        }
    }

    private List<Long> commonChildren(long n, long o, XmlNodeReadOnlyTrx firstRtx, XmlNodeReadOnlyTrx secondRtx, ReverseMap reverse) {
        assert (n >= 0L);
        assert (o >= 0L);
        assert (firstRtx != null);
        assert (secondRtx != null);
        assert (reverse != null);
        LinkedList<Long> retVal = new LinkedList<Long>();
        firstRtx.moveTo(n);
        if (firstRtx.hasFirstChild()) {
            firstRtx.moveToFirstChild();
            do {
                Long partner;
                if ((partner = reverse == ReverseMap.TRUE ? this.mTotalMatching.reversePartner(firstRtx.getNodeKey()) : this.mTotalMatching.partner(firstRtx.getNodeKey())) == null) continue;
                secondRtx.moveTo(partner);
                if (secondRtx.getParentKey() != o) continue;
                retVal.add(firstRtx.getNodeKey());
            } while (firstRtx.hasRightSibling() && firstRtx.moveToRightSibling().hasMoved());
        }
        return retVal;
    }

    private long emitMove(long child, long parent, int pos, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (child >= 0L);
        assert (parent >= 0L);
        assert (wtx != null);
        assert (rtx != null);
        boolean moved = wtx.moveTo(child).hasMoved();
        assert (moved);
        if (wtx.getKind() == Kind.ATTRIBUTE || wtx.getKind() == Kind.NAMESPACE) {
            return -1L;
        }
        assert (pos >= 0);
        moved = wtx.moveTo(parent).hasMoved();
        assert (moved);
        try {
            if (pos == 0) {
                assert (wtx.getKind() == Kind.ELEMENT || wtx.getKind() == Kind.XDM_DOCUMENT);
                if (wtx.getFirstChildKey() == child) {
                    LOGWRAPPER.error("Something went wrong: First child and child may never be the same!", new Object[0]);
                } else if (wtx.moveTo(child).hasMoved()) {
                    boolean isTextKind = false;
                    if (wtx.getKind() == Kind.TEXT) {
                        isTextKind = true;
                    }
                    this.checkFromNodeForTextRemoval(wtx, child);
                    wtx.moveTo(parent);
                    if (isTextKind && wtx.getFirstChildKey() != child && wtx.hasFirstChild()) {
                        wtx.moveToFirstChild();
                        if (wtx.getKind() == Kind.TEXT) {
                            this.mTotalMatching.remove(wtx.getNodeKey());
                            wtx.remove();
                        }
                        wtx.moveTo(parent);
                    }
                    if (wtx.getKind() == Kind.XDM_DOCUMENT) {
                        rtx.moveTo(child);
                        wtx.moveTo(wtx.copySubtreeAsFirstChild(rtx).getNodeKey());
                    } else {
                        wtx.moveTo(wtx.moveSubtreeToFirstChild(child).getNodeKey());
                    }
                }
            } else {
                assert (wtx.hasFirstChild());
                wtx.moveToFirstChild();
                for (int i = 1; i < pos; ++i) {
                    assert (wtx.hasRightSibling());
                    wtx.moveToRightSibling();
                }
                long nodeKey = wtx.getNodeKey();
                this.checkFromNodeForTextRemoval(wtx, child);
                wtx.moveTo(nodeKey);
                if (wtx.getKind() == Kind.TEXT && wtx.moveTo(child).hasMoved() && wtx.getKind() == Kind.TEXT) {
                    wtx.moveTo(nodeKey);
                    this.mTotalMatching.remove(wtx.getNodeKey());
                }
                wtx.moveTo(nodeKey);
                if (wtx.moveToRightSibling().hasMoved()) {
                    long rightNodeKey = wtx.getNodeKey();
                    if (wtx.getKind() == Kind.TEXT && wtx.moveTo(child).hasMoved() && wtx.getKind() == Kind.TEXT) {
                        wtx.moveTo(rightNodeKey);
                        this.mTotalMatching.remove(wtx.getNodeKey());
                    }
                    wtx.moveToLeftSibling();
                }
                moved = wtx.moveTo(nodeKey).hasMoved();
                assert (moved);
                assert (wtx.getNodeKey() != child);
                wtx.moveTo(wtx.moveSubtreeToRightSibling(child).getNodeKey());
            }
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        return wtx.getNodeKey();
    }

    private void checkFromNodeForTextRemoval(XmlNodeTrx wtx, long child) {
        boolean maybeRemoveLeftSibling;
        boolean bl = maybeRemoveLeftSibling = wtx.getLeftSiblingKey() == child;
        if (wtx.moveTo(child).hasMoved()) {
            boolean isText = false;
            if (wtx.hasLeftSibling()) {
                wtx.moveToLeftSibling();
                if (wtx.getKind() == Kind.TEXT) {
                    isText = true;
                }
                wtx.moveToRightSibling();
            }
            if (isText && wtx.hasRightSibling()) {
                wtx.moveToRightSibling();
                if (wtx.getKind() == Kind.TEXT && isText) {
                    if (maybeRemoveLeftSibling) {
                        boolean moved = wtx.moveToLeftSibling().hasMoved();
                        assert (moved);
                        moved = wtx.moveToLeftSibling().hasMoved();
                        assert (moved);
                        this.mTotalMatching.remove(wtx.getNodeKey());
                    } else {
                        this.mTotalMatching.remove(wtx.getNodeKey());
                    }
                }
                wtx.moveToLeftSibling();
            }
        }
    }

    private static long emitUpdate(long fromNode, long toNode, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (fromNode >= 0L);
        assert (toNode >= 0L);
        assert (wtx != null);
        assert (rtx != null);
        wtx.moveTo(fromNode);
        rtx.moveTo(toNode);
        try {
            switch (rtx.getKind()) {
                case ELEMENT: 
                case ATTRIBUTE: 
                case NAMESPACE: 
                case PROCESSING_INSTRUCTION: {
                    assert (rtx.getKind() == Kind.ELEMENT || rtx.getKind() == Kind.ATTRIBUTE || rtx.getKind() == Kind.NAMESPACE || rtx.getKind() == Kind.PROCESSING_INSTRUCTION);
                    wtx.setName(rtx.getName());
                    if (wtx.getKind() != Kind.ATTRIBUTE && wtx.getKind() != Kind.PROCESSING_INSTRUCTION) break;
                    wtx.setValue(rtx.getValue());
                    break;
                }
                case TEXT: 
                case COMMENT: {
                    assert (wtx.getKind() == Kind.TEXT);
                    wtx.setValue(rtx.getValue());
                    break;
                }
            }
        }
        catch (SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        return wtx.getNodeKey();
    }

    /*
     * Unable to fully structure code
     */
    private long emitInsert(long child, long parent, int pos, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        if (!FMSE.$assertionsDisabled && child < 0L) {
            throw new AssertionError();
        }
        if (!FMSE.$assertionsDisabled && parent < 0L) {
            throw new AssertionError();
        }
        if (!FMSE.$assertionsDisabled && wtx == null) {
            throw new AssertionError();
        }
        if (!FMSE.$assertionsDisabled && rtx == null) {
            throw new AssertionError();
        }
        if (this.mAlreadyInserted.get(child) != null) {
            return child;
        }
        wtx.moveTo(parent);
        rtx.moveTo(child);
        try {
            switch (1.$SwitchMap$org$sirix$node$Kind[rtx.getKind().ordinal()]) {
                case 2: {
                    try {
                        wtx.insertAttribute(rtx.getName(), rtx.getValue());
                    }
                    catch (SirixUsageException e) {
                        this.mTotalMatching.remove(wtx.getNodeKey());
                        if (rtx.getValue().isEmpty()) ** GOTO lbl28
                        wtx.setValue(rtx.getValue());
                    }
lbl28:
                    // 3 sources

                    this.process(wtx.getNodeKey(), rtx.getNodeKey());
                    break;
                }
                case 3: {
                    try {
                        qName = rtx.getName();
                        wtx.insertNamespace(new QNm(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalName()));
                    }
                    catch (SirixUsageException e) {
                        this.mTotalMatching.remove(wtx.getNodeKey());
                    }
                    this.process(wtx.getNodeKey(), rtx.getNodeKey());
                    break;
                }
                default: {
                    oldKey = 0L;
                    if (pos == 0) {
                        switch (1.$SwitchMap$org$sirix$node$Kind[rtx.getKind().ordinal()]) {
                            case 1: {
                                oldKey = wtx.copySubtreeAsFirstChild(rtx).getNodeKey();
                                break;
                            }
                            case 5: {
                                if (wtx.hasFirstChild()) {
                                    wtx.moveToFirstChild();
                                    if (wtx.getKind() == Kind.TEXT) {
                                        this.mTotalMatching.remove(wtx.getNodeKey());
                                        wtx.remove();
                                    }
                                    wtx.moveTo(parent);
                                }
                                oldKey = wtx.insertTextAsFirstChild(rtx.getValue()).getNodeKey();
                                break;
                            }
                        }
                    } else {
                        if (!FMSE.$assertionsDisabled && !wtx.hasFirstChild()) {
                            throw new AssertionError();
                        }
                        wtx.moveToFirstChild();
                        for (i = 0; i < pos - 1; ++i) {
                            if (!FMSE.$assertionsDisabled && !wtx.hasRightSibling()) {
                                throw new AssertionError();
                            }
                            wtx.moveToRightSibling();
                        }
                        this.removeRightSiblingTextNode(wtx);
                        switch (1.$SwitchMap$org$sirix$node$Kind[rtx.getKind().ordinal()]) {
                            case 1: {
                                oldKey = wtx.copySubtreeAsRightSibling(rtx).getNodeKey();
                                break;
                            }
                            case 5: {
                                oldKey = wtx.insertTextAsRightSibling(rtx.getValue()).getNodeKey();
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Child should be already inserted!");
                            }
                        }
                    }
                    wtx.moveTo(oldKey);
                    rtx.moveTo(child);
                    oldAxis = new DescendantAxis(wtx, IncludeSelf.YES);
                    newAxis = new DescendantAxis(rtx, IncludeSelf.YES);
                    while (oldAxis.hasNext() && newAxis.hasNext()) {
                        oldAxis.next();
                        newAxis.next();
                        oldRtx = oldAxis.asXdmNodeReadTrx();
                        newRtx = newAxis.asXdmNodeReadTrx();
                        this.process(oldRtx.getNodeKey(), newRtx.getNodeKey());
                        newNodeKey = newRtx.getNodeKey();
                        oldNodeKey = oldRtx.getNodeKey();
                        if (newRtx.getKind() == Kind.ELEMENT) {
                            if (!FMSE.$assertionsDisabled && newRtx.getKind() != oldRtx.getKind()) {
                                throw new AssertionError();
                            }
                            if (newRtx.getAttributeCount() > 0) {
                                attCount = newRtx.getAttributeCount();
                                for (i = 0; i < attCount; ++i) {
                                    rtx.moveToAttribute(i);
                                    j = 0;
                                    oldAttCount = oldRtx.getAttributeCount();
                                    while (i < oldAttCount) {
                                        wtx.moveToAttribute(j);
                                        if (wtx.getName().equals((Object)rtx.getName())) {
                                            this.process(oldAxis.asXdmNodeReadTrx().getNodeKey(), newAxis.asXdmNodeReadTrx().getNodeKey());
                                            break;
                                        }
                                        oldAxis.asXdmNodeReadTrx().moveTo(oldNodeKey);
                                        ++j;
                                    }
                                    newAxis.asXdmNodeReadTrx().moveTo(newNodeKey);
                                }
                            }
                            if (newRtx.getNamespaceCount() > 0) {
                                nspCount = newRtx.getNamespaceCount();
                                for (i = 0; i < nspCount; ++i) {
                                    rtx.moveToNamespace(i);
                                    oldNspCount = oldRtx.getNamespaceCount();
                                    for (j = 0; j < oldNspCount; ++j) {
                                        wtx.moveToNamespace(j);
                                        if (wtx.getName().getNamespaceURI().equals(rtx.getName().getNamespaceURI()) && wtx.getName().getPrefix().equals(wtx.getName().getPrefix())) {
                                            this.process(wtx.getNodeKey(), rtx.getNodeKey());
                                            break;
                                        }
                                        oldAxis.asXdmNodeReadTrx().moveTo(oldNodeKey);
                                    }
                                    newAxis.asXdmNodeReadTrx().moveTo(newNodeKey);
                                }
                            }
                        }
                        newAxis.asXdmNodeReadTrx().moveTo(newNodeKey);
                    }
                    break;
                }
            }
        }
        catch (SirixException e) {
            FMSE.LOGWRAPPER.error(e.getMessage(), new Object[]{e});
        }
        return wtx.getNodeKey();
    }

    private void removeRightSiblingTextNode(XmlNodeTrx wtx) throws SirixException {
        assert (wtx != null);
        if (wtx.hasRightSibling()) {
            long nodeKey = wtx.getNodeKey();
            wtx.moveToRightSibling();
            if (wtx.getKind() == Kind.TEXT) {
                this.mTotalMatching.remove(wtx.getNodeKey());
                wtx.remove();
            }
            wtx.moveTo(nodeKey);
        }
    }

    private void process(long oldKey, long newKey) {
        Long reversePartner;
        this.mAlreadyInserted.put(newKey, true);
        Long partner = this.mTotalMatching.partner(oldKey);
        if (partner != null) {
            this.mTotalMatching.remove(oldKey);
        }
        if ((reversePartner = this.mTotalMatching.reversePartner(newKey)) != null) {
            this.mTotalMatching.remove(reversePartner);
        }
        assert (!this.mTotalMatching.contains(oldKey, newKey));
        this.mTotalMatching.add(oldKey, newKey);
        this.mInOrderOldRev.put(oldKey, true);
        this.mInOrderNewRev.put(newKey, true);
    }

    private int findPos(long x, XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        long v;
        assert (x > 0L);
        assert (wtx != null);
        assert (rtx != null);
        rtx.moveTo(x);
        if (rtx.getKind() == Kind.ATTRIBUTE || rtx.getKind() == Kind.NAMESPACE) {
            return 0;
        }
        long nodeKey = rtx.getNodeKey();
        rtx.moveToParent();
        if (rtx.hasFirstChild()) {
            rtx.moveToFirstChild();
            v = rtx.getNodeKey();
            if (this.mInOrderNewRev.get(v) != null && this.mInOrderNewRev.get(v).booleanValue() && v == x) {
                return 0;
            }
        }
        rtx.moveTo(nodeKey);
        rtx.moveToLeftSibling();
        v = rtx.getNodeKey();
        while (rtx.hasLeftSibling() && (this.mInOrderNewRev.get(v) == null || this.mInOrderNewRev.get(v) != null && !this.mInOrderNewRev.get(v).booleanValue())) {
            rtx.moveToLeftSibling();
            v = rtx.getNodeKey();
        }
        if (this.mInOrderNewRev.get(v) == null) {
            return 0;
        }
        Long u = this.mTotalMatching.reversePartner(v);
        int i = -1;
        if (u != null) {
            boolean moved = wtx.moveTo(u).hasMoved();
            assert (moved);
            long toNodeKey = u;
            wtx.moveToParent();
            wtx.moveToFirstChild();
            do {
                u = wtx.getNodeKey();
                ++i;
            } while (u != toNodeKey && wtx.hasRightSibling() && wtx.moveToRightSibling().hasMoved());
        }
        return i + 1;
    }

    private Matching fastMatch(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
        assert (wtx != null);
        assert (rtx != null);
        FMSENodeComparisonUtils nodeComparisonUtils = new FMSENodeComparisonUtils(this.mOldStartKey, this.mNewStartKey, wtx, rtx);
        FMSE.getLabels(wtx, this.mLabelOldRevVisitor);
        FMSE.getLabels(rtx, this.mLabelNewRevVisitor);
        Matching matching = new Matching(wtx, rtx);
        matching.reset();
        FMSE.match(this.mLabelOldRevVisitor.getLeafLabels(), this.mLabelNewRevVisitor.getLeafLabels(), matching, new LeafNodeComparator(this.mIdName, this.mWtx, this.mRtx, this.mOldPathSummary, this.mNewPathSummary, nodeComparisonUtils));
        Map<Kind, List<Long>> oldLabels = this.mLabelOldRevVisitor.getLabels();
        Map<Kind, List<Long>> newLabels = this.mLabelNewRevVisitor.getLabels();
        oldLabels.remove(Kind.XDM_DOCUMENT);
        newLabels.remove(Kind.XDM_DOCUMENT);
        wtx.moveTo(this.mOldStartKey);
        rtx.moveTo(this.mNewStartKey);
        wtx.moveToParent();
        rtx.moveToParent();
        matching.add(wtx.getNodeKey(), rtx.getNodeKey());
        NodeComparator<Long> innerNodeComparator = this.mNodeComparisonFactory.createInnerNodeEqualityChecker(this.mIdName, matching, wtx, rtx, new FMSENodeComparisonUtils(this.mOldStartKey, this.mNewStartKey, wtx, rtx), this.mDescendantsOldRev, this.mDescendantsNewRev);
        FMSE.match(oldLabels, newLabels, matching, innerNodeComparator);
        return matching;
    }

    private static void match(Map<Kind, List<Long>> oldLabels, Map<Kind, List<Long>> newLabels, Matching matching, NodeComparator<Long> cmp) {
        Set<Kind> labels = oldLabels.keySet();
        labels.retainAll(newLabels.keySet());
        for (Kind label : labels) {
            List<Long> first = oldLabels.get(label);
            List<Long> second = newLabels.get(label);
            List<Pair<Long, Long>> common = Util.longestCommonSubsequence(first, second, cmp);
            HashMap<Long, Boolean> seen = new HashMap<Long, Boolean>();
            for (Pair<Long, Long> p : common) {
                matching.add(p.getFirst(), p.getSecond());
                seen.put(p.getFirst(), true);
                seen.put(p.getSecond(), true);
            }
            FMSE.removeCommonNodes(first, seen);
            FMSE.removeCommonNodes(second, seen);
            Iterator<Long> firstIterator = first.iterator();
            block2: while (firstIterator.hasNext()) {
                Long firstItem = firstIterator.next();
                boolean firstIter = true;
                Iterator<Long> secondIterator = second.iterator();
                while (secondIterator.hasNext()) {
                    Long secondItem = secondIterator.next();
                    if (!cmp.isEqual(firstItem, secondItem)) continue;
                    matching.add(firstItem, secondItem);
                    if (firstIter) {
                        firstIter = false;
                        firstIterator.remove();
                    }
                    secondIterator.remove();
                    continue block2;
                }
            }
        }
    }

    private static void removeCommonNodes(List<Long> list, Map<Long, Boolean> seen) {
        assert (list != null);
        assert (seen != null);
        Iterator<Long> iterator = list.iterator();
        while (iterator.hasNext()) {
            Long item = iterator.next();
            if (!seen.containsKey(item)) continue;
            iterator.remove();
        }
    }

    private static void init(XmlNodeReadOnlyTrx rtx, XmlNodeVisitor visitor) {
        assert (visitor != null);
        long nodeKey = rtx.getNodeKey();
        PostOrderAxis axis = new PostOrderAxis(rtx);
        while (axis.hasNext()) {
            axis.next();
            if (axis.asXdmNodeReadTrx().getNodeKey() == nodeKey) break;
            axis.asXdmNodeReadTrx().acceptVisitor(visitor);
        }
        rtx.acceptVisitor(visitor);
    }

    private static void getLabels(XmlNodeReadOnlyTrx rtx, LabelFMSEVisitor visitor) {
        assert (rtx != null);
        assert (visitor != null);
        long nodeKey = rtx.getNodeKey();
        PostOrderAxis axis = new PostOrderAxis(rtx);
        while (axis.hasNext()) {
            axis.next();
            if (axis.asXdmNodeReadTrx().getNodeKey() == nodeKey) break;
            axis.asXdmNodeReadTrx().acceptVisitor(visitor);
        }
        rtx.acceptVisitor(visitor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void close() {
        this.mWtx.commit();
        this.mOldPathSummary.close();
        this.mNewPathSummary.close();
    }

    static enum ReverseMap {
        TRUE,
        FALSE;

    }
}

