/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnegative;
import org.sirix.access.trx.node.HashType;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.diff.DiffObserver;
import org.sirix.diff.JsonDiff;
import org.sirix.diff.XmlFullDiff;
import org.sirix.diff.XmlStructuralDiff;

public final class DiffFactory {
    public static Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder(XmlResourceManager resourceManager, @Nonnegative int newRev, @Nonnegative int oldRev, DiffOptimized diffKind, Set<DiffObserver> observers) {
        return new Builder<XmlNodeReadOnlyTrx, XmlNodeTrx>(resourceManager, newRev, oldRev, diffKind, observers);
    }

    private DiffFactory() {
        throw new AssertionError((Object)"No instantiation allowed!");
    }

    public static synchronized void invokeJsonDiff(Builder<JsonNodeReadOnlyTrx, JsonNodeTrx> builder) {
        DiffAlgorithm.JSON.invoke(builder);
    }

    public static synchronized void invokeFullXmlDiff(Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) {
        DiffAlgorithm.XML_FULL.invoke(builder);
    }

    public static synchronized void invokeStructuralXmlDiff(Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) {
        DiffAlgorithm.XML_STRUCTURAL.invoke(builder);
    }

    public static final class Builder<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> {
        final ResourceManager<R, W> mResMgr;
        transient long mNewStartKey;
        transient long mOldStartKey;
        final int mNewRev;
        final int mOldRev;
        transient int mNewDepth;
        transient int mOldDepth;
        final DiffOptimized mKind;
        final Set<DiffObserver> mObservers;
        transient DiffAlgorithm mDiffKind;
        transient HashType mHashKind = HashType.ROLLING;
        transient boolean mIsGUI = true;
        transient boolean mSkipSubtrees = false;

        public Builder(ResourceManager<R, W> resMgr, @Nonnegative int newRev, @Nonnegative int oldRev, DiffOptimized diffKind, Set<DiffObserver> observers) {
            this.mResMgr = (ResourceManager)Preconditions.checkNotNull(resMgr);
            Preconditions.checkArgument((newRev >= 0 ? 1 : 0) != 0, (Object)"paramNewRev must be >= 0!");
            this.mNewRev = newRev;
            Preconditions.checkArgument((oldRev >= 0 ? 1 : 0) != 0, (Object)"paramOldRev must be >= 0!");
            this.mOldRev = oldRev;
            this.mKind = (DiffOptimized)((Object)Preconditions.checkNotNull((Object)((Object)diffKind)));
            this.mObservers = (Set)Preconditions.checkNotNull(observers);
        }

        public Builder<R, W> isGUI(boolean isGUI) {
            this.mIsGUI = isGUI;
            return this;
        }

        public Builder<R, W> oldStartKey(@Nonnegative long oldKey) {
            Preconditions.checkArgument((oldKey >= 0L ? 1 : 0) != 0, (Object)"oldKey must be >= 0!");
            this.mOldStartKey = oldKey;
            return this;
        }

        public Builder<R, W> newStartKey(@Nonnegative long newKey) {
            Preconditions.checkArgument((newKey >= 0L ? 1 : 0) != 0, (Object)"newKey must be >= 0!");
            this.mNewStartKey = newKey;
            return this;
        }

        public Builder<R, W> newDepth(@Nonnegative int newDepth) {
            Preconditions.checkArgument((newDepth >= 0 ? 1 : 0) != 0, (Object)"newDepth must be >= 0!");
            this.mNewDepth = newDepth;
            return this;
        }

        public Builder<R, W> oldDepth(int oldDepth) {
            Preconditions.checkArgument((oldDepth >= 0 ? 1 : 0) != 0, (Object)"oldDepth must be >= 0!");
            this.mOldDepth = oldDepth;
            return this;
        }

        public Builder<R, W> diffAlgorithm(DiffAlgorithm diffAlgorithm) {
            this.mDiffKind = (DiffAlgorithm)((Object)Preconditions.checkNotNull((Object)((Object)diffAlgorithm)));
            return this;
        }

        public Builder<R, W> hashKind(HashType kind) {
            this.mHashKind = (HashType)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
            return this;
        }

        public Builder<R, W> skipSubtrees(boolean skipSubtrees) {
            this.mSkipSubtrees = skipSubtrees;
            return this;
        }
    }

    private static enum DiffAlgorithm {
        XML_FULL{

            @Override
            <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> builder) {
                Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> xmlDiffBuilder = builder;
                new XmlFullDiff(xmlDiffBuilder).diffMovement();
            }
        }
        ,
        XML_STRUCTURAL{

            @Override
            <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> builder) {
                Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> xmlDiffBuilder = builder;
                new XmlStructuralDiff(xmlDiffBuilder).diffMovement();
            }
        }
        ,
        JSON{

            @Override
            <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> builder) {
                Builder<JsonNodeReadOnlyTrx, JsonNodeTrx> jsonDiffBuilder = builder;
                new JsonDiff(jsonDiffBuilder).diffMovement();
            }
        };


        abstract <R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> void invoke(Builder<R, W> var1);
    }

    public static enum DiffOptimized {
        NO,
        HASHED;

    }

    public static enum DiffType {
        SAME,
        SAMEHASH,
        INSERTED,
        DELETED,
        UPDATED,
        REPLACED,
        REPLACEDNEW,
        REPLACEDOLD,
        MOVEDFROM,
        MOVEDTO;

    }
}

