/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.sirix.diff.DiffDepth;
import org.sirix.diff.DiffFactory;
import org.sirix.diff.DiffObservable;
import org.sirix.diff.DiffObserver;
import org.sirix.exception.SirixException;

abstract class AbstractDiffObservable
implements DiffObservable {
    private final Set<DiffObserver> mDiffObservers = new HashSet<DiffObserver>();

    AbstractDiffObservable() {
    }

    @Override
    public final void fireDiff(DiffFactory.DiffType diff, @Nonnull long newNodeKey, @Nonnull long oldNodeKey, @Nonnull DiffDepth depth) {
        for (DiffObserver observer : this.mDiffObservers) {
            observer.diffListener(diff, newNodeKey, oldNodeKey, depth);
        }
    }

    @Override
    public final void done() throws SirixException {
        for (DiffObserver observer : this.mDiffObservers) {
            observer.diffDone();
        }
    }

    @Override
    public final void addObserver(DiffObserver observer) {
        this.mDiffObservers.add(observer);
    }

    @Override
    public final void removeObserver(DiffObserver observer) {
        this.mDiffObservers.remove(observer);
    }
}

