/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.sirix.access.trx.node.HashType;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.diff.AbstractDiffObservable;
import org.sirix.diff.DepthCounter;
import org.sirix.diff.DiffDepth;
import org.sirix.diff.DiffFactory;
import org.sirix.diff.DiffObserver;
import org.sirix.diff.FoundMatchingNode;
import org.sirix.exception.SirixException;
import org.sirix.node.Kind;

@Nonnull
abstract class AbstractDiff<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractDiffObservable {
    private HashType mHashKind;
    private DiffFactory.DiffType mDiff;
    private DiffFactory.DiffOptimized mDiffKind;
    private final DepthCounter mDepth;
    private long mRootKey;
    private final long mOldRootKey;
    private final boolean mNewRtxMoved;
    private final boolean mOldRtxMoved;
    private final boolean mIsGUI;
    private boolean mIsFirst;
    private final R mNewRtx;
    private final R mOldRtx;
    private final boolean mSkipSubtrees;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractDiff(DiffFactory.Builder<R, W> builder) throws SirixException {
        this.mSkipSubtrees = builder.mSkipSubtrees;
        this.mDiffKind = ((DiffFactory.Builder)Preconditions.checkNotNull(builder)).mKind;
        Object object = builder.mResMgr;
        synchronized (object) {
            this.mNewRtx = builder.mResMgr.beginNodeReadOnlyTrx(builder.mNewRev);
            this.mOldRtx = builder.mResMgr.beginNodeReadOnlyTrx(builder.mOldRev);
            this.mHashKind = builder.mHashKind;
        }
        this.mNewRtxMoved = this.mNewRtx.moveTo(builder.mNewStartKey).hasMoved();
        this.mOldRtxMoved = this.mOldRtx.moveTo(builder.mOldStartKey).hasMoved();
        if (((NodeCursor)this.mNewRtx).getKind() == Kind.XDM_DOCUMENT) {
            ((NodeCursor)this.mNewRtx).moveToFirstChild();
        }
        if (((NodeCursor)this.mOldRtx).getKind() == Kind.XDM_DOCUMENT) {
            ((NodeCursor)this.mOldRtx).moveToFirstChild();
        }
        this.mRootKey = builder.mNewStartKey;
        this.mOldRootKey = builder.mOldStartKey;
        object = builder.mObservers;
        synchronized (object) {
            for (DiffObserver observer : builder.mObservers) {
                this.addObserver(observer);
            }
        }
        this.mDiff = DiffFactory.DiffType.SAME;
        this.mDiffKind = builder.mKind;
        this.mDepth = new DepthCounter(builder.mNewDepth, builder.mOldDepth);
        this.mIsGUI = builder.mIsGUI;
        this.mIsFirst = true;
    }

    void diffMovement() {
        assert (this.mHashKind != null);
        assert (this.mNewRtx != null);
        assert (this.mOldRtx != null);
        assert (this.mDiff != null);
        assert (this.mDiffKind != null);
        if (!this.mNewRtxMoved) {
            this.fireDeletes();
            if (!this.mIsGUI || this.mDepth.getNewDepth() == 0) {
                this.fireInserts();
            }
            this.done();
            return;
        }
        if (!this.mOldRtxMoved) {
            this.fireInserts();
            if (!this.mIsGUI || this.mDepth.getOldDepth() == 0) {
                this.fireDeletes();
            }
            this.done();
            return;
        }
        this.mDiff = this.mHashKind == HashType.NONE || this.mDiffKind == DiffFactory.DiffOptimized.NO ? this.diff(this.mNewRtx, this.mOldRtx, this.mDepth) : this.optimizedDiff(this.mNewRtx, this.mOldRtx, this.mDepth);
        this.mIsFirst = false;
        if (this.mDiff != DiffFactory.DiffType.SAMEHASH) {
            while (((NodeCursor)this.mOldRtx).getKind() != Kind.XDM_DOCUMENT && this.mDiff == DiffFactory.DiffType.DELETED || this.moveCursor(this.mNewRtx, Revision.NEW, Move.FOLLOWING)) {
                if (this.mDiff != DiffFactory.DiffType.INSERTED) {
                    this.moveCursor(this.mOldRtx, Revision.OLD, Move.FOLLOWING);
                }
                if (((NodeCursor)this.mNewRtx).getKind() == Kind.XDM_DOCUMENT && ((NodeCursor)this.mOldRtx).getKind() == Kind.XDM_DOCUMENT) continue;
                if (this.mHashKind == HashType.NONE || this.mDiffKind == DiffFactory.DiffOptimized.NO) {
                    this.mDiff = this.diff(this.mNewRtx, this.mOldRtx, this.mDepth);
                    continue;
                }
                this.mDiff = this.optimizedDiff(this.mNewRtx, this.mOldRtx, this.mDepth);
            }
            if (((NodeCursor)this.mOldRtx).getKind() != Kind.XDM_DOCUMENT) {
                DiffDepth depth;
                this.mRootKey = this.mOldRootKey;
                if (this.mDiff == DiffFactory.DiffType.INSERTED) {
                    this.mDiff = DiffFactory.DiffType.DELETED;
                    DiffDepth depth2 = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                    this.fireDiff(this.mDiff, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), depth2);
                    this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, depth2, this.mDiff);
                }
                boolean moved = true;
                if (this.mDiffKind == DiffFactory.DiffOptimized.HASHED && this.mDiff == DiffFactory.DiffType.SAMEHASH && (moved = this.moveToFollowingNode(this.mOldRtx, Revision.OLD))) {
                    this.mDiff = DiffFactory.DiffType.DELETED;
                    depth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                    this.fireDiff(this.mDiff, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), depth);
                    this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, depth, this.mDiff);
                }
                if (moved) {
                    while (this.moveCursor(this.mOldRtx, Revision.OLD, Move.DOCUMENT_ORDER)) {
                        this.mDiff = DiffFactory.DiffType.DELETED;
                        depth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                        this.fireDiff(this.mDiff, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), depth);
                        this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, depth, this.mDiff);
                    }
                }
            }
        }
        this.diffDone();
    }

    private void diffDone() throws SirixException {
        this.mNewRtx.close();
        this.mOldRtx.close();
        this.done();
    }

    private void fireDeletes() {
        this.fireDiff(DiffFactory.DiffType.DELETED, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth()));
        this.mIsFirst = false;
        if (this.mSkipSubtrees) {
            this.moveToFollowingNode(this.mOldRtx, Revision.OLD);
        } else {
            while (this.moveCursor(this.mOldRtx, Revision.OLD, Move.DOCUMENT_ORDER)) {
                DiffDepth depth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                this.fireDiff(DiffFactory.DiffType.DELETED, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), depth);
                this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, depth, DiffFactory.DiffType.DELETED);
            }
        }
    }

    private void fireInserts() {
        this.fireDiff(DiffFactory.DiffType.INSERTED, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth()));
        this.mIsFirst = false;
        if (this.mSkipSubtrees) {
            this.moveToFollowingNode(this.mNewRtx, Revision.NEW);
        } else {
            while (this.moveCursor(this.mNewRtx, Revision.NEW, Move.DOCUMENT_ORDER)) {
                DiffDepth depth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                this.fireDiff(DiffFactory.DiffType.INSERTED, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), depth);
                this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, depth, DiffFactory.DiffType.DELETED);
            }
        }
    }

    private boolean moveCursor(R rtx, Revision revision, Move move) {
        assert (rtx != null);
        assert (revision != null);
        boolean moved = false;
        if (((NodeCursor)rtx).getKind() != Kind.XDM_DOCUMENT) {
            switch (this.mDiff) {
                case SAME: 
                case SAMEHASH: 
                case UPDATED: {
                    moved = this.moveToNext(rtx, revision);
                    break;
                }
                case REPLACED: {
                    moved = this.moveToFollowingNode(rtx, revision);
                    break;
                }
                case INSERTED: 
                case DELETED: {
                    if (move == Move.FOLLOWING && (this.mDiff == DiffFactory.DiffType.INSERTED || this.mDiff == DiffFactory.DiffType.DELETED)) {
                        if (((NodeCursor)rtx).getKind() == Kind.XDM_DOCUMENT) {
                            moved = false;
                            break;
                        }
                        moved = true;
                        break;
                    }
                    moved = this.moveToNext(rtx, revision);
                    break;
                }
            }
        }
        return moved;
    }

    private boolean moveToNext(R rtx, Revision revision) {
        boolean moved = false;
        if (((NodeCursor)rtx).hasFirstChild()) {
            if (((NodeCursor)rtx).getKind() != Kind.XDM_DOCUMENT && this.mDiffKind == DiffFactory.DiffOptimized.HASHED && this.mDiff == DiffFactory.DiffType.SAMEHASH) {
                moved = ((NodeCursor)rtx).moveToRightSibling().hasMoved();
                if (!moved) {
                    moved = this.moveToFollowingNode(rtx, revision);
                }
            } else {
                moved = ((NodeCursor)rtx).moveToFirstChild().hasMoved();
                if (moved) {
                    switch (revision) {
                        case NEW: {
                            this.mDepth.incrementNewDepth();
                            break;
                        }
                        case OLD: {
                            this.mDepth.incrementOldDepth();
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
        } else if (((NodeCursor)rtx).hasRightSibling()) {
            if (rtx.getNodeKey() == this.mRootKey) {
                ((NodeCursor)rtx).moveToDocumentRoot();
            } else {
                moved = ((NodeCursor)rtx).moveToRightSibling().hasMoved();
            }
        } else {
            moved = this.moveToFollowingNode(rtx, revision);
        }
        return moved;
    }

    private boolean moveToFollowingNode(R rtx, Revision revision) {
        boolean moved = false;
        block4: while (!((NodeCursor)rtx).hasRightSibling() && ((NodeCursor)rtx).hasParent() && rtx.getNodeKey() != this.mRootKey) {
            moved = ((NodeCursor)rtx).moveToParent().hasMoved();
            if (!moved) continue;
            switch (revision) {
                case NEW: {
                    this.mDepth.decrementNewDepth();
                    continue block4;
                }
                case OLD: {
                    this.mDepth.decrementOldDepth();
                    continue block4;
                }
            }
        }
        if (rtx.getNodeKey() == this.mRootKey) {
            ((NodeCursor)rtx).moveToDocumentRoot();
        }
        moved = ((NodeCursor)rtx).moveToRightSibling().hasMoved();
        return moved;
    }

    DiffFactory.DiffType diff(R newRtx, R oldRtx, DepthCounter depth) {
        assert (newRtx != null);
        assert (oldRtx != null);
        assert (depth != null);
        DiffFactory.DiffType diff = DiffFactory.DiffType.SAME;
        switch (((NodeCursor)newRtx).getKind()) {
            case XDM_DOCUMENT: 
            case TEXT: 
            case ELEMENT: {
                if (this.checkNodes(newRtx, oldRtx)) {
                    DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
                    this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                    this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
                    break;
                }
                diff = this.diffAlgorithm(newRtx, oldRtx, depth);
                break;
            }
        }
        return diff;
    }

    DiffFactory.DiffType optimizedDiff(R newRtx, R oldRtx, DepthCounter depth) {
        assert (newRtx != null);
        assert (oldRtx != null);
        assert (depth != null);
        DiffFactory.DiffType diff = DiffFactory.DiffType.SAMEHASH;
        switch (((NodeCursor)newRtx).getKind()) {
            case XDM_DOCUMENT: 
            case TEXT: 
            case ELEMENT: {
                if (newRtx.getNodeKey() != oldRtx.getNodeKey() || newRtx.getHash() != oldRtx.getHash()) {
                    if (this.checkNodes(newRtx, oldRtx)) {
                        diff = DiffFactory.DiffType.SAME;
                        DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
                        this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                        this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
                        break;
                    }
                    diff = this.diffAlgorithm(newRtx, oldRtx, depth);
                    break;
                }
                DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
                this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
                break;
            }
        }
        return diff;
    }

    private DiffFactory.DiffType diffAlgorithm(R newRtx, R oldRtx, DepthCounter depth) {
        assert (newRtx != null);
        assert (oldRtx != null);
        assert (depth != null);
        DiffFactory.DiffType diff = null;
        if (depth.getOldDepth() > depth.getNewDepth()) {
            diff = DiffFactory.DiffType.DELETED;
            this.emitDiffs(diff);
        } else if (this.checkUpdate(newRtx, oldRtx)) {
            diff = DiffFactory.DiffType.UPDATED;
            DiffDepth diffDepth = new DiffDepth(depth.getNewDepth(), depth.getOldDepth());
            if (this.checkNodeNamesOrValues(newRtx, oldRtx)) {
                this.fireDiff(DiffFactory.DiffType.SAME, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
            } else {
                this.fireDiff(diff, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
            }
            this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, diff);
        } else if (this.checkReplace(newRtx, oldRtx)) {
            diff = DiffFactory.DiffType.REPLACED;
        } else {
            long oldKey = oldRtx.getNodeKey();
            boolean movedOld = oldRtx.moveTo(newRtx.getNodeKey()).hasMoved();
            oldRtx.moveTo(oldKey);
            long newKey = newRtx.getNodeKey();
            boolean movedNew = newRtx.moveTo(oldRtx.getNodeKey()).hasMoved();
            newRtx.moveTo(newKey);
            if (!movedOld) {
                diff = DiffFactory.DiffType.INSERTED;
            } else if (!movedNew) {
                diff = DiffFactory.DiffType.DELETED;
            } else {
                FoundMatchingNode found = FoundMatchingNode.FALSE;
                while (((NodeCursor)oldRtx).hasRightSibling() && ((NodeCursor)oldRtx).moveToRightSibling().hasMoved() && found == FoundMatchingNode.FALSE) {
                    if (!this.checkNodeNamesOrValuesAndNodeKeys(newRtx, oldRtx)) continue;
                    found = FoundMatchingNode.TRUE;
                    break;
                }
                oldRtx.moveTo(oldKey);
                diff = found.kindOfDiff();
            }
            this.mDiff = diff;
            this.emitDiffs(diff);
        }
        assert (diff != null);
        return diff;
    }

    private void emitDiffs(DiffFactory.DiffType diff) {
        R rtx;
        Revision revision = diff == DiffFactory.DiffType.DELETED ? Revision.OLD : Revision.NEW;
        int depth = diff == DiffFactory.DiffType.DELETED ? this.mDepth.getOldDepth() : this.mDepth.getNewDepth();
        R r = rtx = diff == DiffFactory.DiffType.DELETED ? this.mOldRtx : this.mNewRtx;
        if (this.mSkipSubtrees) {
            DiffDepth diffDepth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
            this.fireDiff(diff, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), diffDepth);
            this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, diffDepth, diff);
            this.moveToFollowingNode(rtx, revision);
        } else {
            do {
                DiffDepth diffDepth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                this.fireDiff(diff, this.mNewRtx.getNodeKey(), this.mOldRtx.getNodeKey(), diffDepth);
                this.emitNonStructuralDiff(this.mNewRtx, this.mOldRtx, diffDepth, diff);
            } while (this.moveCursor(rtx, revision, Move.DOCUMENT_ORDER) && (diff == DiffFactory.DiffType.INSERTED && this.mDepth.getNewDepth() > depth || diff == DiffFactory.DiffType.DELETED && this.mDepth.getOldDepth() > depth));
        }
    }

    abstract boolean checkNodes(R var1, R var2);

    private boolean checkNodeNamesOrValuesAndNodeKeys(R newRtx, R oldRtx) {
        return newRtx.getNodeKey() == oldRtx.getNodeKey() && this.checkNodeNamesOrValues(newRtx, oldRtx);
    }

    abstract void emitNonStructuralDiff(R var1, R var2, DiffDepth var3, DiffFactory.DiffType var4);

    boolean checkReplace(R newRtx, R oldRtx) {
        boolean replaced = false;
        if (newRtx.getNodeKey() != oldRtx.getNodeKey()) {
            long newKey = newRtx.getNodeKey();
            boolean movedNewRtx = ((NodeCursor)newRtx).moveToRightSibling().hasMoved();
            long oldKey = oldRtx.getNodeKey();
            boolean movedOldRtx = ((NodeCursor)oldRtx).moveToRightSibling().hasMoved();
            if (movedNewRtx && movedOldRtx) {
                if (newRtx.getNodeKey() == oldRtx.getNodeKey()) {
                    replaced = true;
                } else {
                    while (((NodeCursor)newRtx).hasRightSibling() && ((NodeCursor)oldRtx).hasRightSibling()) {
                        ((NodeCursor)newRtx).moveToRightSibling();
                        ((NodeCursor)oldRtx).moveToRightSibling();
                        if (newRtx.getNodeKey() != oldRtx.getNodeKey()) continue;
                        replaced = true;
                        break;
                    }
                }
            } else if (!(movedNewRtx || movedOldRtx || this.mDiff != DiffFactory.DiffType.SAME && this.mDiff != DiffFactory.DiffType.SAMEHASH)) {
                movedNewRtx = ((NodeCursor)newRtx).moveToParent().hasMoved();
                movedOldRtx = ((NodeCursor)oldRtx).moveToParent().hasMoved();
                if (movedNewRtx && movedOldRtx && newRtx.getNodeKey() == oldRtx.getNodeKey()) {
                    replaced = true;
                }
            }
            newRtx.moveTo(newKey);
            oldRtx.moveTo(oldKey);
            if (replaced) {
                if (this.mSkipSubtrees) {
                    DiffDepth diffDepth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                    this.fireDiff(DiffFactory.DiffType.REPLACEDOLD, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                    this.fireDiff(DiffFactory.DiffType.REPLACEDNEW, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                    this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, DiffFactory.DiffType.REPLACEDOLD);
                } else {
                    DiffDepth diffDepth;
                    long newNodeKey = newRtx.getNodeKey();
                    long oldNodeKey = oldRtx.getNodeKey();
                    DescendantAxis oldAxis = new DescendantAxis((NodeCursor)oldRtx, IncludeSelf.YES);
                    DescendantAxis newAxis = new DescendantAxis((NodeCursor)newRtx, IncludeSelf.YES);
                    while (oldAxis.hasNext()) {
                        oldAxis.next();
                        diffDepth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                        this.fireDiff(DiffFactory.DiffType.REPLACEDOLD, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                        this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, DiffFactory.DiffType.REPLACEDOLD);
                        this.adjustDepth(oldRtx, oldNodeKey, Revision.OLD);
                    }
                    while (newAxis.hasNext()) {
                        newAxis.next();
                        diffDepth = new DiffDepth(this.mDepth.getNewDepth(), this.mDepth.getOldDepth());
                        this.fireDiff(DiffFactory.DiffType.REPLACEDNEW, newRtx.getNodeKey(), oldRtx.getNodeKey(), diffDepth);
                        this.emitNonStructuralDiff(newRtx, oldRtx, diffDepth, DiffFactory.DiffType.REPLACEDNEW);
                        this.adjustDepth(newRtx, newNodeKey, Revision.NEW);
                    }
                    newRtx.moveTo(newNodeKey);
                    oldRtx.moveTo(oldNodeKey);
                    this.mDiff = DiffFactory.DiffType.REPLACED;
                }
            }
        }
        return replaced;
    }

    private void adjustDepth(R rtx, @Nonnegative long startNodeKey, Revision revision) {
        assert (rtx != null);
        assert (startNodeKey >= 0L);
        assert (revision != null);
        long nodeKey = rtx.getNodeKey();
        if (((NodeCursor)rtx).hasFirstChild()) {
            switch (revision) {
                case NEW: {
                    this.mDepth.incrementNewDepth();
                    break;
                }
                case OLD: {
                    this.mDepth.incrementOldDepth();
                    break;
                }
            }
        } else {
            block8: while (!((NodeCursor)rtx).hasRightSibling() && ((NodeCursor)rtx).hasParent() && rtx.getNodeKey() != startNodeKey) {
                ((NodeCursor)rtx).moveToParent();
                switch (revision) {
                    case NEW: {
                        this.mDepth.decrementNewDepth();
                        continue block8;
                    }
                    case OLD: {
                        this.mDepth.decrementOldDepth();
                        continue block8;
                    }
                }
            }
        }
        rtx.moveTo(nodeKey);
    }

    boolean checkUpdate(R newRtx, R oldRtx) {
        if (this.mIsFirst) {
            return newRtx.getNodeKey() == oldRtx.getNodeKey();
        }
        return newRtx.getNodeKey() == oldRtx.getNodeKey() && ((NodeCursor)newRtx).getParentKey() == ((NodeCursor)oldRtx).getParentKey() && this.mDepth.getNewDepth() == this.mDepth.getOldDepth();
    }

    abstract boolean checkNodeNamesOrValues(R var1, R var2);

    private static enum Revision {
        OLD,
        NEW;

    }

    private static enum Move {
        FOLLOWING,
        DOCUMENT_ORDER;

    }
}

