/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sirix.cache.Cache;
import org.sirix.cache.EmptyCache;

public final class LRUCache<K, V>
implements Cache<K, V> {
    static final int CACHE_CAPACITY = 1;
    private final Map<K, V> mMap;
    private final Cache<K, V> mSecondCache;

    public LRUCache(Cache<K, V> secondCache) {
        assert (secondCache != null);
        this.mSecondCache = secondCache;
        this.mMap = new LinkedHashMap<K, V>(1){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
                boolean returnVal = false;
                if (this.size() > 1) {
                    if (eldest != null) {
                        Object key = eldest.getKey();
                        Object value = eldest.getValue();
                        if (key != null && value != null) {
                            LRUCache.this.mSecondCache.put(key, value);
                        }
                    }
                    returnVal = true;
                }
                return returnVal;
            }
        };
    }

    public LRUCache() {
        this(new EmptyCache());
    }

    @Override
    public V get(K key) {
        V value = this.mMap.get(key);
        if (value == null && (value = this.mSecondCache.get(key)) != null) {
            this.mMap.put(key, value);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        this.mMap.put(key, value);
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mSecondCache.clear();
    }

    public int usedEntries() {
        return this.mMap.size();
    }

    public Collection<Map.Entry<? super K, ? super V>> getAll() {
        return new ArrayList<Map.Entry<? super K, ? super V>>(this.mMap.entrySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("First Cache", this.mMap).add("Second Cache", this.mSecondCache).toString();
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (K key : keys) {
            if (this.mMap.get(key) == null) continue;
            builder.put(key, this.mMap.get(key));
        }
        return builder.build();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.mMap.putAll((Map)Preconditions.checkNotNull(map));
    }

    @Override
    public void toSecondCache() {
        this.mSecondCache.putAll(this.mMap);
    }

    public Map<K, V> getMap() {
        return Collections.unmodifiableMap(this.mMap);
    }

    @Override
    public void remove(K key) {
        this.mMap.remove(key);
        if (this.mSecondCache.get(key) != null) {
            this.mSecondCache.remove(key);
        }
    }

    @Override
    public void close() {
        this.mMap.clear();
        this.mSecondCache.close();
    }
}

