/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.sirix.page.PageKind;

public final class IndirectPageLogKey {
    private int mLevel;
    private int mOffset;
    private PageKind mPageKind;
    private int mIndex;
    private long mPageKey;

    public IndirectPageLogKey(PageKind pageKind, int index, int level, int offset, long pageKey) {
        assert (level >= -1);
        assert (offset >= -1);
        assert (pageKind != null);
        this.mPageKind = pageKind;
        this.mIndex = index;
        this.mLevel = level;
        this.mOffset = offset;
        this.mPageKey = pageKey;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public PageKind getPageKind() {
        return this.mPageKind;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public long getPageKey() {
        return this.mPageKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mPageKind, this.mIndex, this.mLevel, this.mOffset, this.mPageKey});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof IndirectPageLogKey) {
            IndirectPageLogKey other = (IndirectPageLogKey)obj;
            return this.mPageKind == other.mPageKind && this.mIndex == other.mIndex && this.mLevel == other.mLevel && this.mOffset == other.mOffset && this.mPageKey == other.mPageKey;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pageKind", (Object)this.mPageKind).add("index", this.mIndex).add("level", this.mLevel).add("offset", this.mOffset).add("pageKey", this.mPageKey).toString();
    }
}

