/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.visitor;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nonnegative;
import org.sirix.api.NodeCursor;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.NodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.visitor.LocalVisitResult;
import org.sirix.settings.Fixed;

public final class VisitorDescendantAxis
extends AbstractAxis {
    private Deque<Long> mRightSiblingKeyStack;
    private NodeVisitor mVisitor;
    private boolean mFirst;

    public static Builder newBuilder(NodeCursor cursor) {
        return new Builder(cursor);
    }

    private VisitorDescendantAxis(Builder builder) {
        super(builder.mRtx, builder.mIncludeSelf);
        this.mVisitor = builder.mVisitor;
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mFirst = true;
        this.mRightSiblingKeyStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        VisitResult result = null;
        if (this.mVisitor != null) {
            if (this.getTrx() instanceof XmlNodeReadOnlyTrx) {
                result = this.asXdmNodeReadTrx().acceptVisitor((XmlNodeVisitor)this.mVisitor);
            } else if (this.getTrx() instanceof JsonNodeReadOnlyTrx) {
                result = this.asJsonNodeReadTrx().acceptVisitor((JsonNodeVisitor)this.mVisitor);
            } else {
                throw new AssertionError();
            }
        }
        if (VisitResultType.TERMINATE == result) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        NodeCursor cursor = this.getCursor();
        if (this.mFirst) {
            this.mFirst = false;
            return this.isSelfIncluded() == IncludeSelf.YES ? cursor.getNodeKey() : cursor.getFirstChildKey();
        }
        if (LocalVisitResult.SKIPSUBTREEPOPSTACK == result) {
            this.mRightSiblingKeyStack.pop();
        }
        if ((result != null && result != VisitResultType.SKIPSUBTREE && result != LocalVisitResult.SKIPSUBTREEPOPSTACK || result == null) && cursor.hasFirstChild()) {
            long key = cursor.getFirstChildKey();
            long rightSiblNodeKey = cursor.getRightSiblingKey();
            if (cursor.hasRightSibling() && (this.mRightSiblingKeyStack.isEmpty() || !this.mRightSiblingKeyStack.isEmpty() && this.mRightSiblingKeyStack.peek() != rightSiblNodeKey)) {
                this.mRightSiblingKeyStack.push(rightSiblNodeKey);
            }
            return key;
        }
        if ((result != null && result != VisitResultType.SKIPSIBLINGS || result == null) && cursor.hasRightSibling()) {
            long nextKey = cursor.getRightSiblingKey();
            return this.hasNextNode(nextKey, cursor.getNodeKey());
        }
        if (this.mRightSiblingKeyStack.size() > 0) {
            long nextKey = this.mRightSiblingKeyStack.pop();
            return this.hasNextNode(nextKey, cursor.getNodeKey());
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    private long hasNextNode(@Nonnegative long nextKey, @Nonnegative long currKey) {
        NodeCursor cursor = this.getCursor();
        cursor.moveTo(nextKey);
        if (cursor.getLeftSiblingKey() == this.getStartKey()) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        cursor.moveTo(currKey);
        return nextKey;
    }

    public static class Builder {
        private NodeVisitor mVisitor;
        private final NodeCursor mRtx;
        private IncludeSelf mIncludeSelf = IncludeSelf.NO;

        public Builder(NodeCursor rtx) {
            this.mRtx = (NodeCursor)Preconditions.checkNotNull((Object)rtx);
        }

        public Builder includeSelf() {
            this.mIncludeSelf = IncludeSelf.YES;
            return this;
        }

        public Builder visitor(NodeVisitor visitor) {
            this.mVisitor = (NodeVisitor)Preconditions.checkNotNull((Object)visitor);
            return this;
        }

        public VisitorDescendantAxis build() {
            return new VisitorDescendantAxis(this);
        }
    }
}

