/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.temporal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.axis.AbstractTemporalAxis;

public final class LastAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private final ResourceManager<R, W> mResourceManager;
    private long mNodeKey;
    private boolean mFirst;

    public LastAxis(ResourceManager<R, W> resourceManager, R rtx) {
        this.mResourceManager = (ResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mNodeKey = rtx.getNodeKey();
        this.mFirst = true;
    }

    protected R computeNext() {
        if (this.mFirst) {
            this.mFirst = false;
            Optional<R> optionalRtx = this.mResourceManager.getNodeReadTrxByRevisionNumber(this.mResourceManager.getMostRecentRevisionNumber());
            NodeReadOnlyTrx rtx = optionalRtx.isPresent() ? (NodeReadOnlyTrx)optionalRtx.get() : this.mResourceManager.beginNodeReadOnlyTrx(this.mResourceManager.getMostRecentRevisionNumber());
            if (rtx.moveTo(this.mNodeKey).hasMoved()) {
                return (R)rtx;
            }
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceManager<R, W> getResourceManager() {
        return this.mResourceManager;
    }
}

