/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.temporal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.axis.AbstractTemporalAxis;
import org.sirix.axis.IncludeSelf;

public final class FutureAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private int mRevision;
    private final ResourceManager<R, W> mResourceManager;
    private long mNodeKey;

    public FutureAxis(ResourceManager<R, W> resourceManager, R rtx) {
        this(resourceManager, rtx, IncludeSelf.NO);
    }

    public FutureAxis(ResourceManager<R, W> resourceManager, R rtx, IncludeSelf includeSelf) {
        this.mResourceManager = (ResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mNodeKey = rtx.getNodeKey();
        this.mRevision = Preconditions.checkNotNull((Object)((Object)includeSelf)) == IncludeSelf.YES ? rtx.getRevisionNumber() : rtx.getRevisionNumber() + 1;
    }

    protected R computeNext() {
        if (this.mRevision <= this.mResourceManager.getMostRecentRevisionNumber()) {
            Optional<R> optionalRtx = this.mResourceManager.getNodeReadTrxByRevisionNumber(this.mRevision);
            NodeReadOnlyTrx rtx = optionalRtx.isPresent() ? (NodeReadOnlyTrx)optionalRtx.get() : this.mResourceManager.beginNodeReadOnlyTrx(this.mRevision);
            ++this.mRevision;
            if (rtx.moveTo(this.mNodeKey).hasMoved()) {
                return (R)rtx;
            }
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceManager<R, W> getResourceManager() {
        return this.mResourceManager;
    }
}

