/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.filter.xml;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sirix.api.Filter;
import org.sirix.api.ResourceManager;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.axis.AbstractTemporalAxis;

public final class TemporalXmlNodeReadFilterAxis<F extends Filter<XmlNodeReadOnlyTrx>>
extends AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    private final AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> mAxis;
    private final List<F> mAxisFilter;

    @SafeVarargs
    public TemporalXmlNodeReadFilterAxis(AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> axis, F firstAxisTest, F ... axisTest) {
        Preconditions.checkNotNull(firstAxisTest);
        this.mAxis = axis;
        this.mAxisFilter = new ArrayList<F>();
        this.mAxisFilter.add(firstAxisTest);
        if (axisTest != null) {
            int length = axisTest.length;
            for (int i = 0; i < length; ++i) {
                this.mAxisFilter.add(axisTest[i]);
            }
        }
    }

    protected XmlNodeReadOnlyTrx computeNext() {
        while (this.mAxis.hasNext()) {
            XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.mAxis.next();
            boolean filterResult = this.doFilter(rtx);
            if (filterResult) {
                return rtx;
            }
            rtx.close();
        }
        return (XmlNodeReadOnlyTrx)this.endOfData();
    }

    private boolean doFilter(XmlNodeReadOnlyTrx rtx) {
        boolean filterResult = true;
        for (Filter filter : this.mAxisFilter) {
            filter.setTrx(rtx);
            if (filterResult = filterResult && filter.filter()) continue;
            break;
        }
        return filterResult;
    }

    public AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> getAxis() {
        return this.mAxis;
    }

    @Override
    public ResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx> getResourceManager() {
        return this.mAxis.getResourceManager();
    }
}

