/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.concurrent;

import org.sirix.api.Axis;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.concurrent.ConcurrentAxis;
import org.sirix.axis.concurrent.Util;
import org.sirix.exception.SirixXPathException;
import org.sirix.service.xml.xpath.EXPathError;

public final class ConcurrentUnionAxis<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractAxis {
    private final ConcurrentAxis<R> mOp1;
    private final ConcurrentAxis<R> mOp2;
    private boolean mFirst;
    private long mCurrentResult1;
    private long mCurrentResult2;

    public ConcurrentUnionAxis(R rtx, Axis operand1, Axis operand2) {
        super((NodeCursor)rtx);
        this.mOp1 = new ConcurrentAxis<R>(rtx, operand1);
        this.mOp2 = new ConcurrentAxis<R>(rtx, operand2);
        this.mFirst = true;
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mOp1 != null) {
            this.mOp1.reset(nodeKey);
        }
        if (this.mOp2 != null) {
            this.mOp2.reset(nodeKey);
        }
        this.mFirst = true;
    }

    @Override
    protected long nextKey() {
        if (this.mFirst) {
            this.mFirst = false;
            this.mCurrentResult1 = Util.getNext(this.mOp1);
            this.mCurrentResult2 = Util.getNext(this.mOp2);
        }
        if (!this.mOp1.isFinished()) {
            if (!this.mOp2.isFinished()) {
                long nodeKey;
                if (this.mCurrentResult1 < this.mCurrentResult2) {
                    nodeKey = this.mCurrentResult1;
                    this.mCurrentResult1 = Util.getNext(this.mOp1);
                } else if (this.mCurrentResult1 > this.mCurrentResult2) {
                    nodeKey = this.mCurrentResult2;
                    this.mCurrentResult2 = Util.getNext(this.mOp2);
                } else {
                    nodeKey = this.mCurrentResult2;
                    this.mCurrentResult1 = Util.getNext(this.mOp1);
                    this.mCurrentResult2 = Util.getNext(this.mOp2);
                }
                if (nodeKey < 0L) {
                    try {
                        throw EXPathError.XPTY0004.getEncapsulatedException();
                    }
                    catch (SirixXPathException mExp) {
                        mExp.printStackTrace();
                    }
                }
                return nodeKey;
            }
            long nodeKey = this.mCurrentResult1;
            if (Util.isValid(nodeKey)) {
                this.mCurrentResult1 = Util.getNext(this.mOp1);
                return nodeKey;
            }
            throw new IllegalStateException(nodeKey + " is not valid!");
        }
        if (!this.mOp2.isFinished()) {
            long nodeKey = this.mCurrentResult2;
            if (Util.isValid(nodeKey)) {
                this.mCurrentResult2 = Util.getNext(this.mOp2);
                return nodeKey;
            }
            throw new IllegalStateException(nodeKey + " is not valid!");
        }
        return this.done();
    }
}

