/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.concurrent;

import org.sirix.api.Axis;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.concurrent.ConcurrentAxis;
import org.sirix.axis.concurrent.Util;
import org.sirix.settings.Fixed;

public final class ConcurrentIntersectAxis<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractAxis {
    private final ConcurrentAxis<R> mOp1;
    private final ConcurrentAxis<R> mOp2;
    private boolean mFirst;
    private long mCurrentResult1;
    private long mCurrentResult2;

    public ConcurrentIntersectAxis(R rtx, Axis operand1, Axis operand2) {
        super((NodeCursor)rtx);
        this.mOp1 = new ConcurrentAxis<R>(rtx, operand1);
        this.mOp2 = new ConcurrentAxis<R>(rtx, operand2);
        this.mFirst = true;
        this.mCurrentResult1 = Fixed.NULL_NODE_KEY.getStandardProperty();
        this.mCurrentResult2 = Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public synchronized void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mOp1 != null) {
            this.mOp1.reset(nodeKey);
        }
        if (this.mOp2 != null) {
            this.mOp2.reset(nodeKey);
        }
        this.mFirst = true;
        this.mCurrentResult1 = Fixed.NULL_NODE_KEY.getStandardProperty();
        this.mCurrentResult2 = Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    protected long nextKey() {
        if (this.mFirst) {
            this.mFirst = false;
            this.mCurrentResult1 = Util.getNext(this.mOp1);
            this.mCurrentResult2 = Util.getNext(this.mOp2);
        }
        if (!this.mOp1.isFinished() && !this.mOp2.isFinished()) {
            while (this.mCurrentResult1 != this.mCurrentResult2 && !this.mOp1.isFinished() && !this.mOp2.isFinished()) {
                while (this.mCurrentResult1 < this.mCurrentResult2 && !this.mOp1.isFinished() && !this.mOp2.isFinished()) {
                    this.mCurrentResult1 = Util.getNext(this.mOp1);
                }
                while (this.mCurrentResult1 > this.mCurrentResult2 && !this.mOp1.isFinished() && !this.mOp2.isFinished()) {
                    this.mCurrentResult2 = Util.getNext(this.mOp2);
                }
            }
            if (!this.mOp1.isFinished() && !this.mOp2.isFinished()) {
                assert (this.mCurrentResult1 == this.mCurrentResult2);
                long nodeKey = this.mCurrentResult1;
                if (Util.isValid(nodeKey)) {
                    this.mCurrentResult1 = Util.getNext(this.mOp1);
                    this.mCurrentResult2 = Util.getNext(this.mOp2);
                    return nodeKey;
                }
                throw new IllegalStateException(nodeKey + " is not valid!");
            }
        }
        return this.done();
    }
}

