/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import org.sirix.api.NodeCursor;
import org.sirix.axis.AbstractAxis;
import org.sirix.node.Kind;
import org.sirix.settings.Fixed;

public final class PrecedingSiblingAxis
extends AbstractAxis {
    private boolean mIsFirst;

    public PrecedingSiblingAxis(NodeCursor cursor) {
        super(cursor);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mIsFirst = true;
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.mIsFirst) {
            this.mIsFirst = false;
            Kind kind = cursor.getKind();
            if (kind == Kind.ATTRIBUTE || kind == Kind.NAMESPACE) {
                return this.done();
            }
            if (cursor.hasParent()) {
                long startNodeKey = cursor.getNodeKey();
                cursor.moveToParent();
                cursor.moveToFirstChild();
                if (cursor.getNodeKey() == startNodeKey) {
                    return Fixed.NULL_NODE_KEY.getStandardProperty();
                }
                long key = cursor.getNodeKey();
                cursor.moveTo(startNodeKey);
                return key;
            }
        }
        if (cursor.hasRightSibling() && cursor.getRightSiblingKey() != this.getStartKey()) {
            return cursor.getRightSiblingKey();
        }
        return this.done();
    }
}

