/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import com.google.common.base.Preconditions;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.settings.Fixed;

public final class NonStructuralWrapperAxis
extends AbstractAxis {
    private final Axis mParentAxis;
    private int mNspIndex;
    private int mAttIndex;
    private boolean mFirst;

    public NonStructuralWrapperAxis(Axis parentAxis) {
        super(parentAxis.asXdmNodeReadTrx());
        this.mParentAxis = (Axis)Preconditions.checkNotNull((Object)parentAxis);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mParentAxis != null) {
            this.mParentAxis.reset(nodeKey);
        }
        this.mNspIndex = 0;
        this.mAttIndex = 0;
        this.mFirst = true;
    }

    @Override
    protected long nextKey() {
        long nodeKey;
        XmlNodeReadOnlyTrx trx = this.mParentAxis.asXdmNodeReadTrx();
        if (!(this.mParentAxis.isSelfIncluded() != IncludeSelf.NO && this.mFirst || (nodeKey = this.nonStructural(trx)) == Fixed.NULL_NODE_KEY.getStandardProperty())) {
            return nodeKey;
        }
        if (this.mParentAxis.hasNext()) {
            long key = (Long)this.mParentAxis.next();
            this.mFirst = false;
            this.mNspIndex = 0;
            this.mAttIndex = 0;
            return key;
        }
        return this.done();
    }

    private long nonStructural(XmlNodeReadOnlyTrx trx) {
        if (trx.isNamespace()) {
            trx.moveToParent();
        }
        if (trx.isElement() && this.mNspIndex < trx.getNamespaceCount()) {
            trx.moveToNamespace(this.mNspIndex++);
            return trx.getNodeKey();
        }
        if (trx.isAttribute()) {
            trx.moveToParent();
        }
        if (trx.isElement() && this.mAttIndex < trx.getAttributeCount()) {
            trx.moveToAttribute(this.mAttIndex++);
            return trx.getNodeKey();
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }
}

