/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import com.google.common.base.Preconditions;
import org.sirix.api.Axis;
import org.sirix.axis.AbstractAxis;

public final class NestedAxis
extends AbstractAxis {
    private final Axis mParentAxis;
    private final Axis mChildAxis;
    private boolean mIsFirst;

    public NestedAxis(Axis parentAxis, Axis childAxis) {
        super(parentAxis.getCursor());
        this.mParentAxis = (Axis)Preconditions.checkNotNull((Object)parentAxis);
        this.mChildAxis = (Axis)Preconditions.checkNotNull((Object)childAxis);
        this.mIsFirst = true;
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mParentAxis != null) {
            this.mParentAxis.reset(nodeKey);
        }
        if (this.mChildAxis != null) {
            this.mChildAxis.reset(nodeKey);
        }
        this.mIsFirst = true;
    }

    @Override
    protected long nextKey() {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (this.mParentAxis.hasNext()) {
                this.mChildAxis.reset((Long)this.mParentAxis.next());
            } else {
                return this.done();
            }
        }
        boolean hasNext = false;
        while (!(hasNext = this.mChildAxis.hasNext()) && this.mParentAxis.hasNext()) {
            this.mChildAxis.reset((Long)this.mParentAxis.next());
        }
        if (hasNext) {
            return (Long)this.mChildAxis.next();
        }
        return this.done();
    }
}

