/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sirix.api.NodeCursor;
import org.sirix.axis.AbstractAxis;

public final class FollowingAxis
extends AbstractAxis {
    private boolean mIsFirst = true;
    private Deque<Long> mRightSiblingStack = new ArrayDeque<Long>();

    public FollowingAxis(NodeCursor cursor) {
        super(cursor);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mIsFirst = true;
        this.mRightSiblingStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        if (this.mIsFirst) {
            switch (this.getCursor().getKind()) {
                case ATTRIBUTE: 
                case NAMESPACE: {
                    return this.done();
                }
            }
        }
        NodeCursor cursor = this.getCursor();
        long currKey = cursor.getNodeKey();
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (cursor.hasRightSibling()) {
                cursor.moveToRightSibling();
                long key = cursor.getNodeKey();
                if (cursor.hasRightSibling()) {
                    this.mRightSiblingStack.push(cursor.getRightSiblingKey());
                }
                cursor.moveTo(currKey);
                return key;
            }
            while (cursor.hasParent()) {
                cursor.moveToParent();
                if (!cursor.hasRightSibling()) continue;
                cursor.moveToRightSibling();
                long key = cursor.getNodeKey();
                if (cursor.hasRightSibling()) {
                    this.mRightSiblingStack.push(cursor.getRightSiblingKey());
                }
                cursor.moveTo(currKey);
                return key;
            }
            return this.done();
        }
        if (cursor.hasFirstChild()) {
            cursor.moveToFirstChild();
            long key = cursor.getNodeKey();
            if (cursor.hasRightSibling()) {
                this.mRightSiblingStack.push(cursor.getRightSiblingKey());
            }
            cursor.moveTo(currKey);
            return key;
        }
        if (this.mRightSiblingStack.isEmpty()) {
            while (cursor.hasParent()) {
                cursor.moveToParent();
                if (!cursor.hasRightSibling()) continue;
                cursor.moveToRightSibling();
                long key = cursor.getNodeKey();
                if (cursor.hasRightSibling()) {
                    this.mRightSiblingStack.push(cursor.getRightSiblingKey());
                }
                cursor.moveTo(currKey);
                return key;
            }
        } else {
            cursor.moveTo(this.mRightSiblingStack.pop());
            long key = cursor.getNodeKey();
            if (cursor.hasRightSibling()) {
                this.mRightSiblingStack.push(cursor.getRightSiblingKey());
            }
            cursor.moveTo(currKey);
            return key;
        }
        return this.done();
    }
}

