/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import org.sirix.api.Axis;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.IncludeSelf;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.settings.Fixed;

public abstract class AbstractAxis
implements Axis {
    protected final NodeCursor mNodeCursor;
    private long mKey;
    private long mStartKey;
    private final IncludeSelf mIncludeSelf;
    private State mState = State.NOT_READY;

    public AbstractAxis(NodeCursor nodeCursor) {
        this.mNodeCursor = (NodeCursor)Preconditions.checkNotNull((Object)nodeCursor);
        this.mIncludeSelf = IncludeSelf.NO;
        this.reset(nodeCursor.getNodeKey());
    }

    public AbstractAxis(NodeCursor nodeCursor, IncludeSelf includeSelf) {
        this.mNodeCursor = (NodeCursor)Preconditions.checkNotNull((Object)nodeCursor);
        this.mIncludeSelf = (IncludeSelf)((Object)Preconditions.checkNotNull((Object)((Object)includeSelf)));
        this.reset(nodeCursor.getNodeKey());
    }

    @Override
    public final Iterator<Long> iterator() {
        return this;
    }

    protected long done() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public final boolean hasNext() {
        Preconditions.checkState((this.mState != State.FAILED ? 1 : 0) != 0);
        switch (this.mState) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        this.resetToLastKey();
        boolean hasNext = this.tryToComputeNext();
        if (hasNext) {
            return true;
        }
        this.resetToStartKey();
        return false;
    }

    private boolean tryToComputeNext() {
        this.mState = State.FAILED;
        this.mKey = this.nextKey();
        if (this.mKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            this.mState = State.DONE;
        }
        if (this.mState == State.DONE) {
            return false;
        }
        this.mState = State.READY;
        return true;
    }

    protected abstract long nextKey();

    public final Long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.mState = State.NOT_READY;
        if (this.mKey >= 0L) {
            if (!this.mNodeCursor.moveTo(this.mKey).hasMoved()) {
                throw new IllegalStateException("Failed to move to nodeKey: " + this.mKey);
            }
        } else {
            this.mNodeCursor.moveTo(this.mKey);
        }
        return this.mKey;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset(@Nonnegative long nodeKey) {
        this.mStartKey = nodeKey;
        this.mKey = nodeKey;
        this.mState = State.NOT_READY;
    }

    @Override
    public XmlNodeReadOnlyTrx asXdmNodeReadTrx() {
        if (this.mNodeCursor instanceof XmlNodeReadOnlyTrx) {
            return (XmlNodeReadOnlyTrx)this.mNodeCursor;
        }
        throw new ClassCastException("Node cursor is no XDM node transaction.");
    }

    @Override
    public JsonNodeReadOnlyTrx asJsonNodeReadTrx() {
        if (this.mNodeCursor instanceof JsonNodeReadOnlyTrx) {
            return (JsonNodeReadOnlyTrx)this.mNodeCursor;
        }
        throw new ClassCastException("Node cursor is no JSON node transaction.");
    }

    @Override
    public PathSummaryReader asPathSummary() {
        if (this.mNodeCursor instanceof PathSummaryReader) {
            return (PathSummaryReader)this.mNodeCursor;
        }
        throw new ClassCastException("Node cursor is no path summary reader.");
    }

    @Override
    public NodeCursor getCursor() {
        return this.mNodeCursor;
    }

    @Override
    public NodeReadOnlyTrx getTrx() {
        if (this.mNodeCursor instanceof NodeReadOnlyTrx) {
            return (NodeReadOnlyTrx)((Object)this.mNodeCursor);
        }
        throw new ClassCastException("Node cursor is no transactional cursor.");
    }

    private final long resetToStartKey() {
        this.mNodeCursor.moveTo(this.mStartKey);
        return this.mStartKey;
    }

    private final long resetToLastKey() {
        this.mNodeCursor.moveTo(this.mKey);
        return this.mKey;
    }

    public final Long peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mKey;
    }

    @Override
    public final long getStartKey() {
        return this.mStartKey;
    }

    @Override
    public final IncludeSelf isSelfIncluded() {
        return this.mIncludeSelf;
    }

    @Override
    public final void foreach(XmlNodeVisitor visitor) {
        Preconditions.checkNotNull((Object)visitor);
        if (this.mNodeCursor instanceof XmlNodeReadOnlyTrx) {
            while (this.hasNext()) {
                this.next();
                ((XmlNodeReadOnlyTrx)this.mNodeCursor).acceptVisitor(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized long nextNode() {
        NodeCursor nodeCursor = this.mNodeCursor;
        synchronized (nodeCursor) {
            long retVal = Fixed.NULL_NODE_KEY.getStandardProperty();
            if (this.hasNext()) {
                retVal = this.next();
            }
            return retVal;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("trx", (Object)this.mNodeCursor).toString();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

