/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.api;

import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.IndexController;
import org.sirix.api.Database;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;

public interface ResourceManager<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AutoCloseable {
    public Database<?> getDatabase();

    public Path getResourcePath();

    public Optional<W> getNodeWriteTrx();

    public PageReadOnlyTrx beginPageReadTrx();

    public PageReadOnlyTrx beginPageReadOnlyTrx(@Nonnegative int var1);

    public PageTrx<Long, Record, UnorderedKeyValuePage> beginPageTrx();

    public PageTrx<Long, Record, UnorderedKeyValuePage> beginPageTrx(@Nonnegative int var1);

    public R beginNodeReadOnlyTrx();

    public R beginNodeReadOnlyTrx(@Nonnegative int var1);

    public R beginNodeReadOnlyTrx(@Nonnull Instant var1);

    public W beginNodeTrx();

    public W beginNodeTrx(@Nonnegative int var1);

    public W beginNodeTrx(TimeUnit var1, int var2);

    public W beginNodeTrx(@Nonnegative int var1, TimeUnit var2, int var3);

    public PathSummaryReader openPathSummary(@Nonnegative int var1);

    public PathSummaryReader openPathSummary();

    public int getRevisionNumber(@Nonnull Instant var1);

    @Override
    public void close();

    public boolean isClosed();

    public ResourceConfiguration getResourceConfig();

    public int getMostRecentRevisionNumber();

    public int getAvailableNodeReadTrx();

    public <C extends IndexController<R, W>> C getRtxIndexController(int var1);

    public <C extends IndexController<R, W>> C getWtxIndexController(int var1);

    public Optional<R> getNodeReadTrxByTrxId(long var1);

    public boolean hasRunningNodeWriteTrx();

    public Optional<R> getNodeReadTrxByRevisionNumber(int var1);
}

