/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.xml;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.AbstractResourceManager;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.access.trx.node.xml.XmlNodeFactoryImpl;
import org.sirix.access.trx.node.xml.XmlNodeReadOnlyTrxImpl;
import org.sirix.access.trx.node.xml.XmlNodeTrxImpl;
import org.sirix.access.xml.XmlResourceStore;
import org.sirix.api.Database;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.cache.BufferManager;
import org.sirix.index.path.summary.PathSummaryWriter;
import org.sirix.io.Storage;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;

public final class XmlResourceManagerImpl
extends AbstractResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx>
implements XmlResourceManager,
InternalResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    private final ConcurrentMap<Integer, XmlIndexController> mRtxIndexControllers = new ConcurrentHashMap<Integer, XmlIndexController>();
    private final ConcurrentMap<Integer, XmlIndexController> mWtxIndexControllers = new ConcurrentHashMap<Integer, XmlIndexController>();

    public XmlResourceManagerImpl(Database<XmlResourceManager> database, @Nonnull XmlResourceStore resourceStore, @Nonnull ResourceConfiguration resourceConf, @Nonnull BufferManager bufferManager, @Nonnull Storage storage, @Nonnull UberPage uberPage, @Nonnull Semaphore readSemaphore, @Nonnull Lock writeLock) {
        super(database, resourceStore, resourceConf, bufferManager, storage, uberPage, readSemaphore, writeLock);
    }

    @Override
    public XmlNodeReadOnlyTrx createNodeReadOnlyTrx(long nodeTrxId, PageReadOnlyTrx pageReadTrx, Node documentNode) {
        return new XmlNodeReadOnlyTrxImpl(this, nodeTrxId, pageReadTrx, (ImmutableXmlNode)((Object)documentNode));
    }

    @Override
    public XmlNodeTrx createNodeReadWriteTrx(long nodeTrxId, PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, int maxNodeCount, TimeUnit timeUnit, int maxTime, Node documentNode) {
        XmlNodeReadOnlyTrxImpl nodeReadTrx = new XmlNodeReadOnlyTrxImpl(this, nodeTrxId, pageWriteTrx, (ImmutableXmlNode)((Object)documentNode));
        XmlNodeFactoryImpl nodeFactory = new XmlNodeFactoryImpl(pageWriteTrx);
        boolean buildPathSummary = this.getResourceConfig().withPathSummary;
        PathSummaryWriter<XmlNodeReadOnlyTrx> pathSummaryWriter = buildPathSummary ? new PathSummaryWriter<XmlNodeReadOnlyTrx>(pageWriteTrx, this, nodeFactory, nodeReadTrx) : null;
        return new XmlNodeTrxImpl(nodeTrxId, this, nodeReadTrx, pathSummaryWriter, maxNodeCount, timeUnit, maxTime, documentNode, nodeFactory);
    }

    @Override
    public synchronized XmlIndexController getRtxIndexController(int revision) {
        XmlIndexController controller = (XmlIndexController)this.mRtxIndexControllers.get(revision);
        if (controller == null) {
            controller = new XmlIndexController();
            this.mRtxIndexControllers.put(revision, controller);
        }
        return controller;
    }

    @Override
    public synchronized XmlIndexController getWtxIndexController(int revision) {
        XmlIndexController controller = (XmlIndexController)this.mWtxIndexControllers.get(revision);
        if (controller == null) {
            controller = new XmlIndexController();
            this.mWtxIndexControllers.put(revision, controller);
        }
        return controller;
    }
}

