/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.AbstractNodeReadTrx;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.node.Move;
import org.sirix.access.trx.node.xml.InternalXmlNodeReadTrx;
import org.sirix.api.ItemList;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.exception.SirixIOException;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.immutable.xdm.ImmutableAttributeNode;
import org.sirix.node.immutable.xdm.ImmutableComment;
import org.sirix.node.immutable.xdm.ImmutableDocumentNode;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.immutable.xdm.ImmutableNamespace;
import org.sirix.node.immutable.xdm.ImmutablePI;
import org.sirix.node.immutable.xdm.ImmutableText;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableNameNode;
import org.sirix.node.interfaces.immutable.ImmutableValueNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.node.xdm.AttributeNode;
import org.sirix.node.xdm.CommentNode;
import org.sirix.node.xdm.ElementNode;
import org.sirix.node.xdm.NamespaceNode;
import org.sirix.node.xdm.PINode;
import org.sirix.node.xdm.TextNode;
import org.sirix.node.xdm.XdmDocumentRootNode;
import org.sirix.page.PageKind;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.ItemListImpl;
import org.sirix.settings.Constants;
import org.sirix.utils.NamePageHash;

public final class XmlNodeReadOnlyTrxImpl
extends AbstractNodeReadTrx<XmlNodeReadOnlyTrx>
implements InternalXmlNodeReadTrx {
    protected final InternalResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx> mResourceManager;
    private boolean mClosed;
    private final ItemList<AtomicValue> mItemList;
    private final long mTrxId;

    XmlNodeReadOnlyTrxImpl(InternalResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx> resourceManager, @Nonnegative long trxId, PageReadOnlyTrx pageReadTransaction, ImmutableXmlNode documentNode) {
        super(trxId, pageReadTransaction, documentNode);
        this.mResourceManager = (InternalResourceManager)Preconditions.checkNotNull(resourceManager);
        Preconditions.checkArgument((trxId >= 0L ? 1 : 0) != 0);
        this.mTrxId = trxId;
        this.mClosed = false;
        this.mItemList = new ItemListImpl();
    }

    @Override
    public void setCurrentNode(@Nullable ImmutableXmlNode currentNode) {
        this.assertNotClosed();
        this.mCurrentNode = currentNode;
    }

    @Override
    public Move<XmlNodeReadOnlyTrx> moveTo(long nodeKey) {
        Optional<Object> newNode;
        this.assertNotClosed();
        ImmutableXmlNode oldNode = (ImmutableXmlNode)this.mCurrentNode;
        try {
            if (nodeKey < 0L) {
                newNode = this.mItemList.size() > 0 ? this.mItemList.getItem(nodeKey) : Optional.empty();
            } else {
                Optional<? extends Record> node = this.getPageTransaction().getRecord(nodeKey, PageKind.RECORDPAGE, -1);
                newNode = node;
            }
        }
        catch (SirixIOException e) {
            newNode = Optional.empty();
        }
        if (newNode.isPresent()) {
            this.mCurrentNode = (ImmutableXmlNode)newNode.get();
            return Move.moved(this);
        }
        this.mCurrentNode = oldNode;
        return Move.notMoved();
    }

    @Override
    public ImmutableXmlNode getNode() {
        switch (this.mCurrentNode.getKind()) {
            case ELEMENT: {
                return ImmutableElement.of((ElementNode)this.mCurrentNode);
            }
            case TEXT: {
                return ImmutableText.of((TextNode)this.mCurrentNode);
            }
            case COMMENT: {
                return ImmutableComment.of((CommentNode)this.mCurrentNode);
            }
            case PROCESSING_INSTRUCTION: {
                return ImmutablePI.of((PINode)this.mCurrentNode);
            }
            case ATTRIBUTE: {
                return ImmutableAttributeNode.of((AttributeNode)this.mCurrentNode);
            }
            case NAMESPACE: {
                return ImmutableNamespace.of((NamespaceNode)this.mCurrentNode);
            }
            case XDM_DOCUMENT: {
                return ImmutableDocumentNode.of((XdmDocumentRootNode)this.mCurrentNode);
            }
        }
        throw new IllegalStateException("Node kind not known!");
    }

    @Override
    public ImmutableNameNode getNameNode() {
        this.assertNotClosed();
        return (ImmutableNameNode)this.mCurrentNode;
    }

    @Override
    public ImmutableValueNode getValueNode() {
        this.assertNotClosed();
        return (ImmutableValueNode)((Object)this.mCurrentNode);
    }

    @Override
    public Move<? extends XmlNodeReadOnlyTrx> moveToAttribute(int index) {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            ElementNode element = (ElementNode)this.mCurrentNode;
            if (element.getAttributeCount() > index) {
                Move<XmlNodeReadOnlyTrx> moved = this.moveTo(element.getAttributeKey(index));
                return moved;
            }
            return Move.notMoved();
        }
        return Move.notMoved();
    }

    @Override
    public Move<? extends XmlNodeReadOnlyTrx> moveToNamespace(int index) {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            ElementNode element = (ElementNode)this.mCurrentNode;
            if (element.getNamespaceCount() > index) {
                Move<XmlNodeReadOnlyTrx> moved = this.moveTo(element.getNamespaceKey(index));
                return moved;
            }
            return Move.notMoved();
        }
        return Move.notMoved();
    }

    @Override
    public QNm getName() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            String uri = this.mPageReadTrx.getName(((NameNode)this.mCurrentNode).getURIKey(), Kind.NAMESPACE);
            int prefixKey = ((NameNode)this.mCurrentNode).getPrefixKey();
            String prefix = prefixKey == -1 ? "" : this.mPageReadTrx.getName(prefixKey, this.mCurrentNode.getKind());
            int localNameKey = ((NameNode)this.mCurrentNode).getLocalNameKey();
            String localName = localNameKey == -1 ? "" : this.mPageReadTrx.getName(localNameKey, this.mCurrentNode.getKind());
            return new QNm(uri, prefix, localName);
        }
        return null;
    }

    @Override
    public String getType() {
        this.assertNotClosed();
        return this.mPageReadTrx.getName(((ImmutableXmlNode)this.mCurrentNode).getTypeKey(), this.mCurrentNode.getKind());
    }

    @Override
    public byte[] rawNameForKey(int key) {
        this.assertNotClosed();
        return this.mPageReadTrx.getRawName(key, this.mCurrentNode.getKind());
    }

    @Override
    public ItemList<AtomicValue> getItemList() {
        this.assertNotClosed();
        return this.mItemList;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("Revision number", this.getRevisionNumber());
        if (this.mCurrentNode.getKind() == Kind.ATTRIBUTE || this.mCurrentNode.getKind() == Kind.ELEMENT) {
            helper.add("Name of Node", (Object)this.getName().toString());
        }
        if (this.mCurrentNode.getKind() == Kind.ATTRIBUTE || this.mCurrentNode.getKind() == Kind.TEXT) {
            helper.add("Value of Node", (Object)this.getValue());
        }
        if (this.mCurrentNode.getKind() == Kind.XDM_DOCUMENT) {
            helper.addValue((Object)"Node is DocumentRoot");
        }
        helper.add("node", (Object)this.mCurrentNode.toString());
        return helper.toString();
    }

    @Override
    public Move<? extends XmlNodeReadOnlyTrx> moveToAttributeByName(QNm name) {
        ElementNode element;
        Optional<Long> attrKey;
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT && (attrKey = (element = (ElementNode)this.mCurrentNode).getAttributeKeyByName(name)).isPresent()) {
            Move<XmlNodeReadOnlyTrx> moved = this.moveTo(attrKey.get());
            return moved;
        }
        return Move.notMoved();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XmlNodeReadOnlyTrxImpl) {
            XmlNodeReadOnlyTrxImpl rtx = (XmlNodeReadOnlyTrxImpl)obj;
            return this.mCurrentNode.getNodeKey() == rtx.mCurrentNode.getNodeKey() && this.mPageReadTrx.getRevisionNumber() == rtx.mPageReadTrx.getRevisionNumber();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mCurrentNode.getNodeKey(), this.mPageReadTrx.getRevisionNumber()});
    }

    @Override
    protected XmlNodeReadOnlyTrx thisInstance() {
        return this;
    }

    @Override
    public int getAttributeCount() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            ElementNode node = (ElementNode)this.mCurrentNode;
            return node.getAttributeCount();
        }
        return 0;
    }

    @Override
    public int getNamespaceCount() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            ElementNode node = (ElementNode)this.mCurrentNode;
            return node.getNamespaceCount();
        }
        return 0;
    }

    @Override
    public boolean isNameNode() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof NameNode;
    }

    @Override
    public int getPrefixKey() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            return ((NameNode)this.mCurrentNode).getPrefixKey();
        }
        return -1;
    }

    @Override
    public int getLocalNameKey() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            return ((NameNode)this.mCurrentNode).getLocalNameKey();
        }
        return -1;
    }

    @Override
    public int getTypeKey() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.mCurrentNode).getTypeKey();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.mCurrentNode).acceptVisitor(visitor);
    }

    @Override
    public long getAttributeKey(@Nonnegative int index) {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            return ((ElementNode)this.mCurrentNode).getAttributeKey(index);
        }
        return -1L;
    }

    @Override
    public boolean isStructuralNode() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof StructNode;
    }

    @Override
    public int getURIKey() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            return ((NameNode)this.mCurrentNode).getURIKey();
        }
        return -1;
    }

    @Override
    public List<Long> getAttributeKeys() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            return ((ElementNode)this.mCurrentNode).getAttributeKeys();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getNamespaceKeys() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.ELEMENT) {
            return ((ElementNode)this.mCurrentNode).getNamespaceKeys();
        }
        return Collections.emptyList();
    }

    @Override
    public String getNamespaceURI() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            String URI2 = this.mPageReadTrx.getName(((NameNode)this.mCurrentNode).getURIKey(), Kind.NAMESPACE);
            return URI2;
        }
        return null;
    }

    @Override
    public boolean isElement() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.ELEMENT;
    }

    @Override
    public boolean isText() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.TEXT;
    }

    @Override
    public boolean isDocumentRoot() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.XDM_DOCUMENT;
    }

    @Override
    public boolean isComment() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.COMMENT;
    }

    @Override
    public boolean isAttribute() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.ATTRIBUTE;
    }

    @Override
    public boolean isNamespace() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.NAMESPACE;
    }

    @Override
    public boolean isPI() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.PROCESSING_INSTRUCTION;
    }

    @Override
    public boolean hasAttributes() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.ELEMENT && ((ElementNode)this.mCurrentNode).getAttributeCount() > 0;
    }

    @Override
    public boolean hasNamespaces() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.ELEMENT && ((ElementNode)this.mCurrentNode).getNamespaceCount() > 0;
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.mCurrentNode).getDeweyID();
    }

    @Override
    public Optional<SirixDeweyID> getLeftSiblingDeweyID() {
        this.assertNotClosed();
        if (this.mResourceManager.getResourceConfig().areDeweyIDsStored) {
            StructNode node = this.getStructuralNode();
            long nodeKey = node.getNodeKey();
            Optional<SirixDeweyID> deweyID = Optional.empty();
            if (node.hasLeftSibling()) {
                deweyID = this.moveTo(node.getLeftSiblingKey()).trx().getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return Optional.empty();
    }

    @Override
    public Optional<SirixDeweyID> getRightSiblingDeweyID() {
        if (this.mResourceManager.getResourceConfig().areDeweyIDsStored) {
            StructNode node = this.getStructuralNode();
            long nodeKey = node.getNodeKey();
            Optional<SirixDeweyID> deweyID = Optional.empty();
            if (node.hasRightSibling()) {
                deweyID = this.moveTo(node.getRightSiblingKey()).trx().getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return Optional.empty();
    }

    @Override
    public Optional<SirixDeweyID> getParentDeweyID() {
        if (this.mResourceManager.getResourceConfig().areDeweyIDsStored) {
            long nodeKey = this.mCurrentNode.getNodeKey();
            Optional<SirixDeweyID> deweyID = Optional.empty();
            if (this.mCurrentNode.hasParent()) {
                deweyID = this.moveTo(this.mCurrentNode.getParentKey()).trx().getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return Optional.empty();
    }

    @Override
    public Optional<SirixDeweyID> getFirstChildDeweyID() {
        if (this.mResourceManager.getResourceConfig().areDeweyIDsStored) {
            StructNode node = this.getStructuralNode();
            long nodeKey = node.getNodeKey();
            Optional<SirixDeweyID> deweyID = Optional.empty();
            if (node.hasFirstChild()) {
                deweyID = this.moveTo(node.getFirstChildKey()).trx().getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        if (!this.mClosed) {
            this.mPageReadTrx.close();
            this.setPageReadTransaction(null);
            this.mResourceManager.closeReadTransaction(this.mTrxId);
            this.mPageReadTrx = null;
            this.mCurrentNode = null;
            this.mClosed = true;
        }
    }

    @Override
    public String getValue() {
        this.assertNotClosed();
        String returnVal = this.mCurrentNode instanceof ValueNode ? new String(((ValueNode)this.mCurrentNode).getRawValue(), Constants.DEFAULT_ENCODING) : (this.mCurrentNode.getKind() == Kind.NAMESPACE ? this.mPageReadTrx.getName(((NamespaceNode)this.mCurrentNode).getURIKey(), Kind.NAMESPACE) : "");
        return returnVal;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public int getNameCount(String name, Kind kind) {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            return this.mPageReadTrx.getNameCount(NamePageHash.generateHashForString(name), kind);
        }
        return 0;
    }

    @Override
    public boolean isValueNode() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof ValueNode;
    }

    @Override
    public long getHash() {
        this.assertNotClosed();
        return this.mCurrentNode.getHash();
    }

    @Override
    public byte[] getRawValue() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof ValueNode) {
            return ((ValueNode)this.mCurrentNode).getRawValue();
        }
        return null;
    }

    @Override
    public XmlResourceManager getResourceManager() {
        this.assertNotClosed();
        return (XmlResourceManager)((Object)this.mResourceManager);
    }

    @Override
    public void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Transaction is already closed.");
        }
    }

    @Override
    public ImmutableXmlNode getCurrentNode() {
        return (ImmutableXmlNode)this.mCurrentNode;
    }
}

