/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.json;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.access.trx.node.HashType;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.node.json.AbstractForwardingJsonNodeReadOnlyTrx;
import org.sirix.access.trx.node.json.InternalJsonNodeReadOnlyTrx;
import org.sirix.access.trx.node.json.JsonIndexController;
import org.sirix.access.trx.node.json.JsonNodeFactory;
import org.sirix.access.trx.node.json.JsonNodeFactoryImpl;
import org.sirix.access.trx.node.json.objectvalue.ObjectRecordValue;
import org.sirix.access.trx.node.xml.InsertPos;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.api.PageTrx;
import org.sirix.api.PostCommitHook;
import org.sirix.api.PreCommitHook;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.PostOrderAxis;
import org.sirix.exception.SirixIOException;
import org.sirix.exception.SirixThreadedException;
import org.sirix.exception.SirixUsageException;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.index.path.summary.PathSummaryWriter;
import org.sirix.node.Kind;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.json.ArrayNode;
import org.sirix.node.json.BooleanNode;
import org.sirix.node.json.NullNode;
import org.sirix.node.json.NumberNode;
import org.sirix.node.json.ObjectNode;
import org.sirix.node.json.ObjectRecordNode;
import org.sirix.node.json.StringNode;
import org.sirix.node.xdm.ElementNode;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.service.json.shredder.JsonShredder;
import org.sirix.service.xml.shredder.InsertPosition;
import org.sirix.settings.Constants;
import org.sirix.settings.Fixed;

final class JsonNodeTrxImpl
extends AbstractForwardingJsonNodeReadOnlyTrx
implements JsonNodeTrx {
    private final HashFunction mHash = Hashing.sha256();
    private static final int PRIME = 77081;
    private final int mMaxNodeCount;
    long mModificationCount;
    private final HashType mHashKind;
    private final ScheduledExecutorService mPool = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    final InternalJsonNodeReadOnlyTrx mNodeReadOnlyTrx;
    private boolean mBulkInsert;
    private PathSummaryWriter<JsonNodeReadOnlyTrx> mPathSummaryWriter;
    private final boolean mBuildPathSummary;
    private JsonNodeFactory mNodeFactory;
    private final Lock mLock;
    private final boolean mCompression;
    private final JsonIndexController mIndexController;
    private final InternalResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx> mResourceManager;
    private PageTrx<Long, Record, UnorderedKeyValuePage> mPageWriteTrx;
    private final List<PreCommitHook> mPreCommitHooks = new ArrayList<PreCommitHook>();
    private final List<PostCommitHook> mPostCommitHooks = new ArrayList<PostCommitHook>();

    JsonNodeTrxImpl(@Nonnegative long transactionID, InternalResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx> resourceManager, InternalJsonNodeReadOnlyTrx nodeReadTrx, PathSummaryWriter<JsonNodeReadOnlyTrx> pathSummaryWriter, @Nonnegative int maxNodeCount, TimeUnit timeUnit, @Nonnegative int maxTime, @Nonnull Node documentNode, JsonNodeFactory nodeFactory) {
        Preconditions.checkArgument((maxNodeCount >= 0 && maxTime >= 0 ? 1 : 0) != 0, (Object)"Negative arguments for maxNodeCount and maxTime are not accepted.");
        this.mResourceManager = (InternalResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mNodeReadOnlyTrx = (InternalJsonNodeReadOnlyTrx)Preconditions.checkNotNull((Object)nodeReadTrx);
        this.mBuildPathSummary = resourceManager.getResourceConfig().withPathSummary;
        this.mPathSummaryWriter = (PathSummaryWriter)Preconditions.checkNotNull(pathSummaryWriter);
        this.mIndexController = (JsonIndexController)resourceManager.getWtxIndexController(this.mNodeReadOnlyTrx.getPageTrx().getRevisionNumber());
        this.mPageWriteTrx = (PageTrx)this.mNodeReadOnlyTrx.getPageTrx();
        this.mNodeFactory = (JsonNodeFactory)Preconditions.checkNotNull((Object)nodeFactory);
        this.mMaxNodeCount = maxNodeCount;
        this.mModificationCount = 0L;
        if (maxTime > 0) {
            this.mPool.scheduleAtFixedRate(() -> this.commit(), maxTime, maxTime, timeUnit);
        }
        this.mLock = maxTime > 0 ? new ReentrantLock() : null;
        this.mHashKind = resourceManager.getResourceConfig().hashType;
        this.mCompression = resourceManager.getResourceConfig().useTextCompression;
    }

    private void acquireLock() {
        if (this.mLock != null) {
            this.mLock.lock();
        }
    }

    private void unLock() {
        if (this.mLock != null) {
            this.mLock.unlock();
        }
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(JsonReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(JsonReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING);
    }

    private JsonNodeTrx insertSubtree(JsonReader reader, InsertPosition insertionPosition) {
        Preconditions.checkNotNull((Object)reader);
        assert (insertionPosition != null);
        this.acquireLock();
        try {
            JsonToken peekedJsonToken = reader.peek();
            if (peekedJsonToken != JsonToken.BEGIN_OBJECT && peekedJsonToken != JsonToken.BEGIN_ARRAY) {
                throw new SirixUsageException(new String[]{"JSON to insert must begin with an array or object."});
            }
            Kind nodeKind = this.getKind();
            boolean skipRootJsonToken = false;
            block2 : switch (insertionPosition) {
                case AS_FIRST_CHILD: {
                    if (nodeKind != Kind.JSON_DOCUMENT && nodeKind != Kind.ARRAY && nodeKind != Kind.OBJECT) {
                        throw new IllegalStateException("Current node must either be the document root, an array or an object key.");
                    }
                    switch (peekedJsonToken) {
                        case BEGIN_OBJECT: {
                            if (nodeKind != Kind.OBJECT && nodeKind != Kind.ARRAY && nodeKind != Kind.JSON_DOCUMENT) {
                                throw new IllegalStateException("Current node in storage must be an object node.");
                            }
                            if (nodeKind != Kind.OBJECT) break block2;
                            skipRootJsonToken = true;
                            break;
                        }
                        case BEGIN_ARRAY: {
                            if (nodeKind != Kind.ARRAY && nodeKind != Kind.JSON_DOCUMENT) {
                                throw new IllegalStateException("Current node in storage must be an array node.");
                            }
                            if (nodeKind != Kind.ARRAY) break block2;
                            skipRootJsonToken = true;
                            break;
                        }
                    }
                    break;
                }
                case AS_RIGHT_SIBLING: {
                    Kind parentKind = this.getParentKind();
                    if (parentKind == Kind.ARRAY) break;
                    throw new IllegalStateException("Current parent node must an array.");
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.checkAccessAndCommit();
            this.mBulkInsert = true;
            long nodeKey = this.getCurrentNode().getNodeKey();
            JsonShredder.Builder shredderBuilder = new JsonShredder.Builder(this, reader, insertionPosition);
            if (skipRootJsonToken) {
                shredderBuilder.skipRootJsonToken();
            }
            JsonShredder shredder = shredderBuilder.build();
            shredder.call();
            this.moveTo(nodeKey);
            switch (insertionPosition) {
                case AS_FIRST_CHILD: {
                    this.moveToFirstChild();
                    break;
                }
                case AS_RIGHT_SIBLING: {
                    this.moveToRightSibling();
                    break;
                }
                case AS_LEFT_SIBLING: {
                    this.moveToLeftSibling();
                    break;
                }
            }
            if (this.mHashKind != HashType.NONE) {
                nodeKey = this.getCurrentNode().getNodeKey();
                this.postOrderTraversalHashes();
                ImmutableJsonNode startNode = this.getCurrentNode();
                this.moveToParent();
                while (this.getCurrentNode().hasParent()) {
                    this.moveToParent();
                    this.addParentHash(startNode);
                }
                this.moveTo(nodeKey);
            }
            this.commit();
            this.mBulkInsert = false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.unLock();
        }
        return this;
    }

    private void postOrderTraversalHashes() {
        new PostOrderAxis(this, IncludeSelf.YES).forEach(unused -> this.addHashAndDescendantCount());
    }

    private void addParentHash(ImmutableNode startNode) {
        switch (this.mHashKind) {
            case ROLLING: {
                long hashToAdd = this.mHash.hashLong((long)startNode.hashCode()).asLong();
                Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setHash(node.getHash() + hashToAdd * 77081L);
                if (!(startNode instanceof StructNode)) break;
                ((StructNode)node).setDescendantCount(((StructNode)node).getDescendantCount() + ((StructNode)startNode).getDescendantCount() + 1L);
                break;
            }
            case POSTORDER: {
                break;
            }
        }
    }

    private void addHashAndDescendantCount() {
        switch (this.mHashKind) {
            case ROLLING: {
                ImmutableJsonNode startNode = this.getCurrentNode();
                long oldDescendantCount = this.mNodeReadOnlyTrx.getStructuralNode().getDescendantCount();
                long descendantCount = oldDescendantCount == 0L ? 1L : oldDescendantCount + 1L;
                long hashToAdd = this.mHash.hashLong((long)startNode.hashCode()).asLong();
                Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setHash(hashToAdd);
                if (startNode.hasParent()) {
                    this.moveToParent();
                    node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                    node.setHash(node.getHash() + hashToAdd * 77081L);
                    JsonNodeTrxImpl.setAddDescendants(startNode, node, descendantCount);
                }
                this.mNodeReadOnlyTrx.setCurrentNode(startNode);
                break;
            }
            case POSTORDER: {
                this.postorderAdd();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectAsFirstChild() {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.JSON_DOCUMENT && kind != Kind.OBJECT_RECORD && kind != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not the document-, an object key- or a json array node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = kind == Kind.OBJECT_RECORD ? Fixed.NULL_NODE_KEY.getStandardProperty() : structNode.getFirstChildKey();
            ObjectNode node = this.mNodeFactory.createJsonObjectNode(parentKey, leftSibKey, rightSibKey);
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectAsRightSibling() {
        this.acquireLock();
        try {
            if (this.getParentKind() != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if parent node is not an array node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            ObjectNode node = this.mNodeFactory.createJsonObjectNode(parentKey, leftSibKey, rightSibKey);
            this.insertAsRightSibling(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectRecordAsFirstChild(String key, ObjectRecordValue<?> value) {
        Preconditions.checkNotNull((Object)key);
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.OBJECT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = structNode.getFirstChildKey();
            long pathNodeKey = this.getPathNodeKey(structNode.getNodeKey(), key, Kind.OBJECT_RECORD);
            ObjectRecordNode node = this.mNodeFactory.createJsonObjectKeyNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, key, Fixed.NULL_NODE_KEY.getStandardProperty());
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            this.insertValue(value);
            this.setFirstChildOfObjectKeyNode(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void setFirstChildOfObjectKeyNode(ObjectRecordNode node) {
        ObjectRecordNode objectKeyNode = (ObjectRecordNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), PageKind.RECORDPAGE, -1);
        objectKeyNode.incrementChildCount();
        objectKeyNode.setFirstChildKey(this.getNodeKey());
    }

    private void insertValue(ObjectRecordValue<?> value) throws AssertionError {
        Kind valueKind = value.getKind();
        switch (valueKind) {
            case OBJECT: {
                this.insertObjectAsFirstChild();
                break;
            }
            case ARRAY: {
                this.insertArrayAsFirstChild();
                break;
            }
            case STRING_VALUE: {
                this.insertStringValueAsFirstChild((String)value.getValue());
                break;
            }
            case BOOLEAN_VALUE: {
                this.insertBooleanValueAsFirstChild((Boolean)value.getValue());
                break;
            }
            case NUMBER_VALUE: {
                this.insertNumberValueAsFirstChild((Number)value.getValue());
                break;
            }
            case NULL_VALUE: {
                this.insertNullValueAsFirstChild();
                break;
            }
            default: {
                throw new AssertionError((Object)"Type not known.");
            }
        }
    }

    private long getPathNodeKey(long nodeKey, String name, Kind kind) {
        this.moveToParentObjectKeyArrayOrDocumentRoot();
        long pathNodeKey = this.mBuildPathSummary ? this.mPathSummaryWriter.getPathNodeKey(new QNm(name), kind) : 0L;
        this.mNodeReadOnlyTrx.moveTo(nodeKey);
        return pathNodeKey;
    }

    private void moveToParentObjectKeyArrayOrDocumentRoot() {
        while (this.mNodeReadOnlyTrx.getKind() != Kind.OBJECT_RECORD && this.mNodeReadOnlyTrx.getKind() != Kind.ARRAY && this.mNodeReadOnlyTrx.getKind() != Kind.JSON_DOCUMENT) {
            this.mNodeReadOnlyTrx.moveToParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectRecordAsRightSibling(String key, ObjectRecordValue<?> value) {
        Preconditions.checkNotNull((Object)key);
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.OBJECT_RECORD) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            long pathNodeKey = this.getPathNodeKey(currentNode.getNodeKey(), key, Kind.OBJECT_RECORD);
            ObjectRecordNode node = this.mNodeFactory.createJsonObjectKeyNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, key, -1L);
            this.insertAsRightSibling(node);
            this.insertValue(value);
            this.setFirstChildOfObjectKeyNode(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertArrayAsFirstChild() {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.JSON_DOCUMENT && kind != Kind.OBJECT_RECORD && kind != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not the document node or an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = currentNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = currentNode.getFirstChildKey();
            long pathNodeKey = this.getPathNodeKey(currentNode.getNodeKey(), "array", Kind.ARRAY);
            ArrayNode node = this.mNodeFactory.createJsonArrayNode(parentKey, leftSibKey, rightSibKey, pathNodeKey);
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertArrayAsRightSibling() {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind == Kind.JSON_DOCUMENT || kind == Kind.OBJECT_RECORD) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is either the document node or an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = (StructNode)((Object)this.getCurrentNode());
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            long pathNodeKey = this.getPathNodeKey(currentNode.getNodeKey(), "array", Kind.ARRAY);
            ArrayNode node = this.mNodeFactory.createJsonArrayNode(parentKey, leftSibKey, rightSibKey, pathNodeKey);
            this.insertAsRightSibling(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertStringValueAsFirstChild(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.OBJECT_RECORD && kind != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key or an arry node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long pathNodeKey = structNode.getNodeKey();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = structNode.getFirstChildKey();
            byte[] textValue = JsonNodeTrxImpl.getBytes(value);
            StringNode node = this.mNodeFactory.createJsonStringNode(parentKey, leftSibKey, rightSibKey, textValue, this.mCompression);
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void adaptNodesAndHashesForInsertAsFirstChild(ImmutableJsonNode node) {
        this.mNodeReadOnlyTrx.setCurrentNode(node);
        this.adaptForInsert((StructNode)((Object)node), InsertPos.ASFIRSTCHILD, PageKind.RECORDPAGE);
        this.mNodeReadOnlyTrx.setCurrentNode(node);
        this.adaptHashesWithAdd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertStringValueAsRightSibling(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind == Kind.OBJECT_RECORD || kind == Kind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is the document node or an object node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = (StructNode)((Object)this.getCurrentNode());
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            byte[] textValue = JsonNodeTrxImpl.getBytes(value);
            StringNode node = this.mNodeFactory.createJsonStringNode(parentKey, leftSibKey, rightSibKey, textValue, this.mCompression);
            this.insertAsRightSibling(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertBooleanValueAsFirstChild(boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.OBJECT_RECORD && kind != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key or array node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = (StructNode)((Object)this.getCurrentNode());
            long pathNodeKey = currentNode.getNodeKey();
            long parentKey = currentNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = currentNode.getFirstChildKey();
            BooleanNode node = this.mNodeFactory.createJsonBooleanNode(parentKey, leftSibKey, rightSibKey, value);
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertBooleanValueAsRightSibling(boolean value) {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind == Kind.OBJECT || kind == Kind.JSON_DOCUMENT || kind == Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is the document-, an object- or an array-node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = (StructNode)((Object)this.getCurrentNode());
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            BooleanNode node = this.mNodeFactory.createJsonBooleanNode(parentKey, leftSibKey, rightSibKey, value);
            this.insertAsRightSibling(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void insertAsRightSibling(ImmutableJsonNode node) {
        this.mNodeReadOnlyTrx.setCurrentNode(node);
        this.adaptForInsert((StructNode)((Object)node), InsertPos.ASRIGHTSIBLING, PageKind.RECORDPAGE);
        this.mNodeReadOnlyTrx.setCurrentNode(node);
        this.adaptHashesWithAdd();
        this.moveToParentObjectKeyArrayOrDocumentRoot();
        long pathNodeKey = this.isObjectKey() ? ((ObjectRecordNode)this.getNode()).getPathNodeKey() : -1L;
        this.moveTo(node.getNodeKey());
        this.mNodeReadOnlyTrx.setCurrentNode(node);
        this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNumberValueAsFirstChild(Number value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.OBJECT_RECORD && kind != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object-key- or array-node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = (StructNode)((Object)this.getCurrentNode());
            long pathNodeKey = currentNode.getNodeKey();
            long parentKey = currentNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = currentNode.getFirstChildKey();
            NumberNode node = this.mNodeFactory.createJsonNumberNode(parentKey, leftSibKey, rightSibKey, value);
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNumberValueAsRightSibling(Number value) {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind == Kind.OBJECT || kind == Kind.JSON_DOCUMENT || kind == Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is the document-, an object- or an array-node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = structNode.getParentKey();
            long leftSibKey = structNode.getNodeKey();
            long rightSibKey = structNode.getRightSiblingKey();
            NumberNode node = this.mNodeFactory.createJsonNumberNode(parentKey, leftSibKey, rightSibKey, value);
            this.insertAsRightSibling(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNullValueAsFirstChild() {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind != Kind.OBJECT_RECORD && kind != Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object-key- or array-node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = structNode.getRightSiblingKey();
            NullNode node = this.mNodeFactory.createJsonNullNode(parentKey, leftSibKey, rightSibKey);
            this.adaptNodesAndHashesForInsertAsFirstChild(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNullValueAsRightSibling() {
        this.acquireLock();
        try {
            Kind kind = this.getKind();
            if (kind == Kind.OBJECT || kind == Kind.JSON_DOCUMENT || kind == Kind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is the document-, an object- or an array-node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            NullNode node = this.mNodeFactory.createJsonNullNode(parentKey, leftSibKey, rightSibKey);
            this.insertAsRightSibling(node);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private static byte[] getBytes(String value) {
        return value.getBytes(Constants.DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx remove() {
        this.checkAccessAndCommit();
        this.acquireLock();
        try {
            StructNode node = (StructNode)((Object)this.getCurrentNode());
            if (node.getKind() == Kind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Document root can not be removed."});
            }
            Kind kind = node.getKind();
            if (this.getParentKind() == Kind.OBJECT_RECORD && (kind == Kind.STRING_VALUE || kind == Kind.BOOLEAN_VALUE || kind == Kind.NUMBER_VALUE || kind == Kind.NULL_VALUE)) {
                throw new SirixUsageException(new String[]{"An object record value can not be removed, you have to remove the whole object record (parent of this value)."});
            }
            PostOrderAxis axis = new PostOrderAxis(this);
            while (axis.hasNext()) {
                axis.next();
                this.removeName();
                this.removeValue();
                this.mPageWriteTrx.removeEntry(this.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            }
            ImmutableJsonNode jsonNode = (ImmutableJsonNode)((Object)node);
            this.mNodeReadOnlyTrx.setCurrentNode(jsonNode);
            this.adaptHashesWithRemove();
            this.adaptForRemove(node, PageKind.RECORDPAGE);
            this.mNodeReadOnlyTrx.setCurrentNode(jsonNode);
            if (node.getKind() == Kind.OBJECT_RECORD) {
                this.removeName();
            }
            if (!this.mNodeReadOnlyTrx.hasRightSibling() || !this.moveTo(node.getRightSiblingKey()).hasMoved()) {
                if (node.hasLeftSibling()) {
                    this.moveTo(node.getLeftSiblingKey());
                } else {
                    this.moveTo(node.getParentKey());
                }
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void removeValue() {
        if (this.getCurrentNode() instanceof ValueNode) {
            long nodeKey = this.getNodeKey();
            long pathNodeKey = this.moveToParent().hasMoved() ? ((ObjectRecordNode)this.getNode()).getPathNodeKey() : -1L;
            this.moveTo(nodeKey);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
        }
    }

    private void removeName() {
        if (this.getCurrentNode() instanceof NameNode) {
            NameNode node = (NameNode)((Object)this.getCurrentNode());
            Kind nodeKind = node.getKind();
            NamePage page = (NamePage)this.mPageWriteTrx.getActualRevisionRootPage().getNamePageReference().getPage();
            page.removeName(node.getPrefixKey(), nodeKind);
            page.removeName(node.getLocalNameKey(), nodeKind);
            page.removeName(node.getURIKey(), Kind.NAMESPACE);
            assert (nodeKind != Kind.JSON_DOCUMENT);
            if (this.mBuildPathSummary) {
                this.mPathSummaryWriter.remove(node, nodeKind, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setObjectKeyName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.acquireLock();
        try {
            if (this.getKind() != Kind.OBJECT_RECORD) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not an object key node!"});
            }
            this.checkAccessAndCommit();
            NameNode node = (NameNode)((Object)this.mNodeReadOnlyTrx.getCurrentNode());
            long oldHash = node.hashCode();
            Kind nodeKind = node.getKind();
            int oldLocalNameKey = node.getLocalNameKey();
            NamePage page = (NamePage)this.mPageWriteTrx.getActualRevisionRootPage().getNamePageReference().getPage();
            page.removeName(oldLocalNameKey, nodeKind);
            int localNameKey = name == null ? -1 : this.mPageWriteTrx.createNameKey(name, node.getKind());
            node = (NameNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), PageKind.RECORDPAGE, -1);
            node.setLocalNameKey(localNameKey);
            if (this.mBuildPathSummary) {
                this.mPathSummaryWriter.adaptPathForChangedNode(node, new QNm(name), -1, -1, localNameKey, PathSummaryWriter.OPType.SETNAME);
            }
            node.setPathNodeKey(this.mBuildPathSummary ? this.mPathSummaryWriter.getNodeKey() : 0L);
            this.mNodeReadOnlyTrx.setCurrentNode((ImmutableJsonNode)((Object)node));
            this.adaptHashedWithUpdate(oldHash);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setStringValue(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getKind() != Kind.STRING_VALUE) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not a string value node!"});
            }
            this.checkAccessAndCommit();
            long nodeKey = this.getNodeKey();
            long pathNodeKey = this.moveToParent().trx().getPathNodeKey();
            this.moveTo(nodeKey);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
            long oldHash = this.mNodeReadOnlyTrx.getCurrentNode().hashCode();
            byte[] byteVal = JsonNodeTrxImpl.getBytes(value);
            StringNode node = (StringNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            node.setValue(byteVal);
            this.mNodeReadOnlyTrx.setCurrentNode(node);
            this.adaptHashedWithUpdate(oldHash);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setBooleanValue(boolean value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getKind() != Kind.BOOLEAN_VALUE) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not a boolean value node!"});
            }
            this.checkAccessAndCommit();
            long nodeKey = this.getNodeKey();
            long pathNodeKey = this.moveToParent().trx().getPathNodeKey();
            this.moveTo(nodeKey);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
            long oldHash = this.mNodeReadOnlyTrx.getCurrentNode().hashCode();
            BooleanNode node = (BooleanNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            node.setValue(value);
            this.mNodeReadOnlyTrx.setCurrentNode(node);
            this.adaptHashedWithUpdate(oldHash);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public JsonNodeTrx setNumberValue(Number value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getCurrentNode().getKind() == Kind.NUMBER_VALUE) {
                this.checkAccessAndCommit();
                long nodeKey = this.getNodeKey();
                long pathNodeKey = this.moveToParent().trx().getPathNodeKey();
                this.moveTo(nodeKey);
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
                long oldHash = this.mNodeReadOnlyTrx.getCurrentNode().hashCode();
                NumberNode node = (NumberNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setValue(value);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashedWithUpdate(oldHash);
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
                JsonNodeTrxImpl jsonNodeTrxImpl = this;
                return jsonNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"setValue(String) is not allowed if current node is not an IValNode implementation!"});
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx revertTo(@Nonnegative int revision) {
        this.acquireLock();
        try {
            this.mNodeReadOnlyTrx.assertNotClosed();
            this.mResourceManager.assertAccess(revision);
            long trxID = this.getId();
            int revNumber = this.getRevisionNumber();
            this.mResourceManager.closeNodePageWriteTransaction(this.getId());
            PageTrx<Long, Record, UnorderedKeyValuePage> trx = this.mResourceManager.createPageWriteTransaction(trxID, revision, revNumber - 1, InternalResourceManager.Abort.NO, true);
            this.mNodeReadOnlyTrx.setPageReadTransaction(null);
            this.mNodeReadOnlyTrx.setPageReadTransaction(trx);
            this.mResourceManager.setNodePageWriteTransaction(this.getId(), trx);
            this.mNodeFactory = null;
            this.mNodeFactory = new JsonNodeFactoryImpl(trx);
            this.reInstantiateIndexes();
            this.mModificationCount = 0L;
            this.moveToDocumentRoot();
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block6: {
            this.acquireLock();
            try {
                if (this.isClosed()) break block6;
                if (this.mModificationCount > 0L) {
                    throw new SirixUsageException(new String[]{"Must commit/rollback transaction first!"});
                }
                long trxId = this.getId();
                this.mNodeReadOnlyTrx.close();
                this.mResourceManager.closeWriteTransaction(trxId);
                this.removeCommitFile();
                this.mPathSummaryWriter = null;
                this.mNodeFactory = null;
                this.mPool.shutdown();
                try {
                    this.mPool.awaitTermination(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new SirixThreadedException(e);
                }
            }
            finally {
                this.unLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx rollback() {
        this.acquireLock();
        try {
            this.mNodeReadOnlyTrx.assertNotClosed();
            this.mModificationCount = 0L;
            long trxID = this.getId();
            int revision = this.getRevisionNumber();
            int revNumber = this.mPageWriteTrx.getUberPage().isBootstrap() ? 0 : revision - 1;
            UberPage uberPage = this.mPageWriteTrx.rollback();
            this.mResourceManager.setLastCommittedUberPage(uberPage);
            this.mNodeReadOnlyTrx.getPageTrx().clearCaches();
            this.mNodeReadOnlyTrx.getPageTrx().closeCaches();
            this.mResourceManager.closeNodePageWriteTransaction(this.getId());
            this.mNodeReadOnlyTrx.setPageReadTransaction(null);
            this.removeCommitFile();
            this.mPageWriteTrx = this.mResourceManager.createPageWriteTransaction(trxID, revNumber, revNumber, InternalResourceManager.Abort.YES, true);
            this.mNodeReadOnlyTrx.setPageReadTransaction(this.mPageWriteTrx);
            this.mResourceManager.setNodePageWriteTransaction(this.getId(), this.mPageWriteTrx);
            this.mNodeFactory = null;
            this.mNodeFactory = new JsonNodeFactoryImpl(this.mPageWriteTrx);
            this.reInstantiateIndexes();
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void removeCommitFile() {
        try {
            Path commitFile = this.mResourceManager.getCommitFile();
            if (Files.exists(commitFile, new LinkOption[0])) {
                Files.delete(this.mResourceManager.getCommitFile());
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public JsonNodeTrx commit() {
        return this.commit(null);
    }

    void reInstantiate(@Nonnegative long trxID, @Nonnegative int revNumber) {
        this.mResourceManager.closeNodePageWriteTransaction(this.getId());
        this.mPageWriteTrx = this.mResourceManager.createPageWriteTransaction(trxID, revNumber, revNumber, InternalResourceManager.Abort.NO, true);
        this.mNodeReadOnlyTrx.setPageReadTransaction(null);
        this.mNodeReadOnlyTrx.setPageReadTransaction(this.mPageWriteTrx);
        this.mResourceManager.setNodePageWriteTransaction(this.getId(), this.mPageWriteTrx);
        this.mNodeFactory = null;
        this.mNodeFactory = new JsonNodeFactoryImpl(this.mPageWriteTrx);
        this.reInstantiateIndexes();
    }

    private void reInstantiateIndexes() {
        if (this.mBuildPathSummary) {
            this.mPathSummaryWriter = null;
            this.mPathSummaryWriter = new PathSummaryWriter<InternalJsonNodeReadOnlyTrx>(this.mPageWriteTrx, this.mNodeReadOnlyTrx.getResourceManager(), this.mNodeFactory, this.mNodeReadOnlyTrx);
        }
        this.mIndexController.createIndexListeners(this.mIndexController.getIndexes().getIndexDefs(), this);
    }

    private void checkAccessAndCommit() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        ++this.mModificationCount;
        this.intermediateCommitIfRequired();
    }

    private void adaptForInsert(StructNode structNode, InsertPos insertPos, PageKind pageKind) {
        assert (structNode != null);
        assert (insertPos != null);
        assert (pageKind != null);
        StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(structNode.getParentKey(), pageKind, -1);
        parent.incrementChildCount();
        if (!structNode.hasLeftSibling()) {
            parent.setFirstChildKey(structNode.getNodeKey());
        }
        if (structNode.hasRightSibling()) {
            StructNode rightSiblingNode = (StructNode)this.mPageWriteTrx.prepareEntryForModification(structNode.getRightSiblingKey(), pageKind, -1);
            rightSiblingNode.setLeftSiblingKey(structNode.getNodeKey());
        }
        if (structNode.hasLeftSibling()) {
            StructNode leftSiblingNode = (StructNode)this.mPageWriteTrx.prepareEntryForModification(structNode.getLeftSiblingKey(), pageKind, -1);
            leftSiblingNode.setRightSiblingKey(structNode.getNodeKey());
        }
    }

    private void adaptForRemove(StructNode oldNode, PageKind page) {
        assert (oldNode != null);
        boolean concatenated = false;
        if (oldNode.hasLeftSibling() && oldNode.hasRightSibling() && this.moveTo(oldNode.getRightSiblingKey()).hasMoved() && this.getCurrentNode().getKind() == Kind.TEXT && this.moveTo(oldNode.getLeftSiblingKey()).hasMoved() && this.getCurrentNode().getKind() == Kind.TEXT) {
            StringBuilder builder = new StringBuilder(this.getValue());
            this.moveTo(oldNode.getRightSiblingKey());
            builder.append(this.getValue());
            this.moveTo(oldNode.getLeftSiblingKey());
            concatenated = true;
        }
        if (oldNode.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(oldNode.getLeftSiblingKey(), page, -1);
            if (concatenated) {
                this.moveTo(oldNode.getRightSiblingKey());
                leftSibling.setRightSiblingKey(((StructNode)((Object)this.getCurrentNode())).getRightSiblingKey());
            } else {
                leftSibling.setRightSiblingKey(oldNode.getRightSiblingKey());
            }
        }
        if (oldNode.hasRightSibling()) {
            StructNode rightSibling;
            if (concatenated) {
                this.moveTo(oldNode.getRightSiblingKey());
                this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getRightSiblingKey());
                rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), page, -1);
                rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
            } else {
                rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(oldNode.getRightSiblingKey(), page, -1);
                rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
            }
        }
        StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(oldNode.getParentKey(), page, -1);
        if (!oldNode.hasLeftSibling()) {
            parent.setFirstChildKey(oldNode.getRightSiblingKey());
        }
        parent.decrementChildCount();
        if (concatenated) {
            parent.decrementDescendantCount();
            parent.decrementChildCount();
        }
        if (concatenated) {
            this.moveTo(parent.getNodeKey());
            while (parent.hasParent()) {
                this.moveToParent();
                StructNode ancestor = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), page, -1);
                ancestor.decrementDescendantCount();
                parent = ancestor;
            }
        }
        if (concatenated) {
            this.moveTo(oldNode.getRightSiblingKey());
            this.mPageWriteTrx.removeEntry(this.mNodeReadOnlyTrx.getNodeKey(), page, -1);
        }
        if (oldNode.getKind() == Kind.ELEMENT) {
            this.moveTo(oldNode.getNodeKey());
        }
        this.moveTo(oldNode.getNodeKey());
        this.mPageWriteTrx.removeEntry(oldNode.getNodeKey(), page, -1);
    }

    private void intermediateCommitIfRequired() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        if (this.mMaxNodeCount > 0 && this.mModificationCount > (long)this.mMaxNodeCount) {
            this.commit();
        }
    }

    private void adaptHashesWithAdd() {
        if (!this.mBulkInsert) {
            switch (this.mHashKind) {
                case ROLLING: {
                    this.rollingAdd();
                    break;
                }
                case POSTORDER: {
                    this.postorderAdd();
                    break;
                }
            }
        }
    }

    private void adaptHashesWithRemove() {
        if (!this.mBulkInsert) {
            switch (this.mHashKind) {
                case ROLLING: {
                    this.rollingRemove();
                    break;
                }
                case POSTORDER: {
                    this.postorderRemove();
                    break;
                }
            }
        }
    }

    private void adaptHashedWithUpdate(long pOldHash) {
        if (!this.mBulkInsert) {
            switch (this.mHashKind) {
                case ROLLING: {
                    this.rollingUpdate(pOldHash);
                    break;
                }
                case POSTORDER: {
                    this.postorderAdd();
                    break;
                }
            }
        }
    }

    private void postorderRemove() {
        this.moveTo(this.getCurrentNode().getParentKey());
        this.postorderAdd();
    }

    private void postorderAdd() {
        StructNode cursorToRoot;
        ImmutableJsonNode startNode = this.getCurrentNode();
        long hashCodeForParent = 0L;
        if (!(startNode instanceof StructNode)) {
            Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            node.setHash(this.mHash.hashLong((long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode()).asLong());
            this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey());
        }
        do {
            cursorToRoot = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            hashCodeForParent = (long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode() + hashCodeForParent * 77081L;
            if (cursorToRoot.getKind() == Kind.ELEMENT) {
                ElementNode currentElement = (ElementNode)cursorToRoot;
                int attCount = ((ElementNode)cursorToRoot).getAttributeCount();
                for (int i = 0; i < attCount; ++i) {
                    this.moveTo(currentElement.getAttributeKey(i));
                    hashCodeForParent = (long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode() + hashCodeForParent * 77081L;
                }
                int nspCount = ((ElementNode)cursorToRoot).getNamespaceCount();
                for (int i = 0; i < nspCount; ++i) {
                    this.moveTo(currentElement.getNamespaceKey(i));
                    hashCodeForParent = (long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode() + hashCodeForParent * 77081L;
                }
                this.moveTo(cursorToRoot.getNodeKey());
            }
            if (this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getFirstChildKey()).hasMoved()) {
                do {
                    hashCodeForParent = this.mNodeReadOnlyTrx.getCurrentNode().getHash() + hashCodeForParent * 77081L;
                } while (this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getRightSiblingKey()).hasMoved());
                this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getParentKey());
            }
            cursorToRoot.setHash(hashCodeForParent);
            hashCodeForParent = 0L;
        } while (this.moveTo(cursorToRoot.getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(startNode);
    }

    private void rollingUpdate(long oldHash) {
        long hash;
        ImmutableJsonNode newNode = this.getCurrentNode();
        long newNodeHash = hash = (long)newNode.hashCode();
        long resultNew = hash;
        do {
            Node node;
            if ((node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1)).getNodeKey() == newNode.getNodeKey()) {
                resultNew = node.getHash() - oldHash;
                resultNew += newNodeHash;
            } else {
                resultNew = node.getHash() - oldHash * 77081L;
                resultNew += newNodeHash * 77081L;
            }
            node.setHash(resultNew);
        } while (this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(newNode);
    }

    private void rollingRemove() {
        ImmutableJsonNode startNode = this.getCurrentNode();
        long hashToRemove = startNode.getHash();
        long hashToAdd = 0L;
        long newHash = 0L;
        do {
            Node node;
            if ((node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1)).getNodeKey() == startNode.getNodeKey()) {
                newHash = 0L;
            } else if (node.getNodeKey() == startNode.getParentKey()) {
                newHash = node.getHash() - hashToRemove * 77081L;
                hashToRemove = node.getHash();
                this.setRemoveDescendants(startNode);
            } else {
                newHash = node.getHash() - hashToRemove * 77081L;
                newHash += hashToAdd * 77081L;
                hashToRemove = node.getHash();
                this.setRemoveDescendants(startNode);
            }
            node.setHash(newHash);
            hashToAdd = newHash;
        } while (this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(startNode);
    }

    private void setRemoveDescendants(ImmutableNode startNode) {
        assert (startNode != null);
        if (startNode instanceof StructNode) {
            StructNode node = (StructNode)((Object)this.getCurrentNode());
            node.setDescendantCount(node.getDescendantCount() - ((StructNode)startNode).getDescendantCount() - 1L);
        }
    }

    private void rollingAdd() {
        ImmutableJsonNode startNode = this.mNodeReadOnlyTrx.getCurrentNode();
        long oldDescendantCount = this.mNodeReadOnlyTrx.getStructuralNode().getDescendantCount();
        long descendantCount = oldDescendantCount == 0L ? 1L : oldDescendantCount + 1L;
        long hashToAdd = startNode.getHash() == 0L ? this.mHash.hashLong((long)startNode.hashCode()).asLong() : startNode.getHash();
        long newHash = 0L;
        long possibleOldHash = 0L;
        do {
            Node node;
            if ((node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1)).getNodeKey() == startNode.getNodeKey()) {
                newHash = hashToAdd;
            } else if (node.getNodeKey() == startNode.getParentKey()) {
                possibleOldHash = node.getHash();
                hashToAdd = newHash = possibleOldHash + hashToAdd * 77081L;
                JsonNodeTrxImpl.setAddDescendants(startNode, node, descendantCount);
            } else {
                newHash = node.getHash() - possibleOldHash * 77081L;
                hashToAdd = newHash += hashToAdd * 77081L;
                possibleOldHash = node.getHash();
                JsonNodeTrxImpl.setAddDescendants(startNode, node, descendantCount);
            }
            node.setHash(newHash);
        } while (this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(startNode);
    }

    private static void setAddDescendants(ImmutableNode startNode, Node nodeToModifiy, @Nonnegative long descendantCount) {
        assert (startNode != null);
        assert (descendantCount >= 0L);
        assert (nodeToModifiy != null);
        if (startNode instanceof StructNode) {
            StructNode node = (StructNode)nodeToModifiy;
            long oldDescendantCount = node.getDescendantCount();
            node.setDescendantCount(oldDescendantCount + descendantCount);
        }
    }

    private ImmutableJsonNode getCurrentNode() {
        return this.mNodeReadOnlyTrx.getCurrentNode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("readTrx", (Object)this.mNodeReadOnlyTrx.toString()).add("hashKind", (Object)this.mHashKind).toString();
    }

    @Override
    protected JsonNodeReadOnlyTrx delegate() {
        return this.mNodeReadOnlyTrx;
    }

    @Override
    public JsonNodeTrx addPreCommitHook(PreCommitHook hook) {
        this.acquireLock();
        try {
            this.mPreCommitHooks.add((PreCommitHook)Preconditions.checkNotNull((Object)hook));
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public JsonNodeTrx addPostCommitHook(PostCommitHook hook) {
        this.acquireLock();
        try {
            this.mPostCommitHooks.add((PostCommitHook)Preconditions.checkNotNull((Object)hook));
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof JsonNodeTrxImpl) {
            JsonNodeTrxImpl wtx = (JsonNodeTrxImpl)obj;
            return Objects.equal((Object)this.mNodeReadOnlyTrx, (Object)wtx.mNodeReadOnlyTrx);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeReadOnlyTrx});
    }

    @Override
    public PathSummaryReader getPathSummary() {
        this.acquireLock();
        try {
            PathSummaryReader pathSummaryReader = this.mPathSummaryWriter.getPathSummary();
            return pathSummaryReader;
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public JsonNodeTrx truncateTo(int revision) {
        this.mNodeReadOnlyTrx.assertNotClosed();
        return this;
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        return this.mNodeReadOnlyTrx.getCommitCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx commit(String commitMessage) {
        this.mNodeReadOnlyTrx.assertNotClosed();
        this.acquireLock();
        try {
            for (PreCommitHook preCommitHook : this.mPreCommitHooks) {
                preCommitHook.preCommit(this);
            }
            this.mModificationCount = 0L;
            UberPage uberPage = commitMessage == null ? this.mPageWriteTrx.commit() : this.mPageWriteTrx.commit(commitMessage);
            this.mResourceManager.setLastCommittedUberPage(uberPage);
            this.reInstantiate(this.getId(), this.getRevisionNumber());
        }
        finally {
            this.unLock();
        }
        for (PostCommitHook postCommitHook : this.mPostCommitHooks) {
            postCommitHook.postCommit(this);
        }
        return this;
    }

    @Override
    public PageTrx<Long, Record, UnorderedKeyValuePage> getPageWtx() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        return (PageTrx)this.mNodeReadOnlyTrx.getPageTrx();
    }
}

