/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node;

import com.google.common.base.Preconditions;
import java.time.Instant;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.access.trx.node.Move;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.node.Kind;
import org.sirix.node.NullNode;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.settings.Fixed;
import org.sirix.utils.NamePageHash;

public abstract class AbstractNodeReadTrx<T extends NodeCursor>
implements NodeCursor,
NodeReadOnlyTrx {
    private final long mId;
    protected PageReadOnlyTrx mPageReadTrx;
    protected ImmutableNode mCurrentNode;

    public AbstractNodeReadTrx(@Nonnegative long trxId, @Nonnull PageReadOnlyTrx pageReadTransaction, ImmutableNode documentNode) {
        Preconditions.checkArgument((trxId >= 0L ? 1 : 0) != 0);
        this.mId = trxId;
        this.mPageReadTrx = (PageReadOnlyTrx)Preconditions.checkNotNull((Object)pageReadTransaction);
        this.mCurrentNode = (ImmutableNode)Preconditions.checkNotNull((Object)documentNode);
    }

    public Move<T> moveToPrevious() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasLeftSibling()) {
            Move<Object> leftSiblMove = this.moveTo(node.getLeftSiblingKey());
            while (leftSiblMove.trx().hasFirstChild()) {
                leftSiblMove = leftSiblMove.trx().moveToLastChild();
            }
            return leftSiblMove;
        }
        return this.moveTo(node.getParentKey());
    }

    @Override
    public Kind getLeftSiblingKind() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof StructNode && this.hasLeftSibling()) {
            long nodeKey = this.mCurrentNode.getNodeKey();
            this.moveToLeftSibling();
            Kind leftSiblKind = this.mCurrentNode.getKind();
            this.moveTo(nodeKey);
            return leftSiblKind;
        }
        return Kind.UNKNOWN;
    }

    @Override
    public long getLeftSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getLeftSiblingKey();
    }

    @Override
    public boolean hasLeftSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLeftSibling();
    }

    public Move<T> moveToLeftSibling() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (!node.hasLeftSibling()) {
            return Move.notMoved();
        }
        return this.moveTo(node.getLeftSiblingKey());
    }

    @Override
    public int keyForName(String name) {
        this.assertNotClosed();
        return NamePageHash.generateHashForString(name);
    }

    @Override
    public String nameForKey(int key) {
        this.assertNotClosed();
        return this.mPageReadTrx.getName(key, this.mCurrentNode.getKind());
    }

    @Override
    public long getPathNodeKey() {
        this.assertNotClosed();
        ImmutableNode node = this.mCurrentNode;
        if (node instanceof NameNode) {
            return ((NameNode)node).getPathNodeKey();
        }
        if (node.getKind() == Kind.XDM_DOCUMENT) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public long getId() {
        this.assertNotClosed();
        return this.mId;
    }

    @Override
    public int getRevisionNumber() {
        this.assertNotClosed();
        return this.mPageReadTrx.getActualRevisionRootPage().getRevision();
    }

    @Override
    public Instant getRevisionTimestamp() {
        this.assertNotClosed();
        return Instant.ofEpochMilli(this.mPageReadTrx.getActualRevisionRootPage().getRevisionTimestamp());
    }

    public Move<T> moveToDocumentRoot() {
        this.assertNotClosed();
        return this.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
    }

    public Move<T> moveToParent() {
        this.assertNotClosed();
        return this.moveTo(this.mCurrentNode.getParentKey());
    }

    public Move<T> moveToFirstChild() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (!node.hasFirstChild()) {
            return Move.notMoved();
        }
        return this.moveTo(node.getFirstChildKey());
    }

    public abstract Move<T> moveTo(long var1);

    public Move<T> moveToRightSibling() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (!node.hasRightSibling()) {
            return Move.notMoved();
        }
        return this.moveTo(node.getRightSiblingKey());
    }

    @Override
    public long getNodeKey() {
        this.assertNotClosed();
        return this.mCurrentNode.getNodeKey();
    }

    @Override
    public long getHash() {
        this.assertNotClosed();
        return this.mCurrentNode.getHash();
    }

    @Override
    public Kind getKind() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind();
    }

    protected abstract void assertNotClosed();

    public PageReadOnlyTrx getPageTransaction() {
        this.assertNotClosed();
        return this.mPageReadTrx;
    }

    public final void setPageReadTransaction(@Nullable PageReadOnlyTrx pageReadTransaction) {
        this.assertNotClosed();
        this.mPageReadTrx = pageReadTransaction;
    }

    @Override
    public final long getMaxNodeKey() {
        this.assertNotClosed();
        return this.mPageReadTrx.getActualRevisionRootPage().getMaxNodeKey();
    }

    public final StructNode getStructuralNode() {
        ImmutableNode node = this.mCurrentNode;
        if (node instanceof StructNode) {
            return (StructNode)node;
        }
        return new NullNode(node);
    }

    public Move<T> moveToNextFollowing() {
        this.assertNotClosed();
        while (!this.getStructuralNode().hasRightSibling() && this.mCurrentNode.hasParent()) {
            this.moveToParent();
        }
        return this.moveToRightSibling();
    }

    @Override
    public boolean hasNode(@Nonnegative long key) {
        this.assertNotClosed();
        long nodeKey = this.mCurrentNode.getNodeKey();
        boolean retVal = !this.moveTo(key).equals(Move.notMoved());
        this.moveTo(nodeKey);
        return retVal;
    }

    @Override
    public boolean hasParent() {
        this.assertNotClosed();
        return this.mCurrentNode.hasParent();
    }

    @Override
    public boolean hasFirstChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasRightSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasRightSibling();
    }

    @Override
    public long getRightSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getRightSiblingKey();
    }

    @Override
    public long getFirstChildKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getFirstChildKey();
    }

    @Override
    public long getParentKey() {
        this.assertNotClosed();
        return this.mCurrentNode.getParentKey();
    }

    @Override
    public Kind getParentKind() {
        this.assertNotClosed();
        ImmutableNode node = this.mCurrentNode;
        if (node.getParentKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return Kind.UNKNOWN;
        }
        long nodeKey = node.getNodeKey();
        this.moveToParent();
        Kind parentKind = this.mCurrentNode.getKind();
        this.moveTo(nodeKey);
        return parentKind;
    }

    public Move<T> moveToNext() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasRightSibling()) {
            return this.moveTo(node.getRightSiblingKey());
        }
        return this.moveToNextFollowing();
    }

    protected abstract T thisInstance();

    public Move<T> moveToLastChild() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasFirstChild()) {
            this.moveToFirstChild();
            while (this.getStructuralNode().hasRightSibling()) {
                this.moveToRightSibling();
            }
            return Move.moved(this.thisInstance());
        }
        return Move.notMoved();
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        long nodeKey = this.mCurrentNode.getNodeKey();
        boolean retVal = this.moveToLastChild() != null;
        this.moveTo(nodeKey);
        return retVal;
    }

    @Override
    public Kind getLastChildKind() {
        this.assertNotClosed();
        ImmutableNode node = this.mCurrentNode;
        if (node instanceof StructNode && this.hasLastChild()) {
            long nodeKey = node.getNodeKey();
            this.moveToLastChild();
            Kind lastChildKind = this.mCurrentNode.getKind();
            this.moveTo(nodeKey);
            return lastChildKind;
        }
        return Kind.UNKNOWN;
    }

    @Override
    public Kind getFirstChildKind() {
        this.assertNotClosed();
        ImmutableNode node = this.mCurrentNode;
        if (node instanceof StructNode && this.hasFirstChild()) {
            long nodeKey = node.getNodeKey();
            this.moveToFirstChild();
            Kind firstChildKind = this.mCurrentNode.getKind();
            this.moveTo(nodeKey);
            return firstChildKind;
        }
        return Kind.UNKNOWN;
    }

    @Override
    public long getLastChildKey() {
        this.assertNotClosed();
        ImmutableNode node = this.mCurrentNode;
        if (node instanceof StructNode && this.hasLastChild()) {
            long nodeKey = node.getNodeKey();
            this.moveToLastChild();
            long lastChildNodeKey = this.mCurrentNode.getNodeKey();
            this.moveTo(nodeKey);
            return lastChildNodeKey;
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getChildCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getChildCount();
    }

    @Override
    public boolean hasChildren() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public long getDescendantCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getDescendantCount();
    }

    @Override
    public Kind getPathKind() {
        this.assertNotClosed();
        return Kind.UNKNOWN;
    }

    @Override
    public Kind getRightSiblingKind() {
        this.assertNotClosed();
        ImmutableNode node = this.mCurrentNode;
        if (node instanceof StructNode && this.hasRightSibling()) {
            long nodeKey = node.getNodeKey();
            this.moveToRightSibling();
            Kind rightSiblKind = this.mCurrentNode.getKind();
            this.moveTo(nodeKey);
            return rightSiblKind;
        }
        return Kind.UNKNOWN;
    }

    @Override
    public PageReadOnlyTrx getPageTrx() {
        return this.mPageReadTrx;
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        return this.mPageReadTrx.getCommitCredentials();
    }
}

