/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.brackit.xquery.util.serialize.SubtreePrinter;
import org.brackit.xquery.xdm.DocumentException;
import org.sirix.access.trx.node.IndexController;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.exception.SirixRuntimeException;
import org.sirix.index.ChangeListener;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexType;
import org.sirix.index.Indexes;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.cas.CASFilter;
import org.sirix.index.cas.CASFilterRange;
import org.sirix.index.cas.CASIndex;
import org.sirix.index.name.NameFilter;
import org.sirix.index.name.NameIndex;
import org.sirix.index.path.PCRCollector;
import org.sirix.index.path.PathFilter;
import org.sirix.index.path.PathIndex;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.page.UnorderedKeyValuePage;

public abstract class AbstractIndexController<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
implements IndexController<R, W> {
    protected final Indexes mIndexes;
    private final Set<ChangeListener> mListeners;
    protected final PathIndex<?, ?> mPathIndex;
    protected final CASIndex<?, ?, R> mCASIndex;
    protected final NameIndex<?, ?> mNameIndex;

    public AbstractIndexController(Indexes indexes, Set<ChangeListener> listeners, PathIndex<?, ?> pathIndex, CASIndex<?, ?, R> casIndex, NameIndex<?, ?> nameIndex) {
        this.mIndexes = indexes;
        this.mListeners = listeners;
        this.mPathIndex = pathIndex;
        this.mCASIndex = casIndex;
        this.mNameIndex = nameIndex;
    }

    @Override
    public boolean containsIndex(IndexType type) {
        for (IndexDef indexDef : this.mIndexes.getIndexDefs()) {
            if (indexDef.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public Indexes getIndexes() {
        return this.mIndexes;
    }

    @Override
    public void serialize(OutputStream out) {
        try {
            SubtreePrinter serializer = new SubtreePrinter(new PrintStream((OutputStream)Preconditions.checkNotNull((Object)out)));
            serializer.print(this.mIndexes.materialize());
            serializer.end();
        }
        catch (DocumentException e) {
            throw new SirixRuntimeException(e);
        }
    }

    @Override
    public void notifyChange(XmlIndexController.ChangeType type, @Nonnull ImmutableNode node, long pathNodeKey) {
        for (ChangeListener listener : this.mListeners) {
            listener.listen(type, node, pathNodeKey);
        }
    }

    @Override
    public IndexController<R, W> createIndexListeners(Set<IndexDef> indexDefs, W nodeWriteTrx) {
        Preconditions.checkNotNull(nodeWriteTrx);
        for (IndexDef indexDef : indexDefs) {
            this.mIndexes.add(indexDef);
            switch (indexDef.getType()) {
                case PATH: {
                    this.mListeners.add(this.createPathIndexListener(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case CAS: {
                    this.mListeners.add(this.createCASIndexListener(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case NAME: {
                    this.mListeners.add(this.createNameIndexListener(nodeWriteTrx.getPageWtx(), indexDef));
                    break;
                }
            }
        }
        return this;
    }

    private ChangeListener createPathIndexListener(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return this.mPathIndex.createListener(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private ChangeListener createCASIndexListener(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return this.mCASIndex.createListener(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private ChangeListener createNameIndexListener(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, IndexDef indexDef) {
        return this.mNameIndex.createListener(pageWriteTrx, indexDef);
    }

    @Override
    public NameFilter createNameFilter(String[] queryString) {
        HashSet<QNm> includes = new HashSet<QNm>(queryString.length);
        for (String name : queryString) {
            includes.add(new QNm(name));
        }
        return new NameFilter(includes, Collections.emptySet());
    }

    @Override
    public CASFilter createCASFilter(String[] pathArray, Atomic key, SearchMode mode, PCRCollector pcrCollector) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(pathArray.length);
        if (pathArray.length > 0) {
            for (String path : pathArray) {
                paths.add((Path<QNm>)Path.parse((String)path));
            }
        }
        return new CASFilter(paths, key, mode, pcrCollector);
    }

    @Override
    public CASFilterRange createCASFilterRange(String[] pathArray, Atomic min, Atomic max, boolean incMin, boolean incMax, PCRCollector pcrCollector) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(pathArray.length);
        if (pathArray.length > 0) {
            for (String path : pathArray) {
                paths.add((Path<QNm>)Path.parse((String)path));
            }
        }
        return new CASFilterRange(paths, min, max, incMin, incMax, pcrCollector);
    }

    @Override
    public Iterator<NodeReferences> openPathIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, PathFilter filter) {
        if (this.mPathIndex == null) {
            throw new IllegalStateException("This document does not support path indexes.");
        }
        return this.mPathIndex.openIndex(pageRtx, indexDef, filter);
    }

    @Override
    public Iterator<NodeReferences> openNameIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, NameFilter filter) {
        if (this.mNameIndex == null) {
            throw new IllegalStateException("This document does not support name indexes.");
        }
        return this.mNameIndex.openIndex(pageRtx, indexDef, filter);
    }

    @Override
    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, CASFilter filter) {
        if (this.mCASIndex == null) {
            throw new IllegalStateException("This document does not support CAS indexes.");
        }
        return this.mCASIndex.openIndex(pageRtx, indexDef, filter);
    }

    @Override
    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, CASFilterRange filter) {
        if (this.mCASIndex == null) {
            throw new IllegalStateException("This document does not support path indexes.");
        }
        return this.mCASIndex.openIndex(pageRtx, indexDef, filter);
    }
}

