/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.util;

import android.annotation.TargetApi;
import io.sentry.ReplayRecording;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ReplayCache;
import io.sentry.rrweb.RRWebEvent;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/sentry/android/replay/util/PersistableLinkedList;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lio/sentry/rrweb/RRWebEvent;", "propertyName", "", "options", "Lio/sentry/SentryOptions;", "persistingExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "cacheProvider", "Lkotlin/Function0;", "Lio/sentry/android/replay/ReplayCache;", "(Ljava/lang/String;Lio/sentry/SentryOptions;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function0;)V", "add", "", "element", "addAll", "elements", "", "persistRecording", "", "remove", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nPersistable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Persistable.kt\nio/sentry/android/replay/util/PersistableLinkedList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class PersistableLinkedList
extends ConcurrentLinkedDeque<RRWebEvent> {
    @NotNull
    private final String propertyName;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ScheduledExecutorService persistingExecutor;
    @NotNull
    private final Function0<ReplayCache> cacheProvider;

    public PersistableLinkedList(@NotNull String propertyName, @NotNull SentryOptions options, @NotNull ScheduledExecutorService persistingExecutor2, @NotNull Function0<ReplayCache> cacheProvider) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)persistingExecutor2, (String)"persistingExecutor");
        Intrinsics.checkNotNullParameter(cacheProvider, (String)"cacheProvider");
        this.propertyName = propertyName;
        this.options = options;
        this.persistingExecutor = persistingExecutor2;
        this.cacheProvider = cacheProvider;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends RRWebEvent> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean result = super.addAll(elements);
        this.persistRecording();
        return result;
    }

    @Override
    public boolean add(@NotNull RRWebEvent element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean result = super.add(element);
        this.persistRecording();
        return result;
    }

    @Override
    @NotNull
    public RRWebEvent remove() {
        RRWebEvent result = (RRWebEvent)super.remove();
        this.persistRecording();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    private final void persistRecording() {
        ReplayRecording replayRecording;
        ReplayCache replayCache = (ReplayCache)this.cacheProvider.invoke();
        if (replayCache == null) {
            return;
        }
        ReplayCache cache = replayCache;
        ReplayRecording $this$persistRecording_u24lambda_u240 = replayRecording = new ReplayRecording();
        boolean bl = false;
        $this$persistRecording_u24lambda_u240.setPayload((List)new ArrayList(this));
        ReplayRecording recording = replayRecording;
        if (this.options.getMainThreadChecker().isMainThread()) {
            this.persistingExecutor.submit(() -> PersistableLinkedList.persistRecording$lambda$1(this, recording, cache));
        } else {
            StringWriter stringWriter = new StringWriter();
            this.options.getSerializer().serialize((Object)recording, (Writer)new BufferedWriter(stringWriter));
            cache.persistSegmentValues(this.propertyName, stringWriter.toString());
        }
    }

    private static final void persistRecording$lambda$1(PersistableLinkedList this$0, ReplayRecording $recording, ReplayCache $cache) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$recording, (String)"$recording");
        Intrinsics.checkNotNullParameter((Object)$cache, (String)"$cache");
        StringWriter stringWriter = new StringWriter();
        this$0.options.getSerializer().serialize((Object)$recording, (Writer)new BufferedWriter(stringWriter));
        $cache.persistSegmentValues(this$0.propertyName, stringWriter.toString());
    }
}

