/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.DateUtils;
import io.sentry.ReplayRecording;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.GeneratedVideo;
import io.sentry.android.replay.LastSegmentData;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayFrame;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.video.MuxerConfig;
import io.sentry.android.replay.video.SimpleVideoEncoder;
import io.sentry.protocol.SentryId;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.util.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b&J\"\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0014J\b\u0010(\u001a\u00020 H\u0016JJ\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020\u0017J\u0010\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\u0017H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\rH\u0002J\u0018\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010\u0014J\u0010\u0010<\u001a\u0004\u0018\u00010\u00142\u0006\u0010=\u001a\u00020$R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u00178@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001d\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/sentry/android/replay/ReplayCache;", "Ljava/io/Closeable;", "options", "Lio/sentry/SentryOptions;", "replayId", "Lio/sentry/protocol/SentryId;", "(Lio/sentry/SentryOptions;Lio/sentry/protocol/SentryId;)V", "encoder", "Lio/sentry/android/replay/video/SimpleVideoEncoder;", "encoderLock", "", "frames", "", "Lio/sentry/android/replay/ReplayFrame;", "getFrames$sentry_android_replay_release", "()Ljava/util/List;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "ongoingSegment", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "ongoingSegmentFile", "Ljava/io/File;", "getOngoingSegmentFile", "()Ljava/io/File;", "ongoingSegmentFile$delegate", "Lkotlin/Lazy;", "replayCacheDir", "getReplayCacheDir$sentry_android_replay_release", "replayCacheDir$delegate", "addFrame", "", "bitmap", "Landroid/graphics/Bitmap;", "frameTimestamp", "", "screen", "addFrame$sentry_android_replay_release", "screenshot", "close", "createVideoOf", "Lio/sentry/android/replay/GeneratedVideo;", "duration", "from", "segmentId", "", "height", "width", "frameRate", "bitRate", "videoFile", "deleteFile", "file", "encode", "", "frame", "persistSegmentValues", "key", "value", "rotate", "until", "Companion", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReplayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,444:1\n1#2:445\n1#2:448\n230#3,2:446\n739#4,4:449\n*S KotlinDebug\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache\n*L\n268#1:448\n268#1:446,2\n269#1:449,4\n*E\n"})
public final class ReplayCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryId replayId;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final Object encoderLock;
    @Nullable
    private SimpleVideoEncoder encoder;
    @NotNull
    private final Lazy replayCacheDir$delegate;
    @NotNull
    private final List<ReplayFrame> frames;
    @NotNull
    private final LinkedHashMap<String, String> ongoingSegment;
    @NotNull
    private final Lazy ongoingSegmentFile$delegate;
    public static final int $stable = 8;
    @NotNull
    public static final String ONGOING_SEGMENT = ".ongoing_segment";
    @NotNull
    public static final String SEGMENT_KEY_HEIGHT = "config.height";
    @NotNull
    public static final String SEGMENT_KEY_WIDTH = "config.width";
    @NotNull
    public static final String SEGMENT_KEY_FRAME_RATE = "config.frame-rate";
    @NotNull
    public static final String SEGMENT_KEY_BIT_RATE = "config.bit-rate";
    @NotNull
    public static final String SEGMENT_KEY_TIMESTAMP = "segment.timestamp";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_ID = "replay.id";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_TYPE = "replay.type";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_SCREEN_AT_START = "replay.screen-at-start";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_RECORDING = "replay.recording";
    @NotNull
    public static final String SEGMENT_KEY_ID = "segment.id";

    public ReplayCache(@NotNull SentryOptions options, @NotNull SentryId replayId) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        this.options = options;
        this.replayId = replayId;
        this.isClosed = new AtomicBoolean(false);
        this.encoderLock = new Object();
        this.replayCacheDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ReplayCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final File invoke() {
                return ReplayCache.Companion.makeReplayCacheDir(ReplayCache.access$getOptions$p(this.this$0), ReplayCache.access$getReplayId$p(this.this$0));
            }
        }));
        this.frames = new ArrayList();
        this.ongoingSegment = new LinkedHashMap();
        this.ongoingSegmentFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ReplayCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final File invoke() {
                if (this.this$0.getReplayCacheDir$sentry_android_replay_release() == null) {
                    return null;
                }
                File file = new File(this.this$0.getReplayCacheDir$sentry_android_replay_release(), ".ongoing_segment");
                if (!file.exists()) {
                    file.createNewFile();
                }
                return file;
            }
        }));
    }

    @Nullable
    public final File getReplayCacheDir$sentry_android_replay_release() {
        Lazy lazy = this.replayCacheDir$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final List<ReplayFrame> getFrames$sentry_android_replay_release() {
        return this.frames;
    }

    private final File getOngoingSegmentFile() {
        Lazy lazy = this.ongoingSegmentFile$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFrame$sentry_android_replay_release(@NotNull Bitmap bitmap, long frameTimestamp, @Nullable String screen) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.getReplayCacheDir$sentry_android_replay_release() == null || bitmap.isRecycled()) {
            return;
        }
        File file = this.getReplayCacheDir$sentry_android_replay_release();
        if (file != null) {
            file.mkdirs();
        }
        Object object = new File(this.getReplayCacheDir$sentry_android_replay_release(), frameTimestamp + ".jpg");
        File it = object;
        boolean bl = false;
        it.createNewFile();
        File screenshot = object;
        object = new FileOutputStream(screenshot);
        Throwable throwable = null;
        try {
            FileOutputStream it2 = (FileOutputStream)object;
            boolean bl2 = false;
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)it2);
            it2.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this.addFrame(screenshot, frameTimestamp, screen);
    }

    public static /* synthetic */ void addFrame$sentry_android_replay_release$default(ReplayCache replayCache, Bitmap bitmap, long l, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        replayCache.addFrame$sentry_android_replay_release(bitmap, l, string);
    }

    public final void addFrame(@NotNull File screenshot, long frameTimestamp, @Nullable String screen) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        ReplayFrame frame = new ReplayFrame(screenshot, frameTimestamp, screen);
        ((Collection)this.frames).add(frame);
    }

    public static /* synthetic */ void addFrame$default(ReplayCache replayCache, File file, long l, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        replayCache.addFrame(file, l, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final GeneratedVideo createVideoOf(long duration, long from, int segmentId, int height, int width, int frameRate, int bitRate, @NotNull File videoFile) {
        SimpleVideoEncoder $i$a$-synchronized-ReplayCache$createVideoOf$32;
        Intrinsics.checkNotNullParameter((Object)videoFile, (String)"videoFile");
        if (videoFile.exists() && videoFile.length() > 0L) {
            videoFile.delete();
        }
        if (this.frames.isEmpty()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "No captured frames, skipping generating a video segment", new Object[0]);
            return null;
        }
        Object object = this.encoderLock;
        ReplayCache replayCache = this;
        Object object2 = object;
        synchronized (object2) {
            SimpleVideoEncoder simpleVideoEncoder;
            boolean $i$a$-synchronized-ReplayCache$createVideoOf$32 = false;
            SimpleVideoEncoder it = simpleVideoEncoder = new SimpleVideoEncoder(this.options, new MuxerConfig(videoFile, width, height, frameRate, bitRate, null, 32, null), null, 4, null);
            boolean bl = false;
            it.start();
            $i$a$-synchronized-ReplayCache$createVideoOf$32 = simpleVideoEncoder;
        }
        replayCache.encoder = $i$a$-synchronized-ReplayCache$createVideoOf$32;
        long step = (long)1000 / (long)frameRate;
        int frameCount = 0;
        ReplayFrame lastFrame = (ReplayFrame)CollectionsKt.first(this.frames);
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)from, (long)(from + duration))), (long)step);
        long timestamp = longProgression.getFirst();
        long l = longProgression.getLast();
        long l2 = longProgression.getStep();
        if (l2 > 0L && timestamp <= l || l2 < 0L && l <= timestamp) {
            while (true) {
                for (ReplayFrame frame : this.frames) {
                    long l3 = timestamp + step;
                    long l4 = frame.getTimestamp();
                    boolean bl = timestamp <= l4 ? l4 <= l3 : false;
                    if (bl) {
                        lastFrame = frame;
                        break;
                    }
                    if (frame.getTimestamp() <= timestamp + step) continue;
                }
                if (this.encode(lastFrame)) {
                    ++frameCount;
                }
                if (timestamp == l) break;
                timestamp += l2;
            }
        }
        if (frameCount == 0) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Generated a video with no frames, not capturing a replay segment", new Object[0]);
            this.deleteFile(videoFile);
            return null;
        }
        long videoDuration = 0L;
        Object object3 = this.encoderLock;
        synchronized (object3) {
            boolean bl = false;
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            SimpleVideoEncoder simpleVideoEncoder2 = this.encoder;
            videoDuration = simpleVideoEncoder2 != null ? simpleVideoEncoder2.getDuration() : 0L;
            this.encoder = null;
            Unit unit = Unit.INSTANCE;
        }
        this.rotate(from + duration);
        return new GeneratedVideo(videoFile, frameCount, videoDuration);
    }

    public static /* synthetic */ GeneratedVideo createVideoOf$default(ReplayCache replayCache, long l, long l2, int n, int n2, int n3, int n4, int n5, File file, int n6, Object object) {
        if ((n6 & 0x80) != 0) {
            file = new File(replayCache.getReplayCacheDir$sentry_android_replay_release(), n + ".mp4");
        }
        return replayCache.createVideoOf(l, l2, n, n2, n3, n4, n5, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean encode(ReplayFrame frame) {
        boolean bl;
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)frame.getScreenshot().getAbsolutePath());
            Object object = this.encoderLock;
            synchronized (object) {
                Unit unit;
                boolean bl2 = false;
                SimpleVideoEncoder simpleVideoEncoder = this.encoder;
                if (simpleVideoEncoder != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
                    simpleVideoEncoder.encode(bitmap);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            bitmap.recycle();
            bl = true;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Unable to decode bitmap and encode it into a video, skipping frame", e);
            bl = false;
        }
        return bl;
    }

    private final void deleteFile(File file) {
        try {
            if (!file.delete()) {
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete replay frame: %s", objectArray);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to delete replay frame: %s", objectArray);
        }
    }

    @Nullable
    public final String rotate(long until) {
        Ref.ObjectRef screen = new Ref.ObjectRef();
        CollectionsKt.removeAll(this.frames, (Function1)((Function1)new Function1<ReplayFrame, Boolean>(until, this, (Ref.ObjectRef<String>)screen){
            final /* synthetic */ long $until;
            final /* synthetic */ ReplayCache this$0;
            final /* synthetic */ Ref.ObjectRef<String> $screen;
            {
                this.$until = $until;
                this.this$0 = $receiver;
                this.$screen = $screen;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ReplayFrame it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getTimestamp() < this.$until) {
                    ReplayCache.access$deleteFile(this.this$0, it.getScreenshot());
                    return true;
                }
                if (this.$screen.element == null) {
                    this.$screen.element = it.getScreen();
                }
                return false;
            }
        }));
        return (String)screen.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.encoderLock;
        synchronized (object) {
            boolean bl = false;
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            this.encoder = null;
            Unit unit = Unit.INSTANCE;
        }
        this.isClosed.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final synchronized void persistSegmentValues(@NotNull String key, @Nullable String value) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (this.isClosed.get()) {
                return;
            }
            if (this.ongoingSegment.isEmpty()) {
                File file = this.getOngoingSegmentFile();
                if (file != null) {
                    void $this$useLines$iv$iv;
                    File $this$useLines_u24default$iv = file;
                    Charset charset$iv = Charsets.UTF_8;
                    File file2 = $this$useLines_u24default$iv;
                    Charset charset$iv$iv = charset$iv;
                    boolean $i$f$useLines = false;
                    Closeable closeable = $this$useLines$iv$iv;
                    int n = 8192;
                    Object object = closeable;
                    closeable = (object = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object), charset$iv$iv)) instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                    Throwable throwable = null;
                    try {
                        void $this$associateTo$iv;
                        BufferedReader it$iv$iv = (BufferedReader)closeable;
                        boolean bl = false;
                        Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                        boolean bl2 = false;
                        Sequence sequence = lines;
                        Map destination$iv = this.ongoingSegment;
                        boolean $i$f$associateTo = false;
                        for (Object element$iv : $this$associateTo$iv) {
                            Map map = destination$iv;
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            String[] stringArray = new String[]{"="};
                            List list = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                            String k = (String)list.get(0);
                            String v = (String)list.get(1);
                            Pair pair = TuplesKt.to((Object)k, (Object)v);
                            map.put(pair.getFirst(), pair.getSecond());
                        }
                        object = (LinkedHashMap)destination$iv;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            if (value == null) {
                this.ongoingSegment.remove(key);
            } else {
                ((Map)this.ongoingSegment).put(key, value);
            }
            File file = this.getOngoingSegmentFile();
            if (file == null) break block11;
            Set<Map.Entry<String, String>> set = this.ongoingSegment.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"ongoingSegment.entries");
            FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)persistSegmentValues.2.INSTANCE, (int)30, null), null, (int)2, null);
        }
    }

    public static final /* synthetic */ void access$deleteFile(ReplayCache $this, File file) {
        $this.deleteFile(file);
    }

    public static final /* synthetic */ SentryOptions access$getOptions$p(ReplayCache $this) {
        return $this.options;
    }

    public static final /* synthetic */ SentryId access$getReplayId$p(ReplayCache $this) {
        return $this.replayId;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142%\b\u0002\u0010\u0015\u001a\u001f\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/sentry/android/replay/ReplayCache$Companion;", "", "()V", "ONGOING_SEGMENT", "", "SEGMENT_KEY_BIT_RATE", "SEGMENT_KEY_FRAME_RATE", "SEGMENT_KEY_HEIGHT", "SEGMENT_KEY_ID", "SEGMENT_KEY_REPLAY_ID", "SEGMENT_KEY_REPLAY_RECORDING", "SEGMENT_KEY_REPLAY_SCREEN_AT_START", "SEGMENT_KEY_REPLAY_TYPE", "SEGMENT_KEY_TIMESTAMP", "SEGMENT_KEY_WIDTH", "fromDisk", "Lio/sentry/android/replay/LastSegmentData;", "options", "Lio/sentry/SentryOptions;", "replayId", "Lio/sentry/protocol/SentryId;", "replayCacheProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lio/sentry/android/replay/ReplayCache;", "fromDisk$sentry_android_replay_release", "makeReplayCacheDir", "Ljava/io/File;", "sentry-android-replay_release"})
    @SourceDebugExtension(value={"SMAP\nReplayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,444:1\n1#2:445\n1#2:448\n230#3,2:446\n739#4,4:449\n1002#5,2:453\n1045#5:455\n*S KotlinDebug\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache$Companion\n*L\n319#1:448\n319#1:446,2\n320#1:449,4\n385#1:453,2\n416#1:455\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final File makeReplayCacheDir(@NotNull SentryOptions options, @NotNull SentryId replayId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
            Object object2 = options.getCacheDirPath();
            if (object2 == null || object2.length() == 0) {
                options.getLogger().log(SentryLevel.WARNING, "SentryOptions.cacheDirPath is not set, session replay is no-op", new Object[0]);
                object = null;
            } else {
                String string = options.getCacheDirPath();
                Intrinsics.checkNotNull((Object)string);
                Object it = object2 = new File(string, "replay_" + replayId);
                boolean bl = false;
                ((File)it).mkdirs();
                object = object2;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Nullable
        public final LastSegmentData fromDisk$sentry_android_replay_release(@NotNull SentryOptions options, @NotNull SentryId replayId, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
            block28: {
                block27: {
                    Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                    Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
                    replayCacheDir = this.makeReplayCacheDir(options, replayId);
                    lastSegmentFile = new File(replayCacheDir, ".ongoing_segment");
                    if (!lastSegmentFile.exists()) {
                        var6_6 = new Object[]{replayId};
                        options.getLogger().log(SentryLevel.DEBUG, "No ongoing segment found for replay: %s", var6_6);
                        FileUtils.deleteRecursively((File)replayCacheDir);
                        return null;
                    }
                    lastSegment = new LinkedHashMap<K, V>();
                    $this$useLines_u24default$iv = lastSegmentFile;
                    charset$iv = Charsets.UTF_8;
                    var9_10 = $this$useLines_u24default$iv;
                    charset$iv$iv = charset$iv;
                    $i$f$useLines = false;
                    var12_14 = $this$useLines$iv$iv;
                    var13_15 = 8192;
                    var14_17 = var12_14;
                    var12_14 = (var14_17 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)var14_17), charset$iv$iv)) instanceof BufferedReader != false ? (BufferedReader)var14_17 : new BufferedReader(var14_17, var13_15);
                    var13_16 /* !! */  = null;
                    try {
                        it$iv$iv = (BufferedReader)var12_14;
                        $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv$iv = false;
                        lines = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                        $i$a$-useLines$default-ReplayCache$Companion$fromDisk$1 = false;
                        $this$associateTo$iv = lines;
                        $i$f$associateTo = false;
                        for (E element$iv : $this$associateTo$iv) {
                            var22_36 = lastSegment;
                            it = (String)element$iv;
                            $i$a$-associateTo-ReplayCache$Companion$fromDisk$1$1 = false;
                            var25_41 = new String[]{"="};
                            var26_43 = StringsKt.split$default((CharSequence)it, (String[])var25_41, (boolean)false, (int)2, (int)2, null);
                            k = (String)var26_43.get(0);
                            v = (String)var26_43.get(1);
                            var23_38 = TuplesKt.to((Object)k, (Object)v);
                            var22_36.put(var23_38.getFirst(), var23_38.getSecond());
                        }
                        it$iv$iv = (LinkedHashMap)((Map)lastSegment);
                    }
                    catch (Throwable it$iv$iv) {
                        var13_16 /* !! */  = it$iv$iv;
                        throw it$iv$iv;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var12_14, (Throwable)var13_16 /* !! */ );
                    }
                    v0 = (String)lastSegment.get("config.height");
                    height = v0 != null ? StringsKt.toIntOrNull((String)v0) : null;
                    v1 = (String)lastSegment.get("config.width");
                    width = v1 != null ? StringsKt.toIntOrNull((String)v1) : null;
                    v2 = (String)lastSegment.get("config.frame-rate");
                    frameRate = v2 != null ? StringsKt.toIntOrNull((String)v2) : null;
                    v3 = (String)lastSegment.get("config.bit-rate");
                    bitRate = v3 != null ? StringsKt.toIntOrNull((String)v3) : null;
                    v4 = (String)lastSegment.get("segment.id");
                    segmentId = v4 != null ? StringsKt.toIntOrNull((String)v4) : null;
                    try {
                        v5 = (String)lastSegment.get("segment.timestamp");
                        if (v5 == null) {
                            v5 = "";
                        }
                        var13_16 /* !! */  = DateUtils.getDateTime((String)v5);
                    }
                    catch (Throwable e) {
                        var13_16 /* !! */  = null;
                    }
                    segmentTimestamp = var13_16 /* !! */ ;
                    try {
                        v6 = (String)lastSegment.get("replay.type");
                        if (v6 == null) {
                            v6 = "";
                        }
                        e = SentryReplayEvent.ReplayType.valueOf((String)v6);
                    }
                    catch (Throwable e) {
                        e = null;
                    }
                    replayType = e;
                    if (height == null || width == null || frameRate == null || bitRate == null || segmentId == null) break block27;
                    e = -1;
                    if (segmentId != e && segmentTimestamp != null && replayType != null) break block28;
                }
                e = new Object[]{replayId};
                options.getLogger().log(SentryLevel.DEBUG, "Incorrect segment values found for replay: %s, deleting the replay", e);
                FileUtils.deleteRecursively((File)replayCacheDir);
                return null;
            }
            recorderConfig = new ScreenshotRecorderConfig(width, height, 1.0f, 1.0f, frameRate, bitRate);
            v7 = replayCacheProvider;
            if (v7 == null || (v7 = (ReplayCache)v7.invoke((Object)replayId)) == null) {
                v7 = new ReplayCache(options, replayId);
            }
            cache = v7;
            v8 = cache.getReplayCacheDir$sentry_android_replay_release();
            if (v8 != null) {
                v8.listFiles((FilenameFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;Ljava/lang/String;)Z, fromDisk$lambda$3(io.sentry.android.replay.ReplayCache java.io.File java.lang.String ), (Ljava/io/File;Ljava/lang/String;)Z)((ReplayCache)cache));
            }
            if (cache.getFrames$sentry_android_replay_release().isEmpty()) {
                lines = new Object[]{replayId};
                options.getLogger().log(SentryLevel.DEBUG, "No frames found for replay: %s, deleting the replay", lines);
                FileUtils.deleteRecursively((File)replayCacheDir);
                return null;
            }
            $this$sortBy$iv = cache.getFrames$sentry_android_replay_release();
            $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ReplayFrame it = (ReplayFrame)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTimestamp());
                        it = (ReplayFrame)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                    }
                });
            }
            v9 = normalizedSegmentId = replayType == SentryReplayEvent.ReplayType.SESSION ? segmentId : 0;
            if (replayType == SentryReplayEvent.ReplayType.SESSION) {
                v10 /* !! */  = segmentTimestamp;
            } else {
                v11 = DateUtils.getDateTime((long)((ReplayFrame)CollectionsKt.first(cache.getFrames$sentry_android_replay_release())).getTimestamp());
                v10 /* !! */  = v11;
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"{\n                // in \u2026.timestamp)\n            }");
            }
            normalizedTimestamp = v10 /* !! */ ;
            duration = ((ReplayFrame)CollectionsKt.last(cache.getFrames$sentry_android_replay_release())).getTimestamp() - normalizedTimestamp.getTime() + (long)(1000 / frameRate);
            v12 = (String)lastSegment.get("replay.recording");
            if (v12 == null) ** GOTO lbl-1000
            it = v12;
            $i$a$-let-ReplayCache$Companion$fromDisk$events$1 = false;
            reader = new StringReader(it);
            v13 = recording = (ReplayRecording)options.getSerializer().deserialize((Reader)reader, ReplayRecording.class);
            if ((v13 != null ? v13.getPayload() : null) != null) {
                v14 = recording.getPayload();
                Intrinsics.checkNotNull((Object)v14);
                v15 = new LinkedList<E>(v14);
            } else {
                v15 = null;
            }
            v12 = v15;
            if (v15 != null) {
                v16 = (List)v12;
            } else lbl-1000:
            // 2 sources

            {
                v16 = CollectionsKt.emptyList();
            }
            events = v16;
            $this$sortedBy$iv = events;
            $i$f$sortedBy = false;
            return new LastSegmentData(recorderConfig, (ReplayCache)cache, (Date)normalizedTimestamp, normalizedSegmentId, duration, replayType, (String)lastSegment.get("replay.screen-at-start"), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RRWebEvent it = (RRWebEvent)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (RRWebEvent)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            }));
        }

        public static /* synthetic */ LastSegmentData fromDisk$sentry_android_replay_release$default(Companion companion, SentryOptions sentryOptions, SentryId sentryId, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.fromDisk$sentry_android_replay_release(sentryOptions, sentryId, (Function1<? super SentryId, ReplayCache>)function1);
        }

        private static final boolean fromDisk$lambda$3(ReplayCache $cache, File dir, String name) {
            File file;
            Long timestamp;
            Intrinsics.checkNotNullParameter((Object)$cache, (String)"$cache");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (StringsKt.endsWith$default((String)name, (String)".jpg", (boolean)false, (int)2, null) && (timestamp = StringsKt.toLongOrNull((String)FilesKt.getNameWithoutExtension((File)(file = new File(dir, name))))) != null) {
                ReplayCache.addFrame$default($cache, file, timestamp, null, 4, null);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

