/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.MotionEvent;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.ISentryExecutorService;
import io.sentry.Integration;
import io.sentry.JsonDeserializer;
import io.sentry.NoOpReplayBreadcrumbConverter;
import io.sentry.ReplayBreadcrumbConverter;
import io.sentry.ReplayController;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.SentryReplayOptions;
import io.sentry.android.replay.LastSegmentData;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayIntegration;
import io.sentry.android.replay.RootViewsSpy;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.BufferCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.capture.SessionCaptureStrategy;
import io.sentry.android.replay.gestures.GestureRecorder;
import io.sentry.android.replay.gestures.TouchRecorderCallback;
import io.sentry.android.replay.util.ContextKt;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.SamplingKt;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.hints.Backfillable;
import io.sentry.protocol.SentryId;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Random;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001cB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u00cb\u0001\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012#\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010\u00128\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017\u0012%\b\u0002\u0010\u001c\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u0012\u0010\b\u0002\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\r\u00a2\u0006\u0002\u0010#B\u008a\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012%\b\u0002\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010\u0012:\b\u0002\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017\u00a2\u0006\u0002\u0010$J\u0017\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010EJ\u0012\u0010F\u001a\u00020C2\b\b\u0002\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020CH\u0016J\b\u0010J\u001a\u00020CH\u0002J\b\u0010K\u001a\u000208H\u0016J\b\u0010L\u001a\u00020\u0018H\u0016J\b\u0010-\u001a\u00020\u0011H\u0016J\u0010\u0010M\u001a\u00020C2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020CH\u0016J\u0010\u0010Q\u001a\u00020C2\u0006\u0010R\u001a\u00020SH\u0016J\u0018\u0010Q\u001a\u00020C2\u0006\u0010T\u001a\u00020:2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020C2\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020CH\u0016J\u0018\u0010[\u001a\u00020C2\u0006\u0010'\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0016J\b\u0010\\\u001a\u00020CH\u0002J\b\u0010]\u001a\u00020CH\u0016J\u0010\u0010^\u001a\u00020C2\u0006\u0010_\u001a\u000208H\u0016J\b\u0010`\u001a\u00020CH\u0016J\b\u0010a\u001a\u00020CH\u0016J\b\u0010b\u001a\u00020CH\u0002R\u0010\u0010%\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u00100\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b2\u00103R\u0010\u00106\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00109\u001a\u0004\u0018\u00010:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R@\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010=\u001a\u00020>8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u00105\u001a\u0004\b?\u0010@\u00a8\u0006d"}, d2={"Lio/sentry/android/replay/ReplayIntegration;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "Lio/sentry/android/replay/gestures/TouchRecorderCallback;", "Lio/sentry/ReplayController;", "Landroid/content/ComponentCallbacks;", "context", "Landroid/content/Context;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;)V", "recorderProvider", "Lkotlin/Function0;", "Lio/sentry/android/replay/Recorder;", "recorderConfigProvider", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "configChanged", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "replayCacheProvider", "Lkotlin/Function2;", "Lio/sentry/protocol/SentryId;", "replayId", "recorderConfig", "Lio/sentry/android/replay/ReplayCache;", "replayCaptureStrategyProvider", "isFullSession", "Lio/sentry/android/replay/capture/CaptureStrategy;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "gestureRecorderProvider", "Lio/sentry/android/replay/gestures/GestureRecorder;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lio/sentry/android/replay/util/MainLooperHandler;Lkotlin/jvm/functions/Function0;)V", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "captureStrategy", "gestureRecorder", "hub", "Lio/sentry/IHub;", "isEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled$sentry_android_replay_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isRecording", "options", "Lio/sentry/SentryOptions;", "random", "Lio/sentry/util/Random;", "getRandom", "()Lio/sentry/util/Random;", "random$delegate", "Lkotlin/Lazy;", "recorder", "replayBreadcrumbConverter", "Lio/sentry/ReplayBreadcrumbConverter;", "replayCacheDir", "Ljava/io/File;", "getReplayCacheDir", "()Ljava/io/File;", "rootViewsSpy", "Lio/sentry/android/replay/RootViewsSpy;", "getRootViewsSpy", "()Lio/sentry/android/replay/RootViewsSpy;", "rootViewsSpy$delegate", "captureReplay", "", "isTerminating", "(Ljava/lang/Boolean;)V", "cleanupReplays", "unfinishedReplayId", "", "close", "finalizePreviousReplay", "getBreadcrumbConverter", "getReplayId", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onScreenshotRecorded", "bitmap", "Landroid/graphics/Bitmap;", "screenshot", "frameTimestamp", "", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pause", "register", "registerRootViewListeners", "resume", "setBreadcrumbConverter", "converter", "start", "stop", "unregisterRootViewListeners", "PreviousReplayHint", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReplayIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayIntegration.kt\nio/sentry/android/replay/ReplayIntegration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,345:1\n13579#2,2:346\n*S KotlinDebug\n*F\n+ 1 ReplayIntegration.kt\nio/sentry/android/replay/ReplayIntegration\n*L\n285#1:346,2\n*E\n"})
public final class ReplayIntegration
implements Integration,
Closeable,
ScreenshotRecorderCallback,
TouchRecorderCallback,
ReplayController,
ComponentCallbacks {
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @Nullable
    private final Function0<Recorder> recorderProvider;
    @Nullable
    private final Function1<Boolean, ScreenshotRecorderConfig> recorderConfigProvider;
    @Nullable
    private final Function2<SentryId, ScreenshotRecorderConfig, ReplayCache> replayCacheProvider;
    private SentryOptions options;
    @Nullable
    private IHub hub;
    @Nullable
    private Recorder recorder;
    @Nullable
    private GestureRecorder gestureRecorder;
    @NotNull
    private final Lazy random$delegate;
    @NotNull
    private final Lazy rootViewsSpy$delegate;
    @NotNull
    private final AtomicBoolean isEnabled;
    @NotNull
    private final AtomicBoolean isRecording;
    @Nullable
    private CaptureStrategy captureStrategy;
    @NotNull
    private ReplayBreadcrumbConverter replayBreadcrumbConverter;
    @Nullable
    private Function1<? super Boolean, ? extends CaptureStrategy> replayCaptureStrategyProvider;
    @NotNull
    private MainLooperHandler mainLooperHandler;
    @Nullable
    private Function0<GestureRecorder> gestureRecorderProvider;
    private ScreenshotRecorderConfig recorderConfig;
    public static final int $stable = 8;

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider, @Nullable Function0<? extends Recorder> recorderProvider, @Nullable Function1<? super Boolean, ScreenshotRecorderConfig> recorderConfigProvider, @Nullable Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.context = context;
        this.dateProvider = dateProvider;
        this.recorderProvider = recorderProvider;
        this.recorderConfigProvider = recorderConfigProvider;
        this.replayCacheProvider = replayCacheProvider;
        this.random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
        this.rootViewsSpy$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)rootViewsSpy.2.INSTANCE);
        this.isEnabled = new AtomicBoolean(false);
        this.isRecording = new AtomicBoolean(false);
        NoOpReplayBreadcrumbConverter noOpReplayBreadcrumbConverter = NoOpReplayBreadcrumbConverter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)noOpReplayBreadcrumbConverter, (String)"getInstance()");
        this.replayBreadcrumbConverter = (ReplayBreadcrumbConverter)noOpReplayBreadcrumbConverter;
        this.mainLooperHandler = new MainLooperHandler(null, 1, null);
    }

    public /* synthetic */ ReplayIntegration(Context context, ICurrentDateProvider iCurrentDateProvider, Function0 function0, Function1 function1, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        if ((n & 0x10) != 0) {
            function2 = null;
        }
        this(context, iCurrentDateProvider, (Function0<? extends Recorder>)function0, (Function1<? super Boolean, ScreenshotRecorderConfig>)function1, (Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache>)function2);
    }

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this(ContextKt.appContext(context), dateProvider, null, null, null);
    }

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider, @Nullable Function0<? extends Recorder> recorderProvider, @Nullable Function1<? super Boolean, ScreenshotRecorderConfig> recorderConfigProvider, @Nullable Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache> replayCacheProvider, @Nullable Function1<? super Boolean, ? extends CaptureStrategy> replayCaptureStrategyProvider, @Nullable MainLooperHandler mainLooperHandler, @Nullable Function0<GestureRecorder> gestureRecorderProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this(ContextKt.appContext(context), dateProvider, recorderProvider, recorderConfigProvider, replayCacheProvider);
        this.replayCaptureStrategyProvider = replayCaptureStrategyProvider;
        MainLooperHandler mainLooperHandler2 = mainLooperHandler;
        if (mainLooperHandler2 == null) {
            mainLooperHandler2 = new MainLooperHandler(null, 1, null);
        }
        this.mainLooperHandler = mainLooperHandler2;
        this.gestureRecorderProvider = gestureRecorderProvider;
    }

    public /* synthetic */ ReplayIntegration(Context context, ICurrentDateProvider iCurrentDateProvider, Function0 function0, Function1 function1, Function2 function2, Function1 function12, MainLooperHandler mainLooperHandler, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function12 = null;
        }
        if ((n & 0x40) != 0) {
            mainLooperHandler = null;
        }
        if ((n & 0x80) != 0) {
            function02 = null;
        }
        this(context, iCurrentDateProvider, (Function0<? extends Recorder>)function0, (Function1<? super Boolean, ScreenshotRecorderConfig>)function1, (Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache>)function2, (Function1<? super Boolean, ? extends CaptureStrategy>)function12, mainLooperHandler, (Function0<GestureRecorder>)function02);
    }

    private final Random getRandom() {
        Lazy lazy = this.random$delegate;
        return (Random)lazy.getValue();
    }

    private final RootViewsSpy getRootViewsSpy() {
        Lazy lazy = this.rootViewsSpy$delegate;
        return (RootViewsSpy)lazy.getValue();
    }

    @NotNull
    public final AtomicBoolean isEnabled$sentry_android_replay_release() {
        return this.isEnabled;
    }

    @Nullable
    public final File getReplayCacheDir() {
        CaptureStrategy captureStrategy = this.captureStrategy;
        return captureStrategy != null ? captureStrategy.getReplayCacheDir() : null;
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        if (Build.VERSION.SDK_INT < 26) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is only supported on API 26 and above", new Object[0]);
            return;
        }
        if (!options.getExperimental().getSessionReplay().isSessionReplayEnabled() && !options.getExperimental().getSessionReplay().isSessionReplayForErrorsEnabled()) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is disabled, no sample rate specified", new Object[0]);
            return;
        }
        this.hub = hub;
        Object object2 = this.recorderProvider;
        if (object2 == null || (object2 = (Recorder)object2.invoke()) == null) {
            object2 = this.recorder = (Recorder)new WindowRecorder(options, this, this.mainLooperHandler);
        }
        if ((object = this.gestureRecorderProvider) == null || (object = (GestureRecorder)object.invoke()) == null) {
            object = new GestureRecorder(options, this);
        }
        this.gestureRecorder = object;
        this.isEnabled.set(true);
        try {
            this.context.registerComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.INFO, "ComponentCallbacks is not available, orientation changes won't be handled by Session replay", e);
        }
        IntegrationUtils.addIntegrationToSdkVersion((String)"Replay");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-replay", "7.16.0-alpha.1");
        this.finalizePreviousReplay();
    }

    public boolean isRecording() {
        return this.isRecording.get();
    }

    public void start() {
        Object object;
        Object object2;
        boolean isFullSession;
        if (!this.isEnabled.get()) {
            return;
        }
        if (this.isRecording.getAndSet(true)) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Session replay is already being recorded, not starting a new one", new Object[0]);
            return;
        }
        Random random2 = this.getRandom();
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        if (!(isFullSession = SamplingKt.sample(random2, sentryOptions.getExperimental().getSessionReplay().getSessionSampleRate()))) {
            SentryOptions sentryOptions2 = this.options;
            if (sentryOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions2 = null;
            }
            if (!sentryOptions2.getExperimental().getSessionReplay().isSessionReplayForErrorsEnabled()) {
                SentryOptions sentryOptions3 = this.options;
                if (sentryOptions3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions3 = null;
                }
                sentryOptions3.getLogger().log(SentryLevel.INFO, "Session replay is not started, full session was not sampled and onErrorSampleRate is not specified", new Object[0]);
                return;
            }
        }
        if ((object2 = this.recorderConfigProvider) == null || (object2 = (ScreenshotRecorderConfig)object2.invoke((Object)false)) == null) {
            SentryOptions sentryOptions4 = this.options;
            if (sentryOptions4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions4 = null;
            }
            SentryReplayOptions sentryReplayOptions = sentryOptions4.getExperimental().getSessionReplay();
            Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"options.experimental.sessionReplay");
            object2 = this.recorderConfig = ScreenshotRecorderConfig.Companion.from(this.context, sentryReplayOptions);
        }
        if ((object = this.replayCaptureStrategyProvider) == null || (object = (CaptureStrategy)object.invoke((Object)isFullSession)) == null) {
            BaseCaptureStrategy baseCaptureStrategy;
            if (isFullSession) {
                SentryOptions sentryOptions5 = this.options;
                if (sentryOptions5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions5 = null;
                }
                baseCaptureStrategy = new SessionCaptureStrategy(sentryOptions5, this.hub, this.dateProvider, null, this.replayCacheProvider, 8, null);
            } else {
                SentryOptions sentryOptions6 = this.options;
                if (sentryOptions6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions6 = null;
                }
                baseCaptureStrategy = new BufferCaptureStrategy(sentryOptions6, this.hub, this.dateProvider, this.getRandom(), null, this.replayCacheProvider, 16, null);
            }
            object = baseCaptureStrategy;
        }
        this.captureStrategy = object;
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (captureStrategy != null) {
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            CaptureStrategy.DefaultImpls.start$default(captureStrategy, screenshotRecorderConfig, 0, null, null, 14, null);
        }
        Recorder recorder2 = this.recorder;
        if (recorder2 != null) {
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            recorder2.start(screenshotRecorderConfig);
        }
        this.registerRootViewListeners();
    }

    public void resume() {
        block2: {
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                captureStrategy.resume();
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 == null) break block2;
            recorder2.resume();
        }
    }

    public void captureReplay(@Nullable Boolean isTerminating) {
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (SentryId.EMPTY_ID.equals(captureStrategy != null ? captureStrategy.getCurrentReplayId() : null)) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Replay id is not set, not capturing for event", new Object[0]);
            return;
        }
        CaptureStrategy captureStrategy2 = this.captureStrategy;
        if (captureStrategy2 != null) {
            captureStrategy2.captureReplay(Intrinsics.areEqual((Object)isTerminating, (Object)true), (Function1<? super Date, Unit>)((Function1)new Function1<Date, Unit>(this){
                final /* synthetic */ ReplayIntegration this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Date newTimestamp) {
                    Intrinsics.checkNotNullParameter((Object)newTimestamp, (String)"newTimestamp");
                    CaptureStrategy captureStrategy = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                    if (captureStrategy != null) {
                        CaptureStrategy captureStrategy2 = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                        Integer n = captureStrategy2 != null ? Integer.valueOf(captureStrategy2.getCurrentSegment()) : null;
                        Intrinsics.checkNotNull((Object)n);
                        captureStrategy.setCurrentSegment(n + 1);
                    }
                    CaptureStrategy captureStrategy3 = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                    if (captureStrategy3 != null) {
                        captureStrategy3.setSegmentTimestamp(newTimestamp);
                    }
                }
            }));
        }
        CaptureStrategy captureStrategy3 = this.captureStrategy;
        this.captureStrategy = captureStrategy3 != null ? captureStrategy3.convert() : null;
    }

    @NotNull
    public SentryId getReplayId() {
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (captureStrategy == null || (captureStrategy = captureStrategy.getCurrentReplayId()) == null) {
            SentryId sentryId = SentryId.EMPTY_ID;
            captureStrategy = sentryId;
            Intrinsics.checkNotNullExpressionValue((Object)sentryId, (String)"EMPTY_ID");
        }
        return captureStrategy;
    }

    public void setBreadcrumbConverter(@NotNull ReplayBreadcrumbConverter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.replayBreadcrumbConverter = converter;
    }

    @NotNull
    public ReplayBreadcrumbConverter getBreadcrumbConverter() {
        return this.replayBreadcrumbConverter;
    }

    public void pause() {
        block2: {
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 != null) {
                recorder2.pause();
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block2;
            captureStrategy.pause();
        }
    }

    public void stop() {
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        this.unregisterRootViewListeners();
        Recorder recorder2 = this.recorder;
        if (recorder2 != null) {
            recorder2.stop();
        }
        GestureRecorder gestureRecorder = this.gestureRecorder;
        if (gestureRecorder != null) {
            gestureRecorder.stop();
        }
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (captureStrategy != null) {
            captureStrategy.stop();
        }
        this.isRecording.set(false);
        CaptureStrategy captureStrategy2 = this.captureStrategy;
        if (captureStrategy2 != null) {
            captureStrategy2.close();
        }
        this.captureStrategy = null;
    }

    @Override
    public void onScreenshotRecorded(@NotNull Bitmap bitmap) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Ref.ObjectRef screen = new Ref.ObjectRef();
            IHub iHub = this.hub;
            if (iHub != null) {
                iHub.configureScope(arg_0 -> ReplayIntegration.onScreenshotRecorded$lambda$0(screen, arg_0));
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block1;
            captureStrategy.onScreenshotRecorded(bitmap, (Function2<? super ReplayCache, ? super Long, Unit>)((Function2)new Function2<ReplayCache, Long, Unit>(bitmap, (Ref.ObjectRef<String>)screen){
                final /* synthetic */ Bitmap $bitmap;
                final /* synthetic */ Ref.ObjectRef<String> $screen;
                {
                    this.$bitmap = $bitmap;
                    this.$screen = $screen;
                    super(2);
                }

                public final void invoke(@NotNull ReplayCache $this$onScreenshotRecorded, long frameTimeStamp) {
                    Intrinsics.checkNotNullParameter((Object)$this$onScreenshotRecorded, (String)"$this$onScreenshotRecorded");
                    $this$onScreenshotRecorded.addFrame$sentry_android_replay_release(this.$bitmap, frameTimeStamp, (String)this.$screen.element);
                }
            }));
        }
    }

    @Override
    public void onScreenshotRecorded(@NotNull File screenshot, long frameTimestamp) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block0;
            CaptureStrategy.DefaultImpls.onScreenshotRecorded$default(captureStrategy, null, (Function2)new Function2<ReplayCache, Long, Unit>(screenshot, frameTimestamp){
                final /* synthetic */ File $screenshot;
                final /* synthetic */ long $frameTimestamp;
                {
                    this.$screenshot = $screenshot;
                    this.$frameTimestamp = $frameTimestamp;
                    super(2);
                }

                public final void invoke(@NotNull ReplayCache $this$onScreenshotRecorded, long l) {
                    Intrinsics.checkNotNullParameter((Object)$this$onScreenshotRecorded, (String)"$this$onScreenshotRecorded");
                    ReplayCache.addFrame$default($this$onScreenshotRecorded, this.$screenshot, this.$frameTimestamp, null, 4, null);
                }
            }, 1, null);
        }
    }

    @Override
    public void close() {
        if (!this.isEnabled.get()) {
            return;
        }
        try {
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stop();
        Recorder recorder2 = this.recorder;
        if (recorder2 != null) {
            recorder2.close();
        }
        this.recorder = null;
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 != null) {
                recorder2.stop();
            }
            if ((object = this.recorderConfigProvider) == null || (object = (ScreenshotRecorderConfig)object.invoke((Object)true)) == null) {
                SentryOptions sentryOptions = this.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                SentryReplayOptions sentryReplayOptions = sentryOptions.getExperimental().getSessionReplay();
                Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"options.experimental.sessionReplay");
                object = ScreenshotRecorderConfig.Companion.from(this.context, sentryReplayOptions);
            }
            this.recorderConfig = object;
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
                if (screenshotRecorderConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                    screenshotRecorderConfig = null;
                }
                captureStrategy.onConfigurationChanged(screenshotRecorderConfig);
            }
            Recorder recorder3 = this.recorder;
            if (recorder3 == null) break block7;
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            recorder3.start(screenshotRecorderConfig);
        }
    }

    public void onLowMemory() {
    }

    @Override
    public void onTouchEvent(@NotNull MotionEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block0;
            captureStrategy.onTouchEvent(event);
        }
    }

    private final void registerRootViewListeners() {
        if (this.recorder instanceof OnRootViewsChangedListener) {
            Collection collection = this.getRootViewsSpy().getListeners();
            Recorder recorder2 = this.recorder;
            Intrinsics.checkNotNull((Object)recorder2, (String)"null cannot be cast to non-null type io.sentry.android.replay.OnRootViewsChangedListener");
            collection.add((OnRootViewsChangedListener)((Object)recorder2));
        }
        ((Collection)this.getRootViewsSpy().getListeners()).add(this.gestureRecorder);
    }

    private final void unregisterRootViewListeners() {
        if (this.recorder instanceof OnRootViewsChangedListener) {
            Collection collection = this.getRootViewsSpy().getListeners();
            Recorder recorder2 = this.recorder;
            Intrinsics.checkNotNull((Object)recorder2, (String)"null cannot be cast to non-null type io.sentry.android.replay.OnRootViewsChangedListener");
            collection.remove((OnRootViewsChangedListener)((Object)recorder2));
        }
        ((Collection)this.getRootViewsSpy().getListeners()).remove(this.gestureRecorder);
    }

    private final void cleanupReplays(String unfinishedReplayId) {
        block3: {
            File[] fileArray;
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            String string = sentryOptions.getCacheDirPath();
            if (string == null) break block3;
            String cacheDir = string;
            boolean bl = false;
            if (fileArray != null) {
                fileArray = new File(cacheDir).listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles()");
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    String name = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    if (!StringsKt.startsWith$default((String)name, (String)"replay_", (boolean)false, (int)2, null)) continue;
                    CharSequence charSequence = name;
                    String string2 = this.getReplayId().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replayId.toString()");
                    if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null) || !StringsKt.isBlank((CharSequence)unfinishedReplayId) && StringsKt.contains$default((CharSequence)name, (CharSequence)unfinishedReplayId, (boolean)false, (int)2, null)) continue;
                    FileUtils.deleteRecursively((File)file);
                }
            }
        }
    }

    static /* synthetic */ void cleanupReplays$default(ReplayIntegration replayIntegration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        replayIntegration.cleanupReplays(string);
    }

    private final void finalizePreviousReplay() {
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        ISentryExecutorService iSentryExecutorService = sentryOptions.getExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)iSentryExecutorService, (String)"options.executorService");
        SentryOptions sentryOptions2 = this.options;
        if (sentryOptions2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions2 = null;
        }
        ExecutorsKt.submitSafely(iSentryExecutorService, sentryOptions2, "ReplayIntegration.finalize_previous_replay", () -> ReplayIntegration.finalizePreviousReplay$lambda$5(this));
    }

    private static final void onScreenshotRecorded$lambda$0(Ref.ObjectRef $screen, IScope it) {
        Intrinsics.checkNotNullParameter((Object)$screen, (String)"$screen");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getScreen();
        $screen.element = string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null;
    }

    private static final void finalizePreviousReplay$lambda$5(ReplayIntegration this$0) {
        LinkedList<RRWebEvent> linkedList;
        String string;
        Object $this$finalizePreviousReplay_u24lambda_u245_u24lambda_u2432;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SentryOptions sentryOptions = this$0.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        String string2 = (String)PersistingScopeObserver.read((SentryOptions)sentryOptions, (String)"replay.json", String.class);
        if (string2 == null) {
            ReplayIntegration $this$finalizePreviousReplay_u24lambda_u245_u24lambda_u2432 = this$0;
            boolean bl = false;
            ReplayIntegration.cleanupReplays$default($this$finalizePreviousReplay_u24lambda_u245_u24lambda_u2432, null, 1, null);
            return;
        }
        String previousReplayIdString = string2;
        SentryId previousReplayId = new SentryId(previousReplayIdString);
        if (Intrinsics.areEqual((Object)previousReplayId, (Object)SentryId.EMPTY_ID)) {
            ReplayIntegration.cleanupReplays$default(this$0, null, 1, null);
            return;
        }
        SentryOptions sentryOptions2 = this$0.options;
        if (sentryOptions2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions2 = null;
        }
        LastSegmentData lastSegmentData = ReplayCache.Companion.fromDisk$sentry_android_replay_release(sentryOptions2, previousReplayId, this$0.replayCacheProvider);
        if (lastSegmentData == null) {
            ReplayIntegration $this$finalizePreviousReplay_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            ReplayIntegration.cleanupReplays$default($this$finalizePreviousReplay_u24lambda_u245_u24lambda_u244, null, 1, null);
            return;
        }
        LastSegmentData lastSegment = lastSegmentData;
        SentryOptions sentryOptions3 = this$0.options;
        if (sentryOptions3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions3 = null;
        }
        List breadcrumbs = ($this$finalizePreviousReplay_u24lambda_u245_u24lambda_u2432 = PersistingScopeObserver.read((SentryOptions)sentryOptions3, (String)"breadcrumbs.json", List.class, (JsonDeserializer)((JsonDeserializer)new Breadcrumb.Deserializer()))) instanceof List ? (List)$this$finalizePreviousReplay_u24lambda_u245_u24lambda_u2432 : null;
        CaptureStrategy.Companion $this$finalizePreviousReplay_u24lambda_u245_u24lambda_u244 = CaptureStrategy.Companion;
        IHub iHub = this$0.hub;
        SentryOptions sentryOptions4 = this$0.options;
        if (sentryOptions4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions4 = null;
        }
        SentryOptions sentryOptions5 = sentryOptions4;
        long l = lastSegment.getDuration();
        Date date = lastSegment.getTimestamp();
        int n = lastSegment.getId();
        int n2 = lastSegment.getRecorderConfig().getRecordingHeight();
        int n3 = lastSegment.getRecorderConfig().getRecordingWidth();
        int n4 = lastSegment.getRecorderConfig().getFrameRate();
        ReplayCache replayCache = lastSegment.getCache();
        SentryReplayEvent.ReplayType replayType = lastSegment.getReplayType();
        CaptureStrategy.ReplaySegment segment = $this$finalizePreviousReplay_u24lambda_u245_u24lambda_u244.createSegment(iHub, sentryOptions5, l, date, previousReplayId, n, n2, n3, replayType, replayCache, n4, string = lastSegment.getScreenAtStart(), breadcrumbs, linkedList = new LinkedList<RRWebEvent>((Collection)lastSegment.getEvents()));
        if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
            Hint hint = HintUtils.createWithTypeCheckHint((Object)new PreviousReplayHint());
            CaptureStrategy.ReplaySegment.Created created = (CaptureStrategy.ReplaySegment.Created)segment;
            IHub iHub2 = this$0.hub;
            Intrinsics.checkNotNullExpressionValue((Object)hint, (String)"hint");
            created.capture(iHub2, hint);
        }
        this$0.cleanupReplays(previousReplayIdString);
    }

    public static final /* synthetic */ CaptureStrategy access$getCaptureStrategy$p(ReplayIntegration $this) {
        return $this.captureStrategy;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/ReplayIntegration$PreviousReplayHint;", "Lio/sentry/hints/Backfillable;", "()V", "shouldEnrich", "", "sentry-android-replay_release"})
    private static final class PreviousReplayHint
    implements Backfillable {
        public boolean shouldEnrich() {
            return false;
        }
    }
}

