/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.ndk.DebugImage;
import io.sentry.ndk.NativeModuleListLoader;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DebugImagesLoader
implements IDebugImagesLoader {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final NativeModuleListLoader moduleListLoader;
    @Nullable
    private static volatile List<io.sentry.protocol.DebugImage> debugImages;
    @NotNull
    protected static final AutoClosableReentrantLock debugImagesLock;

    public DebugImagesLoader(@NotNull SentryAndroidOptions options, @NotNull NativeModuleListLoader moduleListLoader) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"The SentryAndroidOptions is required.");
        this.moduleListLoader = (NativeModuleListLoader)Objects.requireNonNull((Object)moduleListLoader, (String)"The NativeModuleListLoader is required.");
    }

    @Nullable
    public List<io.sentry.protocol.DebugImage> loadDebugImages() {
        block10: {
            try (@NotNull ISentryLifecycleToken ignored = debugImagesLock.acquire();){
                if (debugImages != null) break block10;
                try {
                    DebugImage[] debugImagesArr = this.moduleListLoader.loadModuleList();
                    if (debugImagesArr != null) {
                        debugImages = new ArrayList<io.sentry.protocol.DebugImage>(debugImagesArr.length);
                        for (DebugImage d : debugImagesArr) {
                            io.sentry.protocol.DebugImage debugImage = new io.sentry.protocol.DebugImage();
                            debugImage.setCodeFile(d.getCodeFile());
                            debugImage.setDebugFile(d.getDebugFile());
                            debugImage.setUuid(d.getUuid());
                            debugImage.setType(d.getType());
                            debugImage.setDebugId(d.getDebugId());
                            debugImage.setCodeId(d.getCodeId());
                            debugImage.setImageAddr(d.getImageAddr());
                            debugImage.setImageSize(d.getImageSize());
                            debugImage.setArch(d.getArch());
                            debugImages.add(debugImage);
                        }
                        this.options.getLogger().log(SentryLevel.DEBUG, "Debug images loaded: %d", new Object[]{debugImages.size()});
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to load debug images.", new Object[0]);
                }
            }
        }
        return debugImages;
    }

    @Nullable
    public Set<io.sentry.protocol.DebugImage> loadDebugImagesForAddresses(@NotNull Set<String> addresses) {
        try (@NotNull ISentryLifecycleToken ignored = debugImagesLock.acquire();){
            @Nullable List<io.sentry.protocol.DebugImage> allDebugImages = this.loadDebugImages();
            if (allDebugImages == null) {
                Set<io.sentry.protocol.DebugImage> set = null;
                return set;
            }
            if (addresses.isEmpty()) {
                Set<io.sentry.protocol.DebugImage> set = null;
                return set;
            }
            Set<io.sentry.protocol.DebugImage> referencedImages = this.filterImagesByAddresses(allDebugImages, addresses);
            if (referencedImages.isEmpty()) {
                this.options.getLogger().log(SentryLevel.WARNING, "No debug images found for any of the %d addresses.", new Object[]{addresses.size()});
                Set<io.sentry.protocol.DebugImage> set = null;
                return set;
            }
            Set<io.sentry.protocol.DebugImage> set = referencedImages;
            return set;
        }
    }

    @NotNull
    private Set<io.sentry.protocol.DebugImage> filterImagesByAddresses(@NotNull List<io.sentry.protocol.DebugImage> images, @NotNull Set<String> addresses) {
        HashSet<io.sentry.protocol.DebugImage> result = new HashSet<io.sentry.protocol.DebugImage>();
        block4: for (int i = 0; i < images.size(); ++i) {
            @NotNull io.sentry.protocol.DebugImage image = images.get(i);
            io.sentry.protocol.DebugImage nextDebugImage = i + 1 < images.size() ? images.get(i + 1) : null;
            String nextDebugImageAddress = nextDebugImage != null ? nextDebugImage.getImageAddr() : null;
            for (String rawAddress : addresses) {
                try {
                    long address = Long.parseLong(rawAddress.replace("0x", ""), 16);
                    @Nullable String imageAddress = image.getImageAddr();
                    if (imageAddress == null) continue;
                    try {
                        long imageStart = Long.parseLong(imageAddress.replace("0x", ""), 16);
                        @Nullable Long imageSize = image.getImageSize();
                        long imageEnd = imageSize != null ? imageStart + imageSize : (nextDebugImageAddress != null ? Long.parseLong(nextDebugImageAddress.replace("0x", ""), 16) : Long.MAX_VALUE);
                        if (address < imageStart || address >= imageEnd) continue;
                        result.add(image);
                        continue block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return result;
    }

    public void clearDebugImages() {
        try (@NotNull ISentryLifecycleToken ignored = debugImagesLock.acquire();){
            try {
                this.moduleListLoader.clearModuleList();
                this.options.getLogger().log(SentryLevel.INFO, "Debug images cleared.", new Object[0]);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to clear debug images.", new Object[0]);
            }
            debugImages = null;
        }
    }

    @VisibleForTesting
    @Nullable
    List<io.sentry.protocol.DebugImage> getCachedDebugImages() {
        return debugImages;
    }

    static {
        debugImagesLock = new AutoClosableReentrantLock();
    }
}

