/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.IScopeObserver;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.ndk.DebugImagesLoader;
import io.sentry.android.ndk.NdkScopeObserver;
import io.sentry.android.ndk.SentryNdkUtil;
import io.sentry.ndk.NativeModuleListLoader;
import io.sentry.ndk.NdkOptions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SentryNdk {
    private SentryNdk() {
    }

    public static void init(@NotNull SentryAndroidOptions options) {
        SentryNdkUtil.addPackage(options.getSdkVersion());
        @NotNull NdkOptions ndkOptions = new NdkOptions(options.getDsn(), options.isDebug(), options.getOutboxPath(), options.getRelease(), options.getEnvironment(), options.getDist(), options.getMaxBreadcrumbs(), options.getNativeSdkName());
        io.sentry.ndk.SentryNdk.init((NdkOptions)ndkOptions);
        if (options.isEnableScopeSync()) {
            options.addScopeObserver((IScopeObserver)new NdkScopeObserver((SentryOptions)options));
        }
        options.setDebugImagesLoader((IDebugImagesLoader)new DebugImagesLoader(options, new NativeModuleListLoader()));
    }

    public static void close() {
        io.sentry.ndk.SentryNdk.close();
    }
}

