/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.CompositePerformanceCollector;
import io.sentry.DataCategory;
import io.sentry.IConnectionStatusProvider;
import io.sentry.IContinuousProfiler;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.NoOpScopes;
import io.sentry.ProfileChunk;
import io.sentry.ProfileLifecycle;
import io.sentry.Sentry;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryNanotimeDate;
import io.sentry.SentryOptions;
import io.sentry.TracesSampler;
import io.sentry.android.core.AndroidProfiler;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.protocol.SentryId;
import io.sentry.transport.RateLimiter;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.SentryRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class AndroidContinuousProfiler
implements IContinuousProfiler,
RateLimiter.IRateLimitObserver {
    private static final long MAX_CHUNK_DURATION_MILLIS = 60000L;
    @NotNull
    private final ILogger logger;
    @Nullable
    private final String profilingTracesDirPath;
    private final int profilingTracesHz;
    @NotNull
    private final ISentryExecutorService executorService;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean isInitialized = false;
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private AndroidProfiler profiler = null;
    private boolean isRunning = false;
    @Nullable
    private IScopes scopes;
    @Nullable
    private Future<?> stopFuture;
    @Nullable
    private CompositePerformanceCollector performanceCollector;
    @NotNull
    private final List<ProfileChunk.Builder> payloadBuilders = new ArrayList<ProfileChunk.Builder>();
    @NotNull
    private SentryId profilerId = SentryId.EMPTY_ID;
    @NotNull
    private SentryId chunkId = SentryId.EMPTY_ID;
    @NotNull
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    @NotNull
    private SentryDate startProfileChunkTimestamp = new SentryNanotimeDate();
    private volatile boolean shouldSample = true;
    private boolean shouldStop = false;
    private boolean isSampled = false;
    private int rootSpanCounter = 0;
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    private final AutoClosableReentrantLock payloadLock = new AutoClosableReentrantLock();

    public AndroidContinuousProfiler(@NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull ILogger logger, @Nullable String profilingTracesDirPath, int profilingTracesHz, @NotNull ISentryExecutorService executorService) {
        this.logger = logger;
        this.frameMetricsCollector = frameMetricsCollector;
        this.buildInfoProvider = buildInfoProvider;
        this.profilingTracesDirPath = profilingTracesDirPath;
        this.profilingTracesHz = profilingTracesHz;
        this.executorService = executorService;
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        if (this.profilingTracesDirPath == null) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        if (this.profilingTracesHz <= 0) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because trace rate is set to %d", new Object[]{this.profilingTracesHz});
            return;
        }
        this.profiler = new AndroidProfiler(this.profilingTracesDirPath, (int)TimeUnit.SECONDS.toMicros(1L) / this.profilingTracesHz, this.frameMetricsCollector, null, this.logger);
    }

    public void startProfiler(@NotNull ProfileLifecycle profileLifecycle, @NotNull TracesSampler tracesSampler) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.shouldSample) {
                this.isSampled = tracesSampler.sampleSessionProfile(SentryRandom.current().nextDouble());
                this.shouldSample = false;
            }
            if (!this.isSampled) {
                this.logger.log(SentryLevel.DEBUG, "Profiler was not started due to sampling decision.", new Object[0]);
                return;
            }
            switch (profileLifecycle) {
                case TRACE: {
                    if (this.rootSpanCounter < 0) {
                        this.rootSpanCounter = 0;
                    }
                    ++this.rootSpanCounter;
                    break;
                }
                case MANUAL: {
                    if (!this.isRunning()) break;
                    this.logger.log(SentryLevel.DEBUG, "Profiler is already running.", new Object[0]);
                    return;
                }
            }
            if (!this.isRunning()) {
                this.logger.log(SentryLevel.DEBUG, "Started Profiler.", new Object[0]);
                this.start();
            }
        }
    }

    private void start() {
        RateLimiter rateLimiter;
        if ((this.scopes == null || this.scopes == NoOpScopes.getInstance()) && Sentry.getCurrentScopes() != NoOpScopes.getInstance()) {
            this.scopes = Sentry.getCurrentScopes();
            this.performanceCollector = Sentry.getCurrentScopes().getOptions().getCompositePerformanceCollector();
            rateLimiter = this.scopes.getRateLimiter();
            if (rateLimiter != null) {
                rateLimiter.addRateLimitObserver((RateLimiter.IRateLimitObserver)this);
            }
        }
        if (this.buildInfoProvider.getSdkInfoVersion() < 22) {
            return;
        }
        this.init();
        if (this.profiler == null) {
            return;
        }
        if (this.scopes != null) {
            rateLimiter = this.scopes.getRateLimiter();
            if (rateLimiter != null && (rateLimiter.isActiveForCategory(DataCategory.All) || rateLimiter.isActiveForCategory(DataCategory.ProfileChunk))) {
                this.logger.log(SentryLevel.WARNING, "SDK is rate limited. Stopping profiler.", new Object[0]);
                this.stop(false);
                return;
            }
            if (this.scopes.getOptions().getConnectionStatusProvider().getConnectionStatus() == IConnectionStatusProvider.ConnectionStatus.DISCONNECTED) {
                this.logger.log(SentryLevel.WARNING, "Device is offline. Stopping profiler.", new Object[0]);
                this.stop(false);
                return;
            }
            this.startProfileChunkTimestamp = this.scopes.getOptions().getDateProvider().now();
        } else {
            this.startProfileChunkTimestamp = new SentryNanotimeDate();
        }
        AndroidProfiler.ProfileStartData startData = this.profiler.start();
        if (startData == null) {
            return;
        }
        this.isRunning = true;
        if (this.profilerId == SentryId.EMPTY_ID) {
            this.profilerId = new SentryId();
        }
        if (this.chunkId == SentryId.EMPTY_ID) {
            this.chunkId = new SentryId();
        }
        if (this.performanceCollector != null) {
            this.performanceCollector.start(this.chunkId.toString());
        }
        try {
            this.stopFuture = this.executorService.schedule(() -> this.stop(true), 60000L);
        }
        catch (RejectedExecutionException e) {
            this.logger.log(SentryLevel.ERROR, "Failed to schedule profiling chunk finish. Did you call Sentry.close()?", (Throwable)e);
            this.shouldStop = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopProfiler(@NotNull ProfileLifecycle profileLifecycle) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            switch (profileLifecycle) {
                case TRACE: {
                    --this.rootSpanCounter;
                    if (this.rootSpanCounter > 0) {
                        return;
                    }
                    if (this.rootSpanCounter < 0) {
                        this.rootSpanCounter = 0;
                    }
                    this.shouldStop = true;
                    return;
                }
                case MANUAL: {
                    this.shouldStop = true;
                    return;
                }
            }
            return;
        }
    }

    private void stop(boolean restartProfiler) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            AndroidProfiler.ProfileEndData endData;
            if (this.stopFuture != null) {
                this.stopFuture.cancel(true);
            }
            if (this.profiler == null || !this.isRunning) {
                this.profilerId = SentryId.EMPTY_ID;
                this.chunkId = SentryId.EMPTY_ID;
                return;
            }
            if (this.buildInfoProvider.getSdkInfoVersion() < 22) {
                return;
            }
            List performanceCollectionData = null;
            if (this.performanceCollector != null) {
                performanceCollectionData = this.performanceCollector.stop(this.chunkId.toString());
            }
            if ((endData = this.profiler.endAndCollect(false, performanceCollectionData)) == null) {
                this.logger.log(SentryLevel.ERROR, "An error occurred while collecting a profile chunk, and it won't be sent.", new Object[0]);
            } else {
                try (@NotNull ISentryLifecycleToken ignored2 = this.payloadLock.acquire();){
                    this.payloadBuilders.add(new ProfileChunk.Builder(this.profilerId, this.chunkId, endData.measurementsMap, endData.traceFile, this.startProfileChunkTimestamp));
                }
            }
            this.isRunning = false;
            this.chunkId = SentryId.EMPTY_ID;
            if (this.scopes != null) {
                this.sendChunks(this.scopes, this.scopes.getOptions());
            }
            if (restartProfiler && !this.shouldStop) {
                this.logger.log(SentryLevel.DEBUG, "Profile chunk finished. Starting a new one.", new Object[0]);
                this.start();
            } else {
                this.profilerId = SentryId.EMPTY_ID;
                this.logger.log(SentryLevel.DEBUG, "Profile chunk finished.", new Object[0]);
            }
        }
    }

    public void reevaluateSampling() {
        this.shouldSample = true;
    }

    public void close(boolean isTerminating) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            this.rootSpanCounter = 0;
            this.shouldStop = true;
            if (isTerminating) {
                this.stop(false);
                this.isClosed.set(true);
            }
        }
    }

    @NotNull
    public SentryId getProfilerId() {
        return this.profilerId;
    }

    private void sendChunks(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        try {
            options.getExecutorService().submit(() -> {
                if (this.isClosed.get()) {
                    return;
                }
                ArrayList<ProfileChunk> payloads = new ArrayList<ProfileChunk>(this.payloadBuilders.size());
                try (@NotNull ISentryLifecycleToken ignored = this.payloadLock.acquire();){
                    for (ProfileChunk.Builder builder : this.payloadBuilders) {
                        payloads.add(builder.build(options));
                    }
                    this.payloadBuilders.clear();
                }
                for (ProfileChunk payload : payloads) {
                    scopes.captureProfileChunk(payload);
                }
            });
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.DEBUG, "Failed to send profile chunks.", e);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @VisibleForTesting
    @Nullable
    Future<?> getStopFuture() {
        return this.stopFuture;
    }

    @VisibleForTesting
    public int getRootSpanCounter() {
        return this.rootSpanCounter;
    }

    public void onRateLimitChanged(@NotNull RateLimiter rateLimiter) {
        if (rateLimiter.isActiveForCategory(DataCategory.All) || rateLimiter.isActiveForCategory(DataCategory.ProfileChunk)) {
            this.logger.log(SentryLevel.WARNING, "SDK is rate limited. Stopping profiler.", new Object[0]);
            this.stop(false);
        }
    }
}

