/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.content.ContentProvider;
import io.sentry.ILogger;
import io.sentry.NoOpLogger;
import io.sentry.android.core.BuildInfoProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ContentProviderSecurityChecker {
    @NotNull
    private final BuildInfoProvider buildInfoProvider;

    public ContentProviderSecurityChecker() {
        this(new BuildInfoProvider((ILogger)NoOpLogger.getInstance()));
    }

    public ContentProviderSecurityChecker(@NotNull BuildInfoProvider buildInfoProvider) {
        this.buildInfoProvider = buildInfoProvider;
    }

    @SuppressLint(value={"NewApi"})
    public void checkPrivilegeEscalation(@NotNull ContentProvider contentProvider) {
        int sdkVersion = this.buildInfoProvider.getSdkInfoVersion();
        if (sdkVersion >= 26 && sdkVersion <= 28) {
            String callingPackage = contentProvider.getCallingPackage();
            String appPackage = contentProvider.getContext().getPackageName();
            if (callingPackage != null && callingPackage.equals(appPackage)) {
                return;
            }
            throw new SecurityException("Provider does not allow for granting of Uri permissions");
        }
    }
}

