/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.tombstone;

import androidx.annotation.NonNull;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.internal.tombstone.TombstoneProtos;
import io.sentry.android.core.internal.util.NativeEventUtils;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Message;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TombstoneParser
implements Closeable {
    private final InputStream tombstoneStream;
    private final Map<String, String> excTypeValueMap = new HashMap<String, String>();

    private static String formatHex(long value) {
        return String.format("0x%x", value);
    }

    public TombstoneParser(@NonNull InputStream tombstoneStream) {
        this.tombstoneStream = tombstoneStream;
        this.excTypeValueMap.put("SIGILL", "IllegalInstruction");
        this.excTypeValueMap.put("SIGTRAP", "Trap");
        this.excTypeValueMap.put("SIGABRT", "Abort");
        this.excTypeValueMap.put("SIGBUS", "BusError");
        this.excTypeValueMap.put("SIGFPE", "FloatingPointException");
        this.excTypeValueMap.put("SIGSEGV", "Segfault");
    }

    @NonNull
    public SentryEvent parse() throws IOException {
        TombstoneProtos.Tombstone tombstone = TombstoneProtos.Tombstone.parseFrom(this.tombstoneStream);
        SentryEvent event = new SentryEvent();
        event.setLevel(SentryLevel.FATAL);
        event.setPlatform("native");
        event.setMessage(this.constructMessage(tombstone));
        event.setDebugMeta(this.createDebugMeta(tombstone));
        event.setExceptions(this.createException(tombstone));
        event.setThreads(this.createThreads(tombstone, (SentryException)Objects.requireNonNull(event.getExceptions()).get(0)));
        return event;
    }

    @NonNull
    private List<SentryThread> createThreads(@NonNull TombstoneProtos.Tombstone tombstone, @NonNull SentryException exc) {
        ArrayList<SentryThread> threads = new ArrayList<SentryThread>();
        for (Map.Entry<Integer, TombstoneProtos.Thread> threadEntry : tombstone.getThreadsMap().entrySet()) {
            TombstoneProtos.Thread threadEntryValue = threadEntry.getValue();
            SentryThread thread = new SentryThread();
            thread.setId(Long.valueOf(threadEntry.getKey().intValue()));
            thread.setName(threadEntryValue.getName());
            SentryStackTrace stacktrace = TombstoneParser.createStackTrace(threadEntryValue);
            thread.setStacktrace(stacktrace);
            if (tombstone.getTid() == threadEntryValue.getId()) {
                thread.setCrashed(Boolean.valueOf(true));
                exc.setStacktrace(stacktrace);
            }
            threads.add(thread);
        }
        return threads;
    }

    @NonNull
    private static SentryStackTrace createStackTrace(@NonNull TombstoneProtos.Thread thread) {
        ArrayList<SentryStackFrame> frames = new ArrayList<SentryStackFrame>();
        for (TombstoneProtos.BacktraceFrame frame : thread.getCurrentBacktraceList()) {
            SentryStackFrame stackFrame = new SentryStackFrame();
            stackFrame.setPackage(frame.getFileName());
            stackFrame.setFunction(frame.getFunctionName());
            stackFrame.setInstructionAddr(TombstoneParser.formatHex(frame.getPc()));
            frames.add(0, stackFrame);
        }
        SentryStackTrace stacktrace = new SentryStackTrace();
        stacktrace.setFrames(frames);
        stacktrace.setInstructionAddressAdjustment(SentryStackTrace.InstructionAddressAdjustment.NONE);
        HashMap<String, String> registers = new HashMap<String, String>();
        for (TombstoneProtos.Register register : thread.getRegistersList()) {
            registers.put(register.getName(), TombstoneParser.formatHex(register.getU64()));
        }
        stacktrace.setRegisters(registers);
        return stacktrace;
    }

    @NonNull
    private List<SentryException> createException(@NonNull TombstoneProtos.Tombstone tombstone) {
        SentryException exception = new SentryException();
        if (tombstone.hasSignalInfo()) {
            TombstoneProtos.Signal signalInfo = tombstone.getSignalInfo();
            exception.setType(signalInfo.getName());
            exception.setValue(this.excTypeValueMap.get(signalInfo.getName()));
            exception.setMechanism(TombstoneParser.createMechanismFromSignalInfo(signalInfo));
        }
        exception.setThreadId(Long.valueOf(tombstone.getTid()));
        ArrayList<SentryException> exceptions = new ArrayList<SentryException>(1);
        exceptions.add(exception);
        return exceptions;
    }

    @NonNull
    private static Mechanism createMechanismFromSignalInfo(@NonNull TombstoneProtos.Signal signalInfo) {
        Mechanism mechanism = new Mechanism();
        mechanism.setType("signalhandler");
        mechanism.setHandled(Boolean.valueOf(false));
        mechanism.setSynthetic(Boolean.valueOf(true));
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("number", signalInfo.getNumber());
        meta.put("name", signalInfo.getName());
        meta.put("code", signalInfo.getCode());
        meta.put("code_name", signalInfo.getCodeName());
        mechanism.setMeta(meta);
        return mechanism;
    }

    @NonNull
    private Message constructMessage(@NonNull TombstoneProtos.Tombstone tombstone) {
        Message message = new Message();
        TombstoneProtos.Signal signalInfo = tombstone.getSignalInfo();
        String command = String.join((CharSequence)" ", tombstone.getCommandLineList());
        if (tombstone.hasSignalInfo()) {
            String abortMessage = tombstone.getAbortMessage();
            message.setFormatted(String.format(Locale.ROOT, "%sFatal signal %s (%d), %s (%d), pid = %d (%s)", !abortMessage.isEmpty() ? abortMessage + ": " : "", signalInfo.getName(), signalInfo.getNumber(), signalInfo.getCodeName(), signalInfo.getCode(), tombstone.getPid(), command));
        } else {
            message.setFormatted(String.format(Locale.ROOT, "Fatal exit pid = %d (%s)", tombstone.getPid(), command));
        }
        return message;
    }

    private DebugMeta createDebugMeta(@NonNull TombstoneProtos.Tombstone tombstone) {
        ArrayList<DebugImage> images = new ArrayList<DebugImage>();
        for (TombstoneProtos.MemoryMapping module : tombstone.getMemoryMappingsList()) {
            if (module.getBuildId().isEmpty() || module.getMappingName().isEmpty() || !module.getExecute()) continue;
            DebugImage image = new DebugImage();
            String codeId = module.getBuildId();
            image.setCodeId(codeId);
            image.setCodeFile(module.getMappingName());
            String debugId = NativeEventUtils.buildIdToDebugId(codeId);
            image.setDebugId(debugId != null ? debugId : codeId);
            image.setImageAddr(TombstoneParser.formatHex(module.getBeginAddress()));
            image.setImageSize(module.getEndAddress() - module.getBeginAddress());
            image.setType("elf");
            images.add(image);
        }
        DebugMeta debugMeta = new DebugMeta();
        debugMeta.setImages(images);
        return debugMeta;
    }

    @Override
    public void close() throws IOException {
        this.tombstoneStream.close();
    }
}

